/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.Messages;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.SequenceResourceNaming;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.trans.TransMeta;

public class ResourceUtil {
    public static final TopLevelResource serializeResourceExportInterface(String zipFilename, ResourceExportInterface resourceExportInterface, VariableSpace space, Repository repository) throws KettleException {
        return ResourceUtil.serializeResourceExportInterface(zipFilename, resourceExportInterface, space, repository, null, null);
    }

    public static final TopLevelResource serializeResourceExportInterface(String zipFilename, ResourceExportInterface resourceExportInterface, VariableSpace space, Repository repository, String injectXML, String injectFilename) throws KettleException {
        ZipOutputStream out;
        block11: {
            TopLevelResource topLevelResource;
            block12: {
                SequenceResourceNaming namingInterface;
                String topLevelResource2;
                out = null;
                HashMap<String, ResourceDefinition> definitions = new HashMap<String, ResourceDefinition>();
                if (injectXML != null) {
                    ResourceDefinition resourceDefinition = new ResourceDefinition(injectFilename, injectXML);
                    definitions.put(injectFilename, resourceDefinition);
                }
                if ((topLevelResource2 = resourceExportInterface.exportResources(space, definitions, namingInterface = new SequenceResourceNaming(), repository)) == null || definitions.isEmpty()) break block11;
                FileObject fileObject = KettleVFS.getFileObject((String)zipFilename);
                out = new ZipOutputStream(KettleVFS.getOutputStream((FileObject)fileObject, (boolean)false));
                for (String filename : definitions.keySet()) {
                    ResourceDefinition resourceDefinition = (ResourceDefinition)definitions.get(filename);
                    ZipEntry zipEntry = new ZipEntry(resourceDefinition.getFilename());
                    String comment = Messages.getString("ResourceUtil.SerializeResourceExportInterface.ZipEntryComment.OriginatingFile", filename, Const.NVL((String)resourceDefinition.getOrigin(), (String)"-"));
                    zipEntry.setComment(comment);
                    out.putNextEntry(zipEntry);
                    out.write(resourceDefinition.getContent().getBytes());
                    out.closeEntry();
                }
                String zipURL = fileObject.getName().toString();
                topLevelResource = new TopLevelResource(topLevelResource2, zipURL, "zip:" + zipURL + "!" + topLevelResource2);
                Object var17_17 = null;
                if (out == null) break block12;
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new KettleException(Messages.getString("ResourceUtil.Exception.ErrorClosingZipStream", zipFilename));
                }
            }
            return topLevelResource;
        }
        try {
            try {
                throw new KettleException(Messages.getString("ResourceUtil.Exception.NoResourcesFoundToExport"));
            }
            catch (Exception e) {
                throw new KettleException(Messages.getString("ResourceUtil.Exception.ErrorSerializingExportInterface", resourceExportInterface.toString()), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new KettleException(Messages.getString("ResourceUtil.Exception.ErrorClosingZipStream", zipFilename));
                }
            }
            throw throwable;
        }
    }

    public static String getExplanation(String zipFilename, String launchFile, ResourceExportInterface resourceExportInterface) {
        String commandString = "";
        commandString = Const.isWindows() ? (resourceExportInterface instanceof TransMeta ? commandString + "Pan.bat /file:\"" : commandString + "Kitchen.bat /file:\"") : (resourceExportInterface instanceof TransMeta ? commandString + "sh pan.sh -file='" : commandString + "sh kitchen.sh -file='");
        commandString = commandString + launchFile;
        commandString = Const.isWindows() ? commandString + "\"" : commandString + "'";
        String message = Messages.getString("ResourceUtil.ExportResourcesExplanation", zipFilename, commandString, launchFile, Const.CR);
        return message;
    }
}

