/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DesktopUtils;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.lib.common.AttachSettings;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.common.event.ProfilingStateEvent;
import org.graalvm.visualvm.lib.common.event.ProfilingStateListener;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.profiler.NetBeansProfiler;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.lib.profiler.utilities.ProfilerUtils;
import org.graalvm.visualvm.profiler.CPULivePanel;
import org.graalvm.visualvm.profiler.CPUSettingsSupport;
import org.graalvm.visualvm.profiler.CalibrationSupport;
import org.graalvm.visualvm.profiler.JDBCLivePanel;
import org.graalvm.visualvm.profiler.JDBCSettingsSupport;
import org.graalvm.visualvm.profiler.LocksLivePanel;
import org.graalvm.visualvm.profiler.LocksSettingsSupport;
import org.graalvm.visualvm.profiler.MemoryLivePanel;
import org.graalvm.visualvm.profiler.MemorySettingsSupport;
import org.graalvm.visualvm.profiler.ProfilerSupport;
import org.graalvm.visualvm.profiler.ProfilingResultsSupport;
import org.graalvm.visualvm.profiling.presets.PresetSelector;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.graalvm.visualvm.profiling.presets.ProfilerPresets;
import org.graalvm.visualvm.uisupport.HTMLLabel;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class ApplicationProfilerView
extends DataSourceView {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/profiler/resources/profiler.png";
    private DataViewComponent dvc;
    private MasterViewSupport masterViewSupport;
    private CPUSettingsSupport cpuSettings;
    private MemorySettingsSupport memorySettings;
    private JDBCSettingsSupport jdbcSettings;
    private LocksSettingsSupport locksSettings;
    private DefaultComboBoxModel<ProfilerPreset> selectorModel;
    private List<PresetSelector> allSelectors;
    private boolean classSharingBreaksProfiling;
    private ProfilerPreset cachedPreset;
    private ProfilingSettings cachedSettings;

    ApplicationProfilerView(final Application application) {
        super((DataSource)application, NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profiler"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 40, false);
        this.cpuSettings = new CPUSettingsSupport(){

            @Override
            public boolean presetValid() {
                return ApplicationProfilerView.this.cpuSettings.settingsValid() && ApplicationProfilerView.this.memorySettings.settingsValid() && ApplicationProfilerView.this.jdbcSettings.settingsValid() && ApplicationProfilerView.this.locksSettings.settingsValid();
            }

            @Override
            public PresetSelector createSelector(Runnable presetSynchronizer) {
                return ApplicationProfilerView.this.createSelector(presetSynchronizer, application);
            }
        };
        this.memorySettings = new MemorySettingsSupport(){

            @Override
            public boolean presetValid() {
                return ApplicationProfilerView.this.cpuSettings.settingsValid() && ApplicationProfilerView.this.memorySettings.settingsValid() && ApplicationProfilerView.this.jdbcSettings.settingsValid() && ApplicationProfilerView.this.locksSettings.settingsValid();
            }

            @Override
            public PresetSelector createSelector(Runnable presetSynchronizer) {
                return ApplicationProfilerView.this.createSelector(presetSynchronizer, application);
            }
        };
        this.jdbcSettings = new JDBCSettingsSupport(){

            @Override
            public boolean presetValid() {
                return ApplicationProfilerView.this.cpuSettings.settingsValid() && ApplicationProfilerView.this.memorySettings.settingsValid() && ApplicationProfilerView.this.jdbcSettings.settingsValid() && ApplicationProfilerView.this.locksSettings.settingsValid();
            }

            @Override
            public PresetSelector createSelector(Runnable presetSynchronizer) {
                return ApplicationProfilerView.this.createSelector(presetSynchronizer, application);
            }
        };
        this.locksSettings = new LocksSettingsSupport(){

            @Override
            public boolean presetValid() {
                return ApplicationProfilerView.this.cpuSettings.settingsValid() && ApplicationProfilerView.this.memorySettings.settingsValid() && ApplicationProfilerView.this.jdbcSettings.settingsValid() && ApplicationProfilerView.this.locksSettings.settingsValid();
            }

            @Override
            public PresetSelector createSelector(Runnable presetSynchronizer) {
                return ApplicationProfilerView.this.createSelector(presetSynchronizer, application);
            }
        };
    }

    void selectPreset(ProfilerPreset preset, ProfilingSettings settings) {
        if (this.masterViewSupport == null) {
            this.cachedPreset = preset;
            this.cachedSettings = settings;
        } else {
            int presetIdx = this.selectorModel.getIndexOf(preset = new ProfilerPreset(preset));
            if (presetIdx == -1) {
                this.selectorModel.insertElementAt(preset, 1);
            } else {
                this.selectorModel.removeElement(preset);
                this.selectorModel.insertElementAt(preset, presetIdx);
            }
            this.selectorModel.setSelectedItem(preset);
            this.cpuSettings.updateSettings(preset);
            this.memorySettings.updateSettings(preset);
            this.jdbcSettings.updateSettings(preset);
            this.locksSettings.updateSettings(preset);
            if (ProfilingSettings.isCPUSettings((ProfilingSettings)settings)) {
                this.masterViewSupport.showCPUSettings();
            } else if (ProfilingSettings.isMemorySettings((ProfilingSettings)settings)) {
                this.masterViewSupport.showMemorySettings();
            } else if (ProfilingSettings.isJDBCSettings((ProfilingSettings)settings)) {
                this.masterViewSupport.showJDBCSettings();
            }
            this.cachedPreset = null;
            this.cachedSettings = null;
        }
    }

    private PresetSelector createSelector(Runnable presetSynchronizer, Application application) {
        if (this.selectorModel == null) {
            this.selectorModel = new DefaultComboBoxModel();
        }
        if (this.allSelectors == null) {
            this.allSelectors = new ArrayList<PresetSelector>();
        }
        PresetSelector selector = ProfilerPresets.getInstance().createSelector(application, this.selectorModel, this.allSelectors, presetSynchronizer);
        this.allSelectors.add(selector);
        return selector;
    }

    protected DataViewComponent createComponent() {
        if (this.dvc != null) {
            return this.dvc;
        }
        Application application = (Application)this.getDataSource();
        ProfilingResultsSupport profilingResultsSupport = new ProfilingResultsSupport();
        this.masterViewSupport = new MasterViewSupport(application, profilingResultsSupport, this.cpuSettings, this.memorySettings, this.jdbcSettings, this.locksSettings, this.classSharingBreaksProfiling){

            @Override
            void showCPUSettings() {
                if (ApplicationProfilerView.this.dvc != null) {
                    ApplicationProfilerView.this.cpuSettings.showSettings(ApplicationProfilerView.this.dvc);
                    ApplicationProfilerView.this.dvc.showDetailsArea(2);
                }
            }

            @Override
            void showMemorySettings() {
                if (ApplicationProfilerView.this.dvc != null) {
                    ApplicationProfilerView.this.memorySettings.showSettings(ApplicationProfilerView.this.dvc);
                    ApplicationProfilerView.this.dvc.showDetailsArea(2);
                }
            }

            @Override
            void showJDBCSettings() {
                if (ApplicationProfilerView.this.dvc != null) {
                    ApplicationProfilerView.this.jdbcSettings.showSettings(ApplicationProfilerView.this.dvc);
                    ApplicationProfilerView.this.dvc.showDetailsArea(2);
                }
            }
        };
        this.dvc = new DataViewComponent(this.masterViewSupport.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profiling_results"), false), 1);
        this.dvc.addDetailsView(profilingResultsSupport.getDetailsView(), 1);
        this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Settings"), true), 2);
        this.dvc.addDetailsView(this.cpuSettings.getDetailsView(), 2);
        this.dvc.addDetailsView(this.memorySettings.getDetailsView(), 2);
        this.dvc.addDetailsView(this.jdbcSettings.getDetailsView(), 2);
        if (this.cachedPreset != null) {
            this.selectPreset(this.cachedPreset, this.cachedSettings);
        }
        return this.dvc;
    }

    protected void willBeAdded() {
        this.classSharingBreaksProfiling = ProfilerSupport.classSharingBreaksProfiling((Application)this.getDataSource());
    }

    protected void removed() {
        this.masterViewSupport.viewRemoved();
    }

    private static final class OneWayToggleButton
    extends JToggleButton {
        OneWayToggleButton(String text) {
            super(text);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (!this.isSelected()) {
                super.processMouseEvent(e);
            }
        }
    }

    private static abstract class MasterViewSupport
    extends JPanel
    implements ProfilingStateListener,
    DataRemovedListener<Application>,
    ActionListener,
    PropertyChangeListener {
        private Application application;
        private ProfilingResultsSupport profilingResultsView;
        private CPUSettingsSupport cpuSettingsSupport;
        private MemorySettingsSupport memorySettingsSupport;
        private JDBCSettingsSupport jdbcSettingsSupport;
        private LocksSettingsSupport locksSettingsSupport;
        private AttachSettings attachSettings;
        private Timer timer;
        private int lastInstrValue = -1;
        private int state = -1;
        private boolean internalChange = false;
        private boolean applicationTerminated = false;
        private boolean classSharingBreaksProfiling;
        private final NetBeansProfiler profiler = NetBeansProfiler.getDefaultNB();
        private ProfilingResultsSupport.ResultsView results;
        private HTMLTextArea classShareWarningArea;
        private JLabel modeLabel;
        private JToggleButton cpuButton;
        private JToggleButton memoryButton;
        private JToggleButton jdbcButton;
        private JToggleButton locksButton;
        private JButton stopButton;
        private JLabel statusLabel;
        private HTMLLabel statusValueLabel;
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;

        MasterViewSupport(Application application, ProfilingResultsSupport profilingResultsView, CPUSettingsSupport cpuSettingsSupport, MemorySettingsSupport memorySettingsSupport, JDBCSettingsSupport jdbcSettingsSupport, LocksSettingsSupport locksSettingsSupport, boolean classSharingBreaksProfiling) {
            this.application = application;
            this.profilingResultsView = profilingResultsView;
            this.cpuSettingsSupport = cpuSettingsSupport;
            this.memorySettingsSupport = memorySettingsSupport;
            this.jdbcSettingsSupport = jdbcSettingsSupport;
            this.locksSettingsSupport = locksSettingsSupport;
            this.classSharingBreaksProfiling = classSharingBreaksProfiling;
            this.initComponents();
            this.initSettings();
            this.refreshStatus();
            this.timer = new Timer(1000, this);
            this.timer.setInitialDelay(1000);
            application.notifyWhenRemoved((DataRemovedListener)this);
            application.addPropertyChangeListener("prop_state", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)application));
        }

        abstract void showCPUSettings();

        abstract void showMemorySettings();

        abstract void showJDBCSettings();

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profiler"), null, (JComponent)this);
        }

        public synchronized void dataRemoved(Application application) {
            this.applicationTerminated = true;
            this.timer.stop();
            this.timer.removeActionListener(this);
            this.profiler.removeProfilingStateListener((ProfilingStateListener)this);
            ProfilerSupport.getInstance().setProfiledApplication(null);
            this.lastInstrValue = -1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.resetControlButtons();
                    this.disableControlButtons();
                    statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_application_terminated"));
                    this.enableSettings();
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.dataRemoved(this.application);
        }

        public void viewRemoved() {
            this.timer.stop();
            this.timer.removeActionListener(this);
            this.profiler.removeProfilingStateListener((ProfilingStateListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.results != null) {
                this.results.refreshResults();
            }
            this.updateRunningText();
        }

        private ProfilingResultsSupport.ResultsView getResultsView() {
            if (this.cpuButton.isSelected()) {
                return new CPULivePanel(this.application);
            }
            if (this.memoryButton.isSelected()) {
                return new MemoryLivePanel(this.application);
            }
            if (this.jdbcButton.isSelected()) {
                return new JDBCLivePanel(this.application);
            }
            if (this.locksButton.isSelected()) {
                return new LocksLivePanel(this.application);
            }
            return null;
        }

        private void handleCPUProfiling() {
            if (this.internalChange) {
                return;
            }
            if (this.cpuButton.isSelected()) {
                this.internalChange = true;
                this.memoryButton.setSelected(false);
                this.jdbcButton.setSelected(false);
                this.locksButton.setSelected(false);
                this.internalChange = false;
                if (!this.cpuSettingsSupport.settingsValid()) {
                    this.internalChange = true;
                    this.cpuButton.setSelected(false);
                    this.internalChange = false;
                    this.updateControlButtons();
                    this.showCPUSettings();
                    ProfilerDialogs.displayError((String)NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Incorrect_CPU_settings"));
                } else {
                    this.cpuSettingsSupport.saveSettings();
                    if (this.profiler.getProfilingState() == 4) {
                        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                profiler.modifyCurrentProfiling(cpuSettingsSupport.getSettings());
                            }
                        });
                    } else {
                        this.disableControlButtons();
                        ProfilerSupport.getInstance().setProfiledApplication(this.application);
                        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.startProfiling(application, cpuSettingsSupport.getSettings());
                            }
                        });
                    }
                }
            }
        }

        private void handleMemoryProfiling() {
            if (this.internalChange) {
                return;
            }
            if (this.memoryButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(false);
                this.jdbcButton.setSelected(false);
                this.locksButton.setSelected(false);
                this.internalChange = false;
                if (!this.memorySettingsSupport.settingsValid()) {
                    this.internalChange = true;
                    this.memoryButton.setSelected(false);
                    this.internalChange = false;
                    this.updateControlButtons();
                    this.showMemorySettings();
                    ProfilerDialogs.displayError((String)NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Incorrect_Memory_settings"));
                } else {
                    this.memorySettingsSupport.saveSettings();
                    if (this.profiler.getProfilingState() == 4) {
                        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                profiler.modifyCurrentProfiling(memorySettingsSupport.getSettings());
                            }
                        });
                    } else {
                        this.disableControlButtons();
                        ProfilerSupport.getInstance().setProfiledApplication(this.application);
                        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.startProfiling(application, memorySettingsSupport.getSettings());
                            }
                        });
                    }
                }
            }
        }

        private void handleJDBCProfiling() {
            if (this.internalChange) {
                return;
            }
            if (this.jdbcButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(false);
                this.memoryButton.setSelected(false);
                this.internalChange = false;
                this.jdbcSettingsSupport.saveSettings();
                if (this.profiler.getProfilingState() == 4) {
                    ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            profiler.modifyCurrentProfiling(jdbcSettingsSupport.getSettings());
                        }
                    });
                } else {
                    this.disableControlButtons();
                    ProfilerSupport.getInstance().setProfiledApplication(this.application);
                    ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            this.startProfiling(application, jdbcSettingsSupport.getSettings());
                        }
                    });
                }
            }
        }

        private void handleLocksProfiling() {
            if (this.internalChange) {
                return;
            }
            if (this.locksButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(false);
                this.memoryButton.setSelected(false);
                this.jdbcButton.setSelected(false);
                this.internalChange = false;
                this.locksSettingsSupport.saveSettings();
                if (this.profiler.getProfilingState() == 4) {
                    ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            profiler.modifyCurrentProfiling(locksSettingsSupport.getSettings());
                        }
                    });
                } else {
                    this.disableControlButtons();
                    ProfilerSupport.getInstance().setProfiledApplication(this.application);
                    ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            this.startProfiling(application, locksSettingsSupport.getSettings());
                        }
                    });
                }
            }
        }

        private void startProfiling(Application application, ProfilingSettings pSettings) {
            Runnable calibrationStartUpdater = new Runnable(){

                @Override
                public void run() {
                    ProfilerDialogs.displayInfo((String)NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_calibration", (Object)VisualVM.getInstance().getOptionsHandle()));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_calibration_progress"));
                        }
                    });
                }
            };
            if (CalibrationSupport.checkCalibration(application, calibrationStartUpdater, null)) {
                this.profiler.addProfilingStateListener((ProfilingStateListener)this);
                this.profiler.attachToApp(pSettings, this.attachSettings);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerSupport.getInstance().setProfiledApplication(null);
                        statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_inactive"));
                        this.resetControlButtons();
                        this.enableControlButtons();
                    }
                });
            }
        }

        private void handleStopProfiling() {
            if (this.internalChange) {
                return;
            }
            this.disableControlButtons();
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    profiler.detachFromApp();
                }
            });
        }

        public void profilingStateChanged(ProfilingStateEvent e) {
            this.refreshStatus();
            if (this.results != null) {
                this.results.sessionStateChanged(e.getNewState());
            }
        }

        public void threadsMonitoringChanged() {
            this.refreshStatus();
        }

        public void instrumentationChanged(int oldInstrType, int currentInstrType) {
            this.refreshStatus();
        }

        public void serverStateChanged(int serverState, int serverProgress) {
        }

        public void lockContentionMonitoringChanged() {
        }

        private synchronized void refreshStatus() {
            int newState = this.profiler.getProfilingState();
            final Application profiledApplication = ProfilerSupport.getInstance().getProfiledApplication();
            if (this.state != newState) {
                this.state = newState;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        switch (state) {
                            case 1: {
                                lastInstrValue = -1;
                                if (!applicationTerminated) {
                                    timer.stop();
                                    profiler.removeProfilingStateListener((ProfilingStateListener)this);
                                    if (results != null) {
                                        results.cleanup();
                                    }
                                    statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_inactive"));
                                    this.resetControlButtons();
                                    VisualVM.getInstance().runTask(new Runnable(){

                                        @Override
                                        public void run() {
                                            ProfilerSupport.getInstance().setProfiledApplication(null);
                                            SwingUtilities.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    this.enableControlButtons();
                                                    this.enableSettings();
                                                }
                                            });
                                        }
                                    }, 500);
                                    break;
                                }
                                ProfilerSupport.getInstance().setProfiledApplication(null);
                                break;
                            }
                            case 2: {
                                timer.stop();
                                this.disableControlButtons();
                                this.disableSettings();
                                statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_started"));
                                break;
                            }
                            case 8: {
                                timer.stop();
                                statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_paused"));
                                break;
                            }
                            case 128: {
                                timer.stop();
                                statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_refreshing"));
                                this.disableControlButtons();
                                this.disableSettings();
                                break;
                            }
                            case 4: {
                                if (application.equals((Object)profiledApplication)) {
                                    this.updateRunningText();
                                    timer.start();
                                    this.enableControlButtons();
                                    this.updateControlButtons();
                                    this.disableSettings();
                                    results = this.getResultsView();
                                    profilingResultsView.setProfilingResultsDisplay(results);
                                } else {
                                    statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_of") + ProfilerSupport.getInstance().getProfiledApplicationName() + NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_in_progress"));
                                    this.disableControlButtons();
                                    results = null;
                                    profilingResultsView.setProfilingResultsDisplay(results);
                                }
                                profilingResultsView.revalidate();
                                profilingResultsView.repaint();
                                this.revalidate();
                                this.repaint();
                                break;
                            }
                            case 16: {
                                timer.stop();
                                statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_stopped"));
                                profiler.removeProfilingStateListener((ProfilingStateListener)this);
                                if (results == null) break;
                                results.cleanup();
                            }
                        }
                    }
                });
            }
        }

        private void updateRunningText() {
            int currentProfilingType;
            ProfilingSettings currentSettings = this.profiler.getLastProfilingSettings();
            int n = currentProfilingType = currentSettings != null ? currentSettings.getProfilingType() : Integer.MIN_VALUE;
            if (this.cpuSettingsSupport.getSettings().getProfilingType() == currentProfilingType) {
                int instrValue = TargetAppRunner.getDefault().getProfilingSessionStatus().getNInstrMethods();
                if (this.lastInstrValue != instrValue) {
                    this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_methods", (Object)instrValue));
                }
                this.lastInstrValue = instrValue;
            } else if (this.memorySettingsSupport.getSettings().getProfilingType() == currentProfilingType) {
                int instrValue = TargetAppRunner.getDefault().getProfilingSessionStatus().getNInstrClasses();
                if (this.lastInstrValue != instrValue) {
                    int allocEvery = currentSettings.getAllocTrackEvery();
                    switch (allocEvery) {
                        case 1: {
                            this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_classes_1", (Object)instrValue, (Object)allocEvery));
                            break;
                        }
                        case 2: {
                            this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_classes_2", (Object)instrValue, (Object)allocEvery));
                            break;
                        }
                        case 3: {
                            this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_classes_3", (Object)instrValue, (Object)allocEvery));
                            break;
                        }
                        default: {
                            this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_classes_N", (Object)instrValue, (Object)allocEvery));
                        }
                    }
                }
                this.lastInstrValue = instrValue;
            } else if (this.jdbcSettingsSupport.getSettings().getProfilingType() == currentProfilingType) {
                int instrValue = TargetAppRunner.getDefault().getProfilingSessionStatus().getNInstrMethods();
                if (this.lastInstrValue != instrValue) {
                    this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_methods", (Object)instrValue));
                }
                this.lastInstrValue = instrValue;
            }
        }

        private void enableSettings() {
            this.cpuSettingsSupport.setEnabled(true);
            this.memorySettingsSupport.setEnabled(true);
            this.jdbcSettingsSupport.setEnabled(true);
        }

        private void disableSettings() {
            this.cpuSettingsSupport.setEnabled(false);
            this.memorySettingsSupport.setEnabled(false);
            this.jdbcSettingsSupport.setEnabled(false);
        }

        private void resetControlButtons() {
            this.internalChange = true;
            this.cpuButton.setSelected(false);
            this.memoryButton.setSelected(false);
            this.jdbcButton.setSelected(false);
            this.locksButton.setSelected(false);
            this.internalChange = false;
        }

        private void updateControlButtons() {
            int currentProfilingType;
            ProfilingSettings currentSettings = this.profiler.getLastProfilingSettings();
            int n = currentProfilingType = currentSettings != null ? currentSettings.getProfilingType() : Integer.MIN_VALUE;
            if (this.cpuSettingsSupport.getSettings().getProfilingType() == currentProfilingType && !this.cpuButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(true);
                this.memoryButton.setSelected(false);
                this.jdbcButton.setSelected(false);
                this.locksButton.setSelected(false);
                this.internalChange = false;
            } else if (this.memorySettingsSupport.getSettings().getProfilingType() == currentProfilingType && !this.memoryButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(false);
                this.memoryButton.setSelected(true);
                this.jdbcButton.setSelected(false);
                this.locksButton.setSelected(false);
                this.internalChange = false;
            } else if (this.jdbcSettingsSupport.getSettings().getProfilingType() == currentProfilingType && !this.jdbcButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(false);
                this.memoryButton.setSelected(false);
                this.jdbcButton.setSelected(true);
                this.locksButton.setSelected(false);
                this.internalChange = false;
            } else if (this.locksSettingsSupport.getSettings().getProfilingType() == currentProfilingType && !this.jdbcButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(false);
                this.memoryButton.setSelected(false);
                this.jdbcButton.setSelected(false);
                this.locksButton.setSelected(true);
                this.internalChange = false;
            }
        }

        private void enableControlButtons() {
            boolean enabled = ProfilerSupport.getInstance().supportsProfiling(this.application);
            this.cpuButton.setEnabled(enabled);
            this.memoryButton.setEnabled(enabled);
            this.jdbcButton.setEnabled(enabled);
            this.locksButton.setEnabled(enabled);
            this.stopButton.setEnabled(this.profiler.getTargetAppRunner().targetAppIsRunning());
        }

        private void disableControlButtons() {
            this.cpuButton.setEnabled(false);
            this.memoryButton.setEnabled(false);
            this.jdbcButton.setEnabled(false);
            this.locksButton.setEnabled(false);
            this.stopButton.setEnabled(false);
        }

        private void initSettings() {
            this.attachSettings = new AttachSettings();
            this.attachSettings.setDirect(false);
            this.attachSettings.setDynamic16(true);
            this.attachSettings.setPid(this.application.getPid());
            ProfilerIDESettings.getInstance().setOOMDetectionMode(0);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel controlPanel = new JPanel();
            controlPanel.setOpaque(false);
            controlPanel.setLayout(new GridBagLayout());
            controlPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 3, 0));
            this.classShareWarningArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    try {
                        DesktopUtils.browse((URI)url.toURI());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.classShareWarningArea.setOpaque(true);
            this.classShareWarningArea.setBackground(new Color(255, 180, 180));
            this.classShareWarningArea.setForeground(new Color(0, 0, 0));
            this.classShareWarningArea.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
            this.classShareWarningArea.setBorder((Border)BorderFactory.createCompoundBorder(this.classShareWarningArea.getBorder(), BorderFactory.createMatteBorder(5, 5, 5, 5, this.classShareWarningArea.getBackground())));
            this.classShareWarningArea.setVisible(this.classSharingBreaksProfiling);
            if (this.classSharingBreaksProfiling) {
                String link = DesktopUtils.isBrowseAvailable() ? NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Class_Sharing_Link") : NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Class_Sharing_Nolink");
                String message = NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Class_Sharing", (Object)link);
                this.classShareWarningArea.setText(message);
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 10, 8);
            controlPanel.add((Component)this.classShareWarningArea, constraints);
            this.modeLabel = new JLabel(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Sample"));
            this.modeLabel.setFont(this.modeLabel.getFont().deriveFont(1));
            Dimension d = this.modeLabel.getPreferredSize();
            this.modeLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profile"));
            d.width = Math.max(d.width, this.modeLabel.getPreferredSize().width);
            this.modeLabel.setPreferredSize(d);
            this.modeLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.modeLabel, constraints);
            this.cpuButton = new OneWayToggleButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Cpu"));
            this.cpuButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/cpu.png", (boolean)true)));
            this.cpuButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleCPUProfiling();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.cpuButton, constraints);
            this.memoryButton = new OneWayToggleButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Memory"));
            this.memoryButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/memory.png", (boolean)true)));
            this.memoryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleMemoryProfiling();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.memoryButton, constraints);
            this.jdbcButton = new OneWayToggleButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_JDBC"));
            this.jdbcButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/jdbc.png", (boolean)true)));
            this.jdbcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleJDBCProfiling();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 4;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.jdbcButton, constraints);
            this.locksButton = new OneWayToggleButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Locks"));
            this.locksButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/locks.png", (boolean)true)));
            this.locksButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleLocksProfiling();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 5;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.locksButton, constraints);
            this.stopButton = new JButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Stop"));
            this.stopButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/profiler/resources/stop.png", (boolean)true)));
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleStopProfiling();
                }
            });
            this.stopButton.setEnabled(false);
            this.stopButton.setDefaultCapable(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 6;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.stopButton, constraints);
            JPanel filler1 = new JPanel(new BorderLayout());
            filler1.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 6;
            constraints.gridy = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            controlPanel.add((Component)filler1, constraints);
            this.statusLabel = new JLabel(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Status"));
            this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
            this.statusLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(6, 8, 4, 0);
            controlPanel.add((Component)this.statusLabel, constraints);
            this.statusValueLabel = new HTMLLabel(){

                public void setText(String text) {
                    super.setText("<nobr>" + text + "</nobr>");
                }

                protected void showURL(URL url) {
                    ProfilerSupport.getInstance().selectActiveProfilerView();
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, refLabelHeight);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.statusValueLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 3;
            constraints.gridwidth = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(6, 8, 4, 8);
            controlPanel.add((Component)this.statusValueLabel, constraints);
            JPanel filler2 = new JPanel(new BorderLayout());
            filler2.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 3;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            controlPanel.add((Component)filler2, constraints);
            Dimension cpuD = this.cpuButton.getPreferredSize();
            Dimension memoryD = this.memoryButton.getPreferredSize();
            Dimension jdbcD = this.jdbcButton.getPreferredSize();
            Dimension locksD = this.locksButton.getPreferredSize();
            Dimension stopD = this.stopButton.getPreferredSize();
            Dimension maxD = new Dimension(Math.max(cpuD.width, memoryD.width), Math.max(cpuD.height, memoryD.height));
            maxD = new Dimension(Math.max(maxD.width, jdbcD.width), Math.max(maxD.height, jdbcD.height));
            maxD = new Dimension(Math.max(maxD.width, locksD.width), Math.max(maxD.height, locksD.height));
            maxD = new Dimension(Math.max(maxD.width, stopD.width), Math.max(maxD.height, stopD.height));
            this.cpuButton.setPreferredSize(maxD);
            this.cpuButton.setMinimumSize(maxD);
            this.memoryButton.setPreferredSize(maxD);
            this.memoryButton.setMinimumSize(maxD);
            this.jdbcButton.setPreferredSize(maxD);
            this.jdbcButton.setMinimumSize(maxD);
            this.locksButton.setPreferredSize(maxD);
            this.locksButton.setMinimumSize(maxD);
            this.stopButton.setPreferredSize(maxD);
            this.stopButton.setMinimumSize(maxD);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)controlPanel, "Center");
        }
    }
}

