/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import java.net.URI;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.types.SoapActionType;

public class SoapActionHeader
extends UpnpHeader<SoapActionType> {
    public SoapActionHeader() {
    }

    public SoapActionHeader(URI uri) {
        this.setValue(SoapActionType.valueOf(uri.toString()));
    }

    public SoapActionHeader(SoapActionType value) {
        this.setValue(value);
    }

    public SoapActionHeader(String s) throws InvalidHeaderException {
        this.setString(s);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        try {
            if (!s.startsWith("\"") && s.endsWith("\"")) {
                throw new InvalidHeaderException("Invalid SOAP action header, must be enclosed in doublequotes:" + s);
            }
            SoapActionType t = SoapActionType.valueOf(s.substring(1, s.length() - 1));
            this.setValue(t);
        }
        catch (RuntimeException e) {
            throw new InvalidHeaderException("Invalid SOAP action header value, " + e.getMessage(), e);
        }
    }

    @Override
    public String getString() {
        return "\"" + ((SoapActionType)this.getValue()).toString() + "\"";
    }
}

