/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.repository;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.xml.XML;
import aQute.libg.gzip.GZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.osgi.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLResourceParser
extends Processor {
    private static final Logger logger = LoggerFactory.getLogger(XMLResourceParser.class);
    static final XMLInputFactory inputFactory = XML.newXMLInputFactory();
    private final List<Resource> resources = new ArrayList<Resource>();
    private final XMLStreamReader reader;
    private final Set<URI> traversed;
    private final String what;
    private final URI url;
    private int depth;
    private String name;
    private long increment;

    public static List<Resource> getResources(URI uri) throws Exception {
        try (XMLResourceParser parser = new XMLResourceParser(uri);){
            List<Resource> list = parser.parse();
            return list;
        }
    }

    public static List<Resource> getResources(File file) throws Exception {
        try (XMLResourceParser parser = new XMLResourceParser(file);){
            List<Resource> list = parser.parse();
            return list;
        }
    }

    public static List<Resource> getResources(File file, URI base) throws Exception {
        try (XMLResourceParser parser = new XMLResourceParser(file, base);){
            List<Resource> list = parser.parse();
            return list;
        }
    }

    public static List<Resource> getResources(InputStream in, URI base) throws Exception {
        try (XMLResourceParser parser = new XMLResourceParser(in, "parse", base);){
            List<Resource> list = parser.parse();
            return list;
        }
    }

    public XMLResourceParser(URI url) throws Exception {
        this(IO.stream(url.toURL()), url.toString(), url);
    }

    public XMLResourceParser(InputStream in, String what, URI uri) throws Exception {
        this(in, what, 100, new HashSet<URI>(), uri);
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public XMLResourceParser(InputStream in, String what, int depth, Set<URI> traversed, URI url) throws Exception {
        this.what = what;
        this.depth = depth;
        this.traversed = traversed;
        this.url = url;
        in = GZipUtils.detectCompression(in);
        this.addClose(in);
        this.reader = inputFactory.createXMLStreamReader(in);
    }

    public XMLResourceParser(File location) throws Exception {
        this(location, location.toURI());
    }

    public XMLResourceParser(File location, URI url) throws Exception {
        this(IO.stream(location), location.getAbsolutePath(), url);
    }

    @Override
    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        finally {
            super.close();
        }
    }

    public String name() {
        return this.name;
    }

    public long increment() {
        return this.increment;
    }

    List<Resource> getResources() {
        if (!this.isOk()) {
            return null;
        }
        return this.resources;
    }

    public List<Resource> parse() throws Exception {
        if (!this.check(this.reader.hasNext(), "No content found", new Object[0])) {
            return null;
        }
        this.next();
        if (!this.check(this.reader.isStartElement(), "Expected a start element at the root, is %s", this.reader.getEventType())) {
            return null;
        }
        String localName = this.reader.getLocalName();
        if (!this.check("repository".equals(localName), "Invalid tag name of top element, expected %s, got %s", "repository", localName)) {
            return null;
        }
        String nsUri = this.reader.getNamespaceURI();
        if (nsUri != null) {
            this.check("http://www.osgi.org/xmlns/repository/v1.0.0".equals(nsUri), "Incorrect namespace. Expected %s, got %s", "http://www.osgi.org/xmlns/repository/v1.0.0", nsUri);
        }
        this.name = this.reader.getAttributeValue(null, "name");
        String incrementString = this.reader.getAttributeValue(null, "increment");
        if (incrementString != null) {
            this.increment = Long.parseLong(incrementString);
        }
        this.next();
        while (this.reader.isStartElement()) {
            localName = this.reader.getLocalName();
            if (localName.equals("referral")) {
                this.parseReferral();
                continue;
            }
            if (localName.equals("resource")) {
                this.parseResource(this.resources);
                continue;
            }
            this.check(false, "Unexpected element %s", localName);
            this.next();
        }
        this.check(this.reader.isEndElement() && this.reader.getLocalName().equals("repository"), "Expected to be at the end but are on %s", this.reader.getLocalName());
        return this.getResources();
    }

    public void next() throws XMLStreamException {
        this.report();
        this.reader.nextTag();
    }

    private void report() {
        int type = this.reader.getEventType();
        switch (type) {
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            default: {
                logger.debug("** unknown element, event type {}", (Object)type);
            }
        }
    }

    private void parseReferral() throws Exception {
        if (--this.depth < 0) {
            this.error("Too deep, traversed %s", this.traversed);
        } else {
            String depthString = this.reader.getAttributeValue(null, "depth");
            String urlString = this.reader.getAttributeValue(null, "url");
            if (this.check(urlString != null, "Expected URL in referral", new Object[0])) {
                URI url = this.url.resolve(urlString);
                this.traversed.add(url);
                int depth = 100;
                if (depthString != null) {
                    depth = Integer.parseInt(depthString);
                }
                InputStream in = url.toURL().openStream();
                try (XMLResourceParser referralParser = new XMLResourceParser(in, urlString, depth, this.traversed, url);){
                    referralParser.parse();
                    this.resources.addAll(referralParser.resources);
                }
            }
        }
        this.next();
        this.tagEnd("referral");
    }

    private void tagEnd(String tag) throws XMLStreamException {
        if (!this.check(this.reader.isEndElement(), "Expected end element, got %s for %s (%s)", this.reader.getEventType(), tag, this.reader.getLocalName())) {
            logger.debug("oops, invalid end {}", (Object)tag);
        }
        this.next();
    }

    private void parseResource(List<Resource> resources) throws Exception {
        ResourceBuilder resourceBuilder = new ResourceBuilder();
        this.next();
        while (this.reader.isStartElement()) {
            this.parseCapabilityOrRequirement(resourceBuilder);
        }
        Resource resource = resourceBuilder.build();
        resources.add(resource);
        this.tagEnd("resource");
    }

    private void parseCapabilityOrRequirement(ResourceBuilder resourceBuilder) throws Exception {
        String name = this.reader.getLocalName();
        this.check("requirement".equals(name) || "capability".equals(name), "Expected <%s> or <%s> tag, got <%s>", "requirement", "capability", name);
        String namespace = this.reader.getAttributeValue(null, "namespace");
        CapReqBuilder capReqBuilder = new CapReqBuilder(namespace);
        this.next();
        while (this.reader.isStartElement()) {
            this.parseAttributesOrDirectives(capReqBuilder);
        }
        if ("requirement".equals(name)) {
            resourceBuilder.addRequirement(capReqBuilder);
        } else {
            resourceBuilder.addCapability(capReqBuilder);
        }
        this.tagEnd(name);
    }

    private void parseAttributesOrDirectives(CapReqBuilder capReqBuilder) throws Exception {
        String name;
        switch (name = this.reader.getLocalName()) {
            case "attribute": {
                this.parseAttribute(capReqBuilder);
                break;
            }
            case "directive": {
                this.parseDirective(capReqBuilder);
                break;
            }
            default: {
                this.check(false, "Invalid tag, expected either <%s> or <%s>, got <%s>", "attribute", "directive");
            }
        }
        this.next();
        this.tagEnd(name);
    }

    private boolean check(boolean check, String format, Object ... args) {
        if (check) {
            return true;
        }
        String message = Strings.format(format, args);
        this.error("%s: %s", this.what, message);
        return false;
    }

    private void parseAttribute(CapReqBuilder capReqBuilder) throws Exception {
        String attributeName = this.reader.getAttributeValue(null, "name");
        String attributeValue = this.reader.getAttributeValue(null, "value");
        String attributeType = this.reader.getAttributeValue(null, "type");
        if (this.isContent(capReqBuilder) && "url".equals(attributeName)) {
            attributeValue = this.url.resolve(attributeValue).toString();
        }
        Object value = Attrs.convert(attributeType, attributeValue);
        capReqBuilder.addAttribute(attributeName, value);
    }

    private boolean isContent(CapReqBuilder capReqBuilder) {
        return "osgi.content".equals(capReqBuilder.getNamespace());
    }

    private void parseDirective(CapReqBuilder capReqBuilder) throws XMLStreamException {
        String attributeName = this.reader.getAttributeValue(null, "name");
        String attributeValue = this.reader.getAttributeValue(null, "value");
        String attributeType = this.reader.getAttributeValue(null, "type");
        this.check(attributeType == null, "Expected a directive to have no type: %s:%s=%s", attributeName, attributeType, attributeValue);
        capReqBuilder.addDirective(attributeName, attributeValue);
    }

    static {
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        inputFactory.setProperty("javax.xml.stream.isValidating", false);
    }
}

