/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.serial.internal;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.transport.serial.ProtocolType;
import org.openhab.core.io.transport.serial.SerialPortIdentifier;
import org.openhab.core.io.transport.serial.SerialPortProvider;
import org.openhab.core.io.transport.serial.internal.SerialPortIdentifierImpl;
import org.openhab.core.io.transport.serial.internal.SerialPortUtil;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={SerialPortProvider.class})
public class RxTxPortProvider
implements SerialPortProvider {
    private final Logger logger = LoggerFactory.getLogger(RxTxPortProvider.class);

    public @Nullable SerialPortIdentifier getPortIdentifier(URI port) {
        String portPathAsString = port.getPath();
        try {
            Path portPath = Path.of(portPathAsString, new String[0]);
            if (Files.isSymbolicLink(portPath)) {
                portPathAsString = portPath.toRealPath(new LinkOption[0]).toString();
            }
            CommPortIdentifier ident = SerialPortUtil.getPortIdentifier(portPathAsString);
            return new SerialPortIdentifierImpl(ident);
        }
        catch (NoSuchPortException | IOException e) {
            this.logger.debug("No SerialPortIdentifier found for: {}", (Object)portPathAsString, (Object)e);
            return null;
        }
    }

    public Stream<ProtocolType> getAcceptedProtocols() {
        return Stream.of(new ProtocolType(ProtocolType.PathType.LOCAL, "rxtx"));
    }

    public Stream<SerialPortIdentifier> getSerialPortIdentifiers() {
        Stream<CommPortIdentifier> scanIds = SerialPortUtil.getPortIdentifiersUsingScan();
        Stream<CommPortIdentifier> propIds = SerialPortUtil.getPortIdentifiersUsingProperty();
        return Stream.concat(scanIds, propIds).filter(RxTxPortProvider.distinctByKey(CommPortIdentifier::getName)).filter(id -> id.getPortType() == 1).map(sid -> new SerialPortIdentifierImpl((CommPortIdentifier)sid));
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.put(keyExtractor.apply(t), "") == null;
    }
}

