/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.z.IntPredicate;

public class REProgram {
    static final int OPT_HASBACKREFS = 1;
    static final int OPT_HASBOL = 2;
    Operation operation;
    REFlags flags;
    UnicodeString prefix;
    IntPredicate initialCharClass;
    int minimumLength = 0;
    int fixedLength = -1;
    int optimizationFlags;
    int maxParens = -1;

    public REProgram(Operation operation, int parens, REFlags flags) {
        this.flags = flags;
        this.setOperation(operation);
        this.maxParens = parens;
    }

    private void setOperation(Operation operation) {
        this.operation = operation;
        this.optimizationFlags = 0;
        this.prefix = null;
        this.operation = operation.optimize(this, this.flags);
        if (operation instanceof Operation.OpSequence) {
            Operation first = ((Operation.OpSequence)operation).getOperations().get(0);
            if (first instanceof Operation.OpBOL) {
                this.optimizationFlags |= 2;
            } else if (first instanceof Operation.OpAtom) {
                this.prefix = ((Operation.OpAtom)first).getAtom();
            } else if (first instanceof Operation.OpCharClass) {
                this.initialCharClass = ((Operation.OpCharClass)first).getPredicate();
            }
        }
        this.minimumLength = operation.getMinimumMatchLength();
        this.fixedLength = operation.getMatchLength();
    }

    public boolean isNullable() {
        return this.operation.matchesEmptyString();
    }

    public UnicodeString getPrefix() {
        return this.prefix;
    }
}

