/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.credentials.MSICredentials;
import com.microsoft.azure.eventhubs.ITokenProvider;
import com.microsoft.azure.eventhubs.JsonSecurityToken;
import com.microsoft.azure.eventhubs.SecurityToken;
import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ManagedIdentityTokenProvider
implements ITokenProvider {
    static final MSICredentials CREDENTIALS = new MSICredentials();

    @Override
    public CompletableFuture<SecurityToken> getToken(String resource, Duration timeout) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String rawToken = CREDENTIALS.getToken("https://eventhubs.azure.net/");
                return new JsonSecurityToken(rawToken, resource);
            }
            catch (IOException | ParseException e) {
                throw new CompletionException(e);
            }
        });
    }
}

