/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import org.jruby.RubyInteger;
import org.jruby.RubyRange;
import org.logstash.RubyUtil;
import org.logstash.settings.Coercible;
import org.logstash.settings.Range;

public class PortRangeSetting
extends Coercible<Object> {
    private static final Range<Integer> VALID_PORT_RANGE = new Range<Integer>(1, 65535);
    public static final String PORT_SEPARATOR = "-";

    public PortRangeSetting(String name, Object defaultValue) {
        super(name, defaultValue, true, PortRangeSetting::isValid);
    }

    public static boolean isValid(Object range) {
        if (!(range instanceof Range)) {
            return false;
        }
        return VALID_PORT_RANGE.contains((Range)range);
    }

    @Override
    public Range<Integer> coerce(Object obj) {
        if (obj instanceof Range) {
            return (Range)obj;
        }
        if (obj instanceof Integer) {
            Integer val = (Integer)obj;
            return new Range<Integer>(val, val);
        }
        if (obj instanceof Long) {
            Long val = (Long)obj;
            return new Range<Integer>(val.intValue(), val.intValue());
        }
        if (obj instanceof String) {
            String val = ((String)obj).trim();
            String[] parts = val.split(PORT_SEPARATOR);
            String firstStr = parts[0];
            String lastStr = parts.length == 1 ? firstStr : parts[1];
            try {
                int first = Integer.parseInt(firstStr);
                int last = Integer.parseInt(lastStr);
                return new Range<Integer>(first, last);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not coerce [" + String.valueOf(obj) + "](type: " + String.valueOf(obj.getClass()) + ") into a port range");
            }
        }
        if (obj instanceof RubyRange) {
            RubyRange rubyRange = (RubyRange)obj;
            RubyInteger begin = rubyRange.begin(RubyUtil.RUBY.getCurrentContext()).convertToInteger();
            RubyInteger end = rubyRange.end(RubyUtil.RUBY.getCurrentContext()).convertToInteger();
            return new Range<Integer>(begin.getIntValue(), end.getIntValue());
        }
        throw new IllegalArgumentException("Could not coerce [" + String.valueOf(obj) + "](type: " + String.valueOf(obj.getClass()) + ") into a port range");
    }

    @Override
    public void validate(Object value) throws IllegalArgumentException {
        if (!PortRangeSetting.isValid(value)) {
            String msg = String.format("Invalid value \"%s: %s\", valid options are within the range of %d-%d", this.getName(), value, VALID_PORT_RANGE.getFirst(), VALID_PORT_RANGE.getLast());
            throw new IllegalArgumentException(msg);
        }
    }
}

