/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.ScanResultSet;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

class TableScanResultSet
extends ScanResultSet
implements CursorResultSet,
Cloneable {
    protected ScanController scanController;
    protected boolean scanControllerOpened;
    protected boolean isKeyed;
    protected boolean firstScan = true;
    protected ExecIndexRow startPosition;
    protected ExecIndexRow stopPosition;
    protected long conglomId;
    protected DynamicCompiledOpenConglomInfo dcoci;
    protected StaticCompiledOpenConglomInfo scoci;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    public Qualifier[][] qualifiers;
    public String userSuppliedOptimizerOverrides;
    protected boolean runTimeStatisticsOn;
    protected int[] indexCols;
    public int rowsPerRead;
    public boolean forUpdate;
    final boolean sameStartStopPosition;
    protected boolean nextDone;
    private RowLocation rlTemplate;
    private Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public boolean isConstraint;
    public boolean coarserLock;
    public boolean oneRowScan;
    protected long rowsThisScan;
    private long estimatedRowCount;
    protected BackingStoreHashtable past2FutureTbl;
    protected boolean qualify;
    protected boolean currentRowIsValid;
    protected boolean scanRepositioned;

    TableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, int resultRowTemplate, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, resultRowTemplate, lockMode, tableLocked, isolationLevel, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.conglomId = conglomId;
        this.scoci = scoci;
        SanityManager.ASSERT((activation != null ? 1 : 0) != 0, (String)"table scan must get activation context");
        if (sameStartStopPosition) {
            SanityManager.ASSERT((stopKeyGetter == null ? 1 : 0) != 0, (String)"stopKeyGetter expected to be null when sameStartStopPosition is true");
        }
        this.startKeyGetter = startKeyGetter;
        this.startSearchOperator = startSearchOperator;
        this.stopKeyGetter = stopKeyGetter;
        this.stopSearchOperator = stopSearchOperator;
        this.sameStartStopPosition = sameStartStopPosition;
        this.qualifiers = qualifiers;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.isConstraint = isConstraint;
        this.forUpdate = forUpdate;
        this.rowsPerRead = rowsPerRead;
        this.oneRowScan = oneRowScan;
        if (indexColItem != -1) {
            this.indexCols = (int[])activation.getPreparedStatement().getSavedObject(indexColItem);
        }
        if (this.indexCols != null) {
            activation.setForUpdateIndexScan(this);
        }
        this.runTimeStatisticsOn = activation != null && activation.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.qualify = true;
        this.currentRowIsValid = false;
        this.scanRepositioned = false;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"TableScanResultSet already open");
        TransactionController tc = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (this.dcoci == null) {
            this.dcoci = tc.getDynamicCompiledConglomInfo(this.conglomId);
        }
        this.initStartAndStopKey();
        if (this.firstScan) {
            this.openScanController(tc);
            this.isKeyed = this.scanController.isKeyed();
            if (SanityManager.DEBUG_ON((String)"ScanTrace")) {
                // empty if block
            }
        }
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.scanControllerOpened = false;
        } else if (!this.firstScan) {
            this.openScanController(tc);
        }
        if (this.forUpdate && this.isKeyed) {
            this.activation.setIndexScanController(this.scanController);
            this.activation.setIndexConglomerateNumber(this.conglomId);
        }
        this.firstScan = false;
        this.isOpen = true;
        ++this.numOpens;
        this.nextDone = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    void initStartAndStopKey() throws StandardException {
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
    }

    protected void openScanController(TransactionController tc) throws StandardException {
        DataValueDescriptor[] stopPositionRow;
        DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray = stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (tc == null) {
            tc = this.activation.getTransactionController();
        }
        int openMode = 0;
        if (this.forUpdate) {
            openMode = 4;
            if (this.activation.isCursorActivation()) {
                openMode |= 0x1000;
            }
        }
        this.scanController = tc.openCompiledScan(this.activation.getResultSetHoldability(), openMode, this.lockMode, this.isolationLevel, this.accessedCols, startPositionRow, this.startSearchOperator, this.qualifiers, stopPositionRow, this.stopSearchOperator, this.scoci, this.dcoci);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
        this.estimatedRowCount = this.scanController.getEstimatedRowCount();
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
    }

    protected void reopenScanController() throws StandardException {
        DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        this.rowsThisScan = 0L;
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        this.scanController.reopenScan(startPositionRow, this.startSearchOperator, this.qualifiers, stopPositionRow, this.stopSearchOperator);
        this.scanControllerOpened = true;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((boolean)this.isOpen, (String)"TableScanResultSet not open, cannot reopen");
        this.initStartAndStopKey();
        if (this.skipScan(this.startPosition, this.stopPosition)) {
            this.scanControllerOpened = false;
        } else if (this.scanController == null) {
            this.openScanController(null);
        } else {
            this.reopenScanController();
        }
        ++this.numOpens;
        this.nextDone = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    boolean loopControl(boolean moreRows) throws StandardException {
        return this.scanController.fetchNext(this.candidate.getRowArray());
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.checkCancellationFlag();
        if (this.currentRow == null || this.scanRepositioned) {
            this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
        }
        this.beginTime = this.getCurrentTimeMillis();
        ExecRow result = null;
        if (this.isOpen && !this.nextDone) {
            this.nextDone = this.oneRowScan;
            if (this.scanControllerOpened) {
                boolean moreRows = true;
                while (moreRows = this.loopControl(moreRows)) {
                    RowLocation rowLoc;
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.sameStartStopPosition && this.skipRow(this.candidate)) {
                        ++this.rowsFiltered;
                        continue;
                    }
                    if (this.past2FutureTbl != null && this.past2FutureTbl.remove(rowLoc = (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns())) != null) continue;
                    result = this.currentRow;
                    break;
                }
                if (!moreRows) {
                    this.setRowCountIfPossible(this.rowsThisScan);
                    this.currentRow = null;
                }
            }
        }
        this.setCurrentRow(result);
        this.currentRowIsValid = true;
        this.scanRepositioned = false;
        this.qualify = true;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            ConglomerateController borrowedBaseCC;
            if (SanityManager.DEBUG_ON((String)"ScanTrace")) {
                // empty if block
            }
            this.clearCurrentRow();
            if (this.scanController != null) {
                if (this.runTimeStatisticsOn) {
                    this.scanProperties = this.getScanProperties();
                    this.startPositionString = this.printStartPosition();
                    this.stopPositionString = this.printStopPosition();
                }
                this.scanController.close();
                this.scanController = null;
                if (this.forUpdate && this.isKeyed) {
                    this.activation.clearIndexScanInfo();
                }
            }
            this.scanControllerOpened = false;
            this.startPosition = null;
            this.stopPosition = null;
            super.close();
            if (this.indexCols != null && (borrowedBaseCC = this.activation.getHeapConglomerateController()) != null) {
                borrowedBaseCC.close();
                this.activation.clearHeapConglomerateController();
            }
            if (this.past2FutureTbl != null) {
                this.past2FutureTbl.close();
                this.past2FutureTbl = null;
            }
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of TableScanResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime;
        }
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        RowLocation rl;
        if (!this.isOpen) {
            return null;
        }
        if (!this.scanControllerOpened) {
            return null;
        }
        if (this.isKeyed) {
            SanityManager.ASSERT((this.currentRow != null ? 1 : 0) != 0, (String)"There must be a current row when fetching the row location");
            rl = (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns());
        } else if (this.currentRowIsValid) {
            if (this.rlTemplate == null) {
                this.rlTemplate = this.scanController.newRowLocationTemplate();
            }
            rl = this.rlTemplate;
            try {
                this.scanController.fetchLocation(rl);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("XSCH7.S")) {
                    throw StandardException.newException((String)"24000", (Object[])new Object[0]);
                }
                throw se;
            }
        } else {
            rl = null;
        }
        return rl;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        block6: {
            SanityManager.ASSERT((boolean)this.isOpen, (String)"TSRS expected to be open");
            try {
                if (this.currentRow == null || !this.currentRowIsValid || !this.scanControllerOpened || this.qualify && this.scanController.isCurrentPositionDeleted() || this.qualify && !this.scanController.doesCurrentPositionQualify()) {
                    return null;
                }
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("XSAM5.S")) break block6;
                se = StandardException.newException((String)"24000", (Object[])new Object[0]);
                throw se;
            }
        }
        this.resultRowBuilder.reset(this.candidate);
        this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
        try {
            this.scanController.fetchWithoutQualify(this.candidate.getRowArray());
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("XSAM6.S")) {
                return null;
            }
            throw se;
        }
        this.setCurrentRow(this.candidate);
        return this.currentRow;
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
        if (!this.isKeyed) {
            this.currentRowIsValid = this.scanController.positionAtRowLocation(rl);
        }
        this.qualify = false;
        this.scanRepositioned = true;
    }

    public String printStartPosition() {
        return this.printPosition(this.startSearchOperator, this.startKeyGetter, this.startPosition);
    }

    public String printStopPosition() {
        if (this.sameStartStopPosition) {
            return this.printPosition(this.stopSearchOperator, this.startKeyGetter, this.startPosition);
        }
        return this.printPosition(this.stopSearchOperator, this.stopKeyGetter, this.stopPosition);
    }

    private String printPosition(int searchOperator, GeneratedMethod positionGetter, ExecIndexRow positioner) {
        Object output = "";
        if (positionGetter == null) {
            return "\t" + MessageService.getTextMessage((String)"42Z37.U", (Object[])new Object[0]) + "\n";
        }
        if (positioner == null) {
            if (this.numOpens == 0) {
                return "\t" + MessageService.getTextMessage((String)"42Z38.U", (Object[])new Object[0]) + "\n";
            }
            try {
                positioner = (ExecIndexRow)positionGetter.invoke(this.activation);
            }
            catch (StandardException e) {
                return "\t" + MessageService.getTextMessage((String)"42Z39.U", (Object[])new Object[]{e.toString()});
            }
        }
        if (positioner == null) {
            return "\t" + MessageService.getTextMessage((String)"42Z37.U", (Object[])new Object[0]) + "\n";
        }
        Object searchOp = null;
        switch (searchOperator) {
            case 1: {
                searchOp = ">=";
                break;
            }
            case -1: {
                searchOp = ">";
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unknown search operator " + searchOperator));
                searchOp = "unknown value (" + searchOperator + ")";
            }
        }
        output = (String)output + "\t" + MessageService.getTextMessage((String)"42Z40.U", (Object[])new Object[]{searchOp, String.valueOf(positioner.nColumns())}) + "\n";
        output = (String)output + "\t" + MessageService.getTextMessage((String)"42Z41.U", (Object[])new Object[0]) + "\n";
        boolean colSeen = false;
        for (int position = 0; position < positioner.nColumns(); ++position) {
            if (positioner.areNullsOrdered(position)) {
                output = (String)output + position + " ";
                colSeen = true;
            }
            if (!colSeen || position != positioner.nColumns() - 1) continue;
            output = (String)output + "\n";
        }
        return output;
    }

    public Properties getScanProperties() {
        if (this.scanProperties == null) {
            this.scanProperties = new Properties();
        }
        try {
            if (this.scanController != null) {
                this.scanController.getScanInfo().getAllScanInfo(this.scanProperties);
                this.coarserLock = this.scanController.isTableLocked() && this.lockMode == 6;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return this.scanProperties;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 3;
    }

    protected final void setRowCountIfPossible(long rowsThisScan) throws StandardException {
        if (!(this.scanController.isKeyed() || this.qualifiers != null && this.qualifiers.length != 0 || this.forUpdate)) {
            long diff = rowsThisScan - this.estimatedRowCount;
            long tenPerCent = this.estimatedRowCount / 10L;
            if (diff < 0L) {
                diff = -diff;
            }
            if (diff > tenPerCent) {
                this.scanController.setEstimatedRowCount(rowsThisScan);
            }
        }
    }

    @Override
    protected boolean canGetInstantaneousLocks() {
        return false;
    }

    @Override
    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public Object clone() {
        Object clo = null;
        try {
            clo = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clo;
    }
}

