/* libaccounts-glib.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Ag", gir_namespace = "Accounts", gir_version = "1.0", lower_case_cprefix = "ag_")]
namespace Ag {
	[CCode (cheader_filename = "libaccounts-glib.h", type_id = "ag_account_get_type ()")]
	public class Account : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Account ();
		public void @delete ();
		public unowned string get_display_name ();
		public bool get_enabled ();
		public unowned Ag.Manager get_manager ();
		public unowned string get_provider_name ();
		public Ag.Service get_selected_service ();
		public Ag.AccountSettingIter get_settings_iter (string? key_prefix);
		[Version (deprecated = true, deprecated_since = "1.4")]
		public Ag.SettingSource get_value (string key, ref GLib.Value value);
		[Version (since = "1.4")]
		public unowned GLib.Variant get_variant (string key, out Ag.SettingSource source);
		public GLib.List<Ag.Service> list_enabled_services ();
		public GLib.List<Ag.Service> list_services ();
		public GLib.List<Ag.Service> list_services_by_type (string service_type);
		public void remove_watch (Ag.AccountWatch watch);
		public void select_service (Ag.Service? service);
		public void set_display_name (string display_name);
		public void set_enabled (bool enabled);
		[Version (deprecated = true, deprecated_since = "1.4")]
		public void set_value (string key, GLib.Value? value);
		[Version (since = "1.4")]
		public void set_variant (string key, GLib.Variant? value);
		public void settings_iter_init (Ag.AccountSettingIter iter, string? key_prefix);
		public void sign (string key, string token);
		[Version (deprecated = true, deprecated_since = "1.4")]
		public void store ([CCode (scope = "async")] Ag.AccountStoreCb callback);
		[Version (since = "1.4")]
		public async bool store_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool store_blocking () throws GLib.Error;
		public bool supports_service (string service_type);
		public bool verify (string key, string token);
		public bool verify_with_tokens (string key, string tokens);
		public unowned Ag.AccountWatch watch_dir (string key_prefix, [CCode (scope = "async")] Ag.AccountNotifyCb callback);
		public unowned Ag.AccountWatch watch_key (string key, [CCode (scope = "async")] Ag.AccountNotifyCb callback);
		[Version (since = "1.4")]
		public string display_name { get; }
		[Version (since = "1.4")]
		public bool enabled { get; }
		[NoAccessorMethod]
		public bool foreign { construct; }
		[NoAccessorMethod]
		public uint id { get; construct; }
		[Version (since = "1.4")]
		public Ag.Manager manager { get; construct; }
		[NoAccessorMethod]
		[Version (since = "1.4")]
		public string provider { owned get; construct; }
		public signal void deleted ();
		public signal void display_name_changed ();
	}
	[CCode (cheader_filename = "libaccounts-glib.h", type_id = "ag_account_service_get_type ()")]
	public class AccountService : GLib.Object {
		[CCode (has_construct_function = false)]
		public AccountService (owned Ag.Account account, owned Ag.Service? service);
		public unowned Ag.Account get_account ();
		public Ag.AuthData get_auth_data ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_changed_fields ();
		public bool get_enabled ();
		public unowned Ag.Service get_service ();
		public Ag.AccountSettingIter get_settings_iter (string? key_prefix);
		[Version (deprecated = true, deprecated_since = "1.4")]
		public Ag.SettingSource get_value (string key, ref GLib.Value value);
		[Version (since = "1.4")]
		public unowned GLib.Variant get_variant (string key, out Ag.SettingSource source);
		[Version (deprecated = true, deprecated_since = "1.4")]
		public void set_value (string key, GLib.Value? value);
		[Version (since = "1.4")]
		public void set_variant (string key, GLib.Variant? value);
		public void settings_iter_init (Ag.AccountSettingIter iter, string? key_prefix);
		[Version (deprecated = true, deprecated_since = "1.4")]
		public static bool settings_iter_next (Ag.AccountSettingIter iter, out unowned string key, out GLib.Value value);
		[Version (since = "1.4")]
		public Ag.Account account { get; construct; }
		[Version (since = "1.4")]
		public bool enabled { get; }
		[Version (since = "1.4")]
		public Ag.Service service { get; construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "libaccounts-glib.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", lower_case_csuffix = "account_settings_iter", type_id = "ag_account_settings_iter_get_type ()")]
	[Compact]
	public class AccountSettingIter {
		public weak Ag.Account account;
		public void free ();
		[Version (since = "1.4")]
		public bool get_next (out unowned string key, out unowned GLib.Variant value);
		[Version (deprecated = true, deprecated_since = "1.4")]
		public bool next (out unowned string key, out GLib.Value value);
	}
	[CCode (cheader_filename = "libaccounts-glib.h", has_type_id = false)]
	[Compact]
	public class AccountWatch {
	}
	[CCode (cheader_filename = "libaccounts-glib.h", ref_function = "ag_application_ref", type_id = "ag_application_get_type ()", unref_function = "ag_application_unref")]
	[Compact]
	public class Application {
		public unowned string get_description ();
		public unowned string get_i18n_domain ();
		public unowned string get_name ();
		public unowned string get_service_usage (Ag.Service service);
		public Ag.Application @ref ();
		public bool supports_service (Ag.Service service);
		public void unref ();
	}
	[CCode (cheader_filename = "libaccounts-glib.h", ref_function = "ag_auth_data_ref", type_id = "ag_auth_data_get_type ()", unref_function = "ag_auth_data_unref")]
	[Compact]
	public class AuthData {
		[Version (since = "1.1")]
		public uint get_credentials_id ();
		[Version (since = "1.4")]
		public unowned GLib.Variant get_login_parameters (GLib.Variant? extra_parameters);
		public unowned string get_mechanism ();
		public unowned string get_method ();
		[Version (deprecated = true, deprecated_since = "1.4")]
		public unowned GLib.HashTable<string,GLib.Value?> get_parameters ();
		[Version (deprecated = true, deprecated_since = "1.4")]
		public void insert_parameters (GLib.HashTable<string,GLib.Value?> parameters);
		public Ag.AuthData @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libaccounts-glib.h", type_id = "ag_manager_get_type ()")]
	public class Manager : GLib.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		public Manager ();
		public Ag.Account create_account (string provider_name);
		[CCode (has_construct_function = false)]
		public Manager.for_service_type (string service_type);
		public bool get_abort_on_db_timeout ();
		public Ag.Account get_account (Ag.AccountId account_id);
		public GLib.List<Ag.AccountService> get_account_services ();
		public Ag.Application get_application (string application_name);
		public uint get_db_timeout ();
		public GLib.List<Ag.AccountService> get_enabled_account_services ();
		public Ag.Provider get_provider (string provider_name);
		public Ag.Service get_service (string service_name);
		public unowned string get_service_type ();
		public GLib.List<Ag.AccountId> list ();
		public GLib.List<Ag.Application> list_applications_by_service (Ag.Service service);
		public GLib.List<Ag.AccountId> list_by_service_type (string service_type);
		public GLib.List<Ag.AccountId> list_enabled ();
		public GLib.List<Ag.AccountId> list_enabled_by_service_type (string service_type);
		public static void list_free (GLib.List<Ag.AccountId> list);
		public GLib.List<Ag.Provider> list_providers ();
		public GLib.List<Ag.ServiceType> list_service_types ();
		public GLib.List<Ag.Service> list_services ();
		public GLib.List<Ag.Service> list_services_by_application (Ag.Application application);
		public GLib.List<Ag.Service> list_services_by_type (string service_type);
		public Ag.Account load_account (Ag.AccountId account_id) throws GLib.Error;
		public Ag.ServiceType load_service_type (string service_type);
		public void set_abort_on_db_timeout (bool abort);
		public void set_db_timeout (uint timeout_ms);
		public bool abort_on_db_timeout { get; set; }
		public uint db_timeout { get; set; }
		public string service_type { get; construct; }
		[NoAccessorMethod]
		public bool use_dbus { get; construct; }
		public signal void account_created (uint account_id);
		public virtual signal void account_deleted (uint id);
		public signal void account_updated (uint account_id);
		public signal void enabled_event (uint account_id);
	}
	[CCode (cheader_filename = "libaccounts-glib.h", ref_function = "ag_provider_ref", type_id = "ag_provider_get_type ()", unref_function = "ag_provider_unref")]
	[Compact]
	public class Provider {
		[Version (since = "1.2")]
		public unowned string get_description ();
		public unowned string get_display_name ();
		[Version (since = "1.1")]
		public unowned string get_domains_regex ();
		public void get_file_contents (string contents);
		public unowned string get_i18n_domain ();
		public unowned string get_icon_name ();
		public unowned string get_name ();
		[Version (since = "1.5")]
		public unowned string get_plugin_name ();
		[Version (since = "1.14")]
		public bool get_single_account ();
		[Version (since = "1.25")]
		public GLib.List<weak string> get_tags ();
		public static void list_free (GLib.List<Ag.Provider> list);
		[Version (since = "1.2")]
		public bool match_domain (string domain);
		public Ag.Provider @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libaccounts-glib.h", ref_function = "ag_service_ref", type_id = "ag_service_get_type ()", unref_function = "ag_service_unref")]
	[Compact]
	public class Service {
		[Version (since = "1.2")]
		public unowned string get_description ();
		public unowned string get_display_name ();
		public void get_file_contents (string contents, size_t data_offset);
		public unowned string get_i18n_domain ();
		public unowned string get_icon_name ();
		public unowned string get_name ();
		public unowned string get_provider ();
		public unowned string get_service_type ();
		public GLib.List<weak string> get_tags ();
		public bool has_tag (string tag);
		public static void list_free (GLib.List<Ag.Service> list);
		public Ag.Service @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libaccounts-glib.h", ref_function = "ag_service_type_ref", type_id = "ag_service_type_get_type ()", unref_function = "ag_service_type_unref")]
	[Compact]
	public class ServiceType {
		[Version (since = "1.2")]
		public unowned string get_description ();
		public unowned string get_display_name ();
		public void get_file_contents (string contents, size_t len);
		public unowned string get_i18n_domain ();
		public unowned string get_icon_name ();
		public unowned string get_name ();
		public GLib.List<weak string> get_tags ();
		public bool has_tag (string tag);
		public static void list_free (GLib.List<Ag.ServiceType> list);
		public Ag.ServiceType @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libaccounts-glib.h")]
	[SimpleType]
	public struct AccountId : uint {
	}
	[CCode (cheader_filename = "libaccounts-glib.h", cprefix = "AG_ERROR_", has_type_id = false)]
	public enum Error {
		DB,
		DISPOSED,
		DELETED,
		DB_LOCKED,
		ACCOUNT_NOT_FOUND
	}
	[CCode (cheader_filename = "libaccounts-glib.h", cprefix = "AG_SETTING_SOURCE_", has_type_id = false)]
	public enum SettingSource {
		NONE,
		ACCOUNT,
		PROFILE
	}
	[CCode (cheader_filename = "libaccounts-glib.h", cprefix = "AG_ACCOUNTS_ERROR_", has_type_id = false)]
	public errordomain AccountsError {
		DB,
		DISPOSED,
		DELETED,
		DB_LOCKED,
		ACCOUNT_NOT_FOUND,
		STORE_IN_PROGRESS,
		READONLY;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libaccounts-glib.h", instance_pos = 2.9)]
	public delegate void AccountNotifyCb (Ag.Account account, string key);
	[CCode (cheader_filename = "libaccounts-glib.h", instance_pos = 2.9)]
	public delegate void AccountStoreCb (Ag.Account account, GLib.Error error);
	[CCode (cheader_filename = "libaccounts-glib.h", cname = "AG_MANAGER_INTERFACE")]
	public const string MANAGER_INTERFACE;
	[CCode (cheader_filename = "libaccounts-glib.h", cname = "AG_MANAGER_OBJECT_PATH")]
	public const string MANAGER_OBJECT_PATH;
	[CCode (cheader_filename = "libaccounts-glib.h", cname = "AG_MANAGER_SERVICE_NAME")]
	public const string MANAGER_SERVICE_NAME;
	[CCode (cheader_filename = "libaccounts-glib.h")]
	public static GLib.Quark errors_quark ();
	[CCode (cheader_filename = "libaccounts-glib.h")]
	[Version (replacement = "Provider.list_free")]
	public static void provider_list_free (GLib.List<Ag.Provider> list);
	[CCode (cheader_filename = "libaccounts-glib.h")]
	[Version (replacement = "Service.list_free")]
	public static void service_list_free (GLib.List<Ag.Service> list);
	[CCode (cheader_filename = "libaccounts-glib.h")]
	[Version (replacement = "ServiceType.list_free")]
	public static void service_type_list_free (GLib.List<Ag.ServiceType> list);
}
