/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.internal.service.DefaultServiceMethodFactory;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceMethod;
import org.gradle.internal.service.ServiceMethodFactory;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.util.internal.ArrayUtils;

class RelevantMethods {
    private static final ConcurrentMap<Class<?>, RelevantMethods> METHODS_CACHE = new ConcurrentHashMap();
    private static final ServiceMethodFactory SERVICE_METHOD_FACTORY = new DefaultServiceMethodFactory();
    final List<ServiceMethod> decorators;
    final List<ServiceMethod> factories;
    final List<ServiceMethod> configurers;

    private RelevantMethods(List<ServiceMethod> decorators, List<ServiceMethod> factories, List<ServiceMethod> configurers) {
        this.decorators = decorators;
        this.factories = factories;
        this.configurers = configurers;
    }

    public static RelevantMethods getMethods(Class<? extends ServiceRegistrationProvider> type) {
        RelevantMethods relevantMethods = (RelevantMethods)METHODS_CACHE.get(type);
        if (relevantMethods == null) {
            relevantMethods = new RelevantMethodsBuilder(type).build();
            METHODS_CACHE.putIfAbsent(type, relevantMethods);
        }
        return relevantMethods;
    }

    private static class RelevantMethodsBuilder {
        private final Class<?> type;
        private final List<ServiceMethod> decorators = new ArrayList<ServiceMethod>();
        private final List<ServiceMethod> factories = new ArrayList<ServiceMethod>();
        private final List<ServiceMethod> configurers = new ArrayList<ServiceMethod>();
        private final Set<String> seen = new HashSet<String>();

        public RelevantMethodsBuilder(Class<? extends ServiceRegistrationProvider> type) {
            this.type = type;
        }

        public RelevantMethods build() {
            for (Class<?> clazz = this.type; clazz != Object.class && clazz != DefaultServiceRegistry.class; clazz = clazz.getSuperclass()) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (Modifier.isStatic(method.getModifiers())) continue;
                    this.addMethod(method);
                }
            }
            return new RelevantMethods(this.decorators, this.factories, this.configurers);
        }

        private void addMethod(Method method) {
            if (method.getName().equals("configure")) {
                if (!method.getReturnType().equals(Void.TYPE)) {
                    throw new ServiceValidationException(String.format("Method %s.%s() must return void.", this.type.getName(), method.getName()));
                }
                this.add(this.configurers, method);
            } else if (method.getName().startsWith("create") || method.getName().startsWith("decorate")) {
                if (method.getAnnotation(Provides.class) == null) {
                    throw new ServiceValidationException(String.format("Method %s.%s() must be annotated with @Provides.", this.type.getName(), method.getName()));
                }
                if (method.getReturnType().equals(Void.TYPE)) {
                    throw new ServiceValidationException(String.format("Method %s.%s() must not return void.", this.type.getName(), method.getName()));
                }
                if (RelevantMethodsBuilder.takesReturnTypeAsParameter(method)) {
                    this.add(this.decorators, method);
                } else {
                    this.add(this.factories, method);
                }
            } else if (method.getAnnotation(Provides.class) != null) {
                throw new ServiceValidationException(String.format("Non-factory method %s.%s() must not be annotated with @Provides.", this.type.getName(), method.getName()));
            }
        }

        public void add(List<ServiceMethod> builder, Method method) {
            StringBuilder signature = new StringBuilder();
            signature.append(method.getName());
            for (Class<?> parameterType : method.getParameterTypes()) {
                signature.append(",");
                signature.append(parameterType.getName());
            }
            if (this.seen.add(signature.toString())) {
                builder.add(SERVICE_METHOD_FACTORY.toServiceMethod(method));
            }
        }

        private static boolean takesReturnTypeAsParameter(Method method) {
            return ArrayUtils.contains((Object[])method.getParameterTypes(), method.getReturnType());
        }
    }
}

