/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class ContactTest
extends FreeColTestCase {
    private static final TileType plains = ContactTest.spec().getTileType("model.tile.plains");
    private static final TileType ocean = ContactTest.spec().getTileType("model.tile.ocean");
    private static final UnitType galleonType = ContactTest.spec().getUnitType("model.unit.galleon");
    private static final UnitType braveType = ContactTest.spec().getUnitType("model.unit.brave");
    private static final UnitType colonistType = ContactTest.spec().getUnitType("model.unit.freeColonist");

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    public void testEuropeanMeetsNative() throws Exception {
        ServerGame game = ServerTestHelper.startServerGame(ContactTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer iroquois = this.getServerPlayer(game, "model.nation.iroquois");
        Tile tile1 = map.getTile(6, 8);
        tile1.setExplored(dutch, true);
        Tile tile2 = map.getTile(5, 8);
        tile2.setExplored(dutch, true);
        Tile tile3 = map.getTile(4, 8);
        tile3.setExplored(dutch, true);
        ContactTest.assertFalse((boolean)iroquois.hasContacted(dutch));
        ContactTest.assertFalse((boolean)dutch.hasContacted(iroquois));
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        colonist.setState(Unit.UnitState.FORTIFYING);
        colonist.setState(Unit.UnitState.FORTIFIED);
        ServerUnit soldier = new ServerUnit(game, tile3, iroquois, braveType);
        ContactTest.assertNotNull((Object)soldier);
        igc.move(dutch, colonist, tile2);
        ContactTest.assertTrue((boolean)iroquois.hasContacted(dutch));
        ContactTest.assertTrue((boolean)dutch.hasContacted(iroquois));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)iroquois.getStance(dutch));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)dutch.getStance(iroquois));
        ContactTest.assertNotNull((Object)iroquois.getTension(dutch));
    }

    public void testEuropeanMeetsIndianSettlement() throws Exception {
        ServerGame game = ServerTestHelper.startServerGame(ContactTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer iroquois = this.getServerPlayer(game, "model.nation.iroquois");
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        Tile tile3 = map.getTile(3, 8);
        tile3.setExplored(dutch, true);
        ContactTest.assertFalse((boolean)iroquois.hasContacted(dutch));
        ContactTest.assertFalse((boolean)dutch.hasContacted(iroquois));
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement is = builder.player(iroquois).settlementTile(tile3).skillToTeach(null).build();
        ServerUnit colonist = new ServerUnit(game, tile1, dutch, colonistType);
        colonist.setState(Unit.UnitState.FORTIFYING);
        colonist.setState(Unit.UnitState.FORTIFIED);
        igc.move(dutch, colonist, tile2);
        ContactTest.assertTrue((boolean)iroquois.hasContacted(dutch));
        ContactTest.assertTrue((boolean)dutch.hasContacted(iroquois));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)iroquois.getStance(dutch));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)dutch.getStance(iroquois));
        ContactTest.assertNotNull((Object)iroquois.getTension(dutch));
        ContactTest.assertNotNull((Object)is.getAlarm(dutch));
    }

    public void testNativeMeetsEuropean() throws Exception {
        ServerGame game = ServerTestHelper.startServerGame(ContactTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer apache = this.getServerPlayer(game, "model.nation.apache");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(french, true);
        Tile tile3 = map.getTile(3, 8);
        tile3.setExplored(french, true);
        ContactTest.assertFalse((boolean)french.hasContacted(apache));
        ContactTest.assertFalse((boolean)apache.hasContacted(french));
        ServerUnit brave = new ServerUnit(game, tile1, apache, braveType);
        brave.setState(Unit.UnitState.FORTIFYING);
        brave.setState(Unit.UnitState.FORTIFIED);
        ServerUnit colonist = new ServerUnit(game, tile3, french, colonistType);
        ContactTest.assertNotNull((Object)colonist);
        igc.move(apache, brave, tile2);
        ContactTest.assertTrue((boolean)french.hasContacted(apache));
        ContactTest.assertTrue((boolean)apache.hasContacted(french));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)french.getStance(apache));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)apache.getStance(french));
    }

    public void testNativeMeetsNative() throws Exception {
        ServerGame game = ServerTestHelper.startServerGame(ContactTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer apache = this.getServerPlayer(game, "model.nation.apache");
        ServerPlayer iroquois = this.getServerPlayer(game, "model.nation.iroquois");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        Tile tile3 = map.getTile(3, 8);
        ContactTest.assertTrue((boolean)iroquois.hasContacted(apache));
        ContactTest.assertTrue((boolean)apache.hasContacted(iroquois));
        ServerUnit brave1 = new ServerUnit(game, tile1, apache, braveType);
        brave1.setState(Unit.UnitState.FORTIFYING);
        brave1.setState(Unit.UnitState.FORTIFIED);
        ServerUnit brave2 = new ServerUnit(game, tile3, iroquois, braveType);
        ContactTest.assertNotNull((Object)brave2);
        igc.move(apache, brave1, tile2);
        ContactTest.assertTrue((boolean)iroquois.hasContacted(apache));
        ContactTest.assertTrue((boolean)apache.hasContacted(iroquois));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)iroquois.getStance(apache));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)apache.getStance(iroquois));
    }

    public void testNativeMeetsColony() throws Exception {
        ServerGame game = ServerTestHelper.startServerGame(ContactTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer apache = this.getServerPlayer(game, "model.nation.apache");
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        Tile tile3 = map.getTile(3, 8);
        tile3.setExplored(dutch, true);
        ContactTest.assertFalse((boolean)dutch.hasContacted(apache));
        ContactTest.assertFalse((boolean)apache.hasContacted(dutch));
        Colony colony = this.getStandardColony(1, 5, 8);
        ContactTest.assertNotNull((Object)colony);
        ServerUnit brave = new ServerUnit(game, tile3, apache, braveType);
        igc.move(apache, brave, tile2);
        ContactTest.assertTrue((boolean)dutch.hasContacted(apache));
        ContactTest.assertTrue((boolean)apache.hasContacted(dutch));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)dutch.getStance(apache));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)apache.getStance(dutch));
    }

    public void testNativeMeetsIndianSettlement() throws Exception {
        ServerGame game = ServerTestHelper.startServerGame(ContactTest.getTestMap(plains));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer apache = this.getServerPlayer(game, "model.nation.apache");
        ServerPlayer iroquois = this.getServerPlayer(game, "model.nation.iroquois");
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        Tile tile3 = map.getTile(3, 8);
        ContactTest.assertTrue((boolean)iroquois.hasContacted(apache));
        ContactTest.assertTrue((boolean)apache.hasContacted(iroquois));
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        builder.player(iroquois).settlementTile(tile3).skillToTeach(null).build();
        ServerUnit brave = new ServerUnit(game, tile1, apache, braveType);
        brave.setState(Unit.UnitState.FORTIFYING);
        brave.setState(Unit.UnitState.FORTIFIED);
        igc.move(apache, brave, tile2);
        ContactTest.assertTrue((boolean)iroquois.hasContacted(apache));
        ContactTest.assertTrue((boolean)apache.hasContacted(iroquois));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)iroquois.getStance(apache));
        ContactTest.assertEquals((Object)Stance.PEACE, (Object)apache.getStance(iroquois));
    }

    public void testShipMeetsShip() throws Exception {
        ServerGame game = ServerTestHelper.startServerGame(ContactTest.getTestMap(ocean));
        Map map = game.getMap();
        InGameController igc = ServerTestHelper.getInGameController();
        ServerPlayer dutch = this.getServerPlayer(game, "model.nation.dutch");
        ServerPlayer french = this.getServerPlayer(game, "model.nation.french");
        Tile tile1 = map.getTile(5, 8);
        tile1.setExplored(dutch, true);
        tile1.setExplored(french, true);
        Tile tile2 = map.getTile(4, 8);
        tile2.setExplored(dutch, true);
        tile2.setExplored(french, true);
        Tile tile3 = map.getTile(3, 8);
        tile3.setExplored(dutch, true);
        tile3.setExplored(french, true);
        ContactTest.assertFalse((boolean)french.hasContacted(dutch));
        ContactTest.assertFalse((boolean)dutch.hasContacted(french));
        ServerUnit ship1 = new ServerUnit(game, tile1, dutch, galleonType);
        ship1.setState(Unit.UnitState.FORTIFYING);
        ship1.setState(Unit.UnitState.FORTIFIED);
        ServerUnit ship2 = new ServerUnit(game, tile3, french, galleonType);
        ContactTest.assertNotNull((Object)ship2);
        igc.move(dutch, ship1, tile2);
        ContactTest.assertFalse((boolean)french.hasContacted(dutch));
        ContactTest.assertFalse((boolean)dutch.hasContacted(french));
        ContactTest.assertEquals((Object)Stance.UNCONTACTED, (Object)french.getStance(dutch));
        ContactTest.assertEquals((Object)Stance.UNCONTACTED, (Object)dutch.getStance(french));
    }
}

