/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class SetStanceMessage
extends AttributeMessage {
    public static final String TAG = "setStance";
    private static final String FIRST_TAG = "first";
    private static final String SECOND_TAG = "second";
    private static final String STANCE_TAG = "stance";

    public SetStanceMessage(Stance stance, Player first, Player second) {
        super(TAG, STANCE_TAG, String.valueOf(stance), FIRST_TAG, first.getId(), SECOND_TAG, second.getId());
    }

    public SetStanceMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, STANCE_TAG, FIRST_TAG, SECOND_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.STANCE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Stance stance = this.getStance();
        Player p1 = this.getFirstPlayer(game);
        Player p2 = this.getSecondPlayer(game);
        if (p1 == null) {
            logger.warning("Invalid player1 for setStance");
            return;
        }
        if (p2 == null) {
            logger.warning("Invalid player2 for setStance");
            return;
        }
        this.igc(freeColClient).setStanceHandler(stance, p1, p2);
        this.clientGeneric(freeColClient);
    }

    public Stance getStance() {
        return Enum.valueOf(Stance.class, this.getStringAttribute(STANCE_TAG));
    }

    public Player getFirstPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(FIRST_TAG), Player.class);
    }

    public Player getSecondPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(SECOND_TAG), Player.class);
    }
}

