/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model.production;

import java.util.stream.Stream;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.production.ProductionUtils;
import net.sf.freecol.common.model.production.WorkerAssignment;
import net.sf.freecol.common.util.CollectionUtils;

public class TileProductionCalculator {
    private Player owner;
    private int colonyProductionBonus;

    public TileProductionCalculator(Player owner, int colonyProductionBonus) {
        this.owner = owner;
        this.colonyProductionBonus = colonyProductionBonus;
    }

    public ProductionInfo getBasicProductionInfo(Tile tile, Turn turn, WorkerAssignment workerAssignment, boolean colonyCenterTile) {
        ProductionInfo pi = new ProductionInfo();
        if (workerAssignment.getProductionType() == null) {
            return pi;
        }
        if (colonyCenterTile) {
            CollectionUtils.forEach(workerAssignment.getProductionType().getOutputs(), output -> {
                int n = this.getCenterTileProduction(turn, tile, output.getType());
                if (n > 0) {
                    pi.addProduction(new AbstractGoods(output.getType(), n));
                }
            });
        } else {
            CollectionUtils.forEach(CollectionUtils.map(workerAssignment.getProductionType().getOutputs(), AbstractGoods::getType), gt -> {
                int n = this.getUnitProduction(turn, tile, workerAssignment, (GoodsType)gt);
                if (n > 0) {
                    pi.addProduction(new AbstractGoods((GoodsType)gt, n));
                }
            });
        }
        return pi;
    }

    public int getUnitProduction(Turn turn, Tile tile, WorkerAssignment workerAssignment, GoodsType goodsType) {
        if (workerAssignment == null || workerAssignment.getProductionType().getOutputs().noneMatch(g -> goodsType.equals(g.getType())) || workerAssignment.getUnitType() == null) {
            return 0;
        }
        return Math.max(0, (int)FeatureContainer.applyModifiers((float)this.getBaseProduction(tile, workerAssignment.getProductionType(), goodsType, workerAssignment.getUnitType()), turn, this.getProductionModifiers(turn, tile, goodsType, workerAssignment.getUnitType())));
    }

    private int getCenterTileProduction(Turn turn, Tile tile, GoodsType goodsType) {
        int production = tile.getBaseProduction(null, goodsType, null);
        return Math.max(0, (int)FeatureContainer.applyModifiers((float)production, turn, this.getCenterTileProductionModifiers(turn, tile, goodsType)));
    }

    private int getBaseProduction(Tile tile, ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        if (tile == null || goodsType == null || !goodsType.isFarmed()) {
            return 0;
        }
        int amount = tile.getBaseProduction(productionType, goodsType, unitType);
        return amount < 0 ? 0 : amount;
    }

    public Stream<Modifier> getProductionModifiers(Turn turn, Tile tile, GoodsType goodsType, UnitType unitType) {
        if (unitType == null || !tile.canProduce(goodsType, unitType)) {
            return Stream.empty();
        }
        return CollectionUtils.concat(tile.getProductionModifiers(goodsType, unitType), unitType.getModifiers(goodsType.getId(), tile.getType(), turn), this.owner == null ? null : this.owner.getModifiers(goodsType.getId(), unitType, turn), ProductionUtils.getRebelProductionModifiersForTile(tile, this.colonyProductionBonus, goodsType, unitType));
    }

    public Stream<Modifier> getCenterTileProductionModifiers(Turn turn, Tile tile, GoodsType goodsType) {
        if (!tile.canProduce(goodsType, null)) {
            return Stream.empty();
        }
        return CollectionUtils.concat(tile.getProductionModifiers(goodsType, null), ProductionUtils.getRebelProductionModifiersForTile(tile, this.colonyProductionBonus, goodsType, null));
    }
}

