/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise;

import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.enterprise.client.ServerProperties;
import ca.sqlpower.util.BrowserUtil;
import ca.sqlpower.util.HTMLUserPrompter;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.Version;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ServerInfoProvider {
    public static final String defaultWatermarkMessage = "<html>This version of SQL Power Architect is for EVALUATION PURPOSES ONLY. To obtain a full Production License, please visit <a href=\"http://www.sqlpower.ca/architect-e\">www.sqlpower.ca/architect-e</a></html>";
    private static Map<String, Version> version = new HashMap<String, Version>();
    private static Map<String, Boolean> licenses = new HashMap<String, Boolean>();
    private static Map<String, String> watermarkMessages = new HashMap<String, String>();

    public static Version getServerVersion(String host, String port, String path, String username, String password, CookieStore cookieStore) throws MalformedURLException, IOException {
        ServerInfoProvider.init(ServerInfoProvider.toURL(host, port, path), username, password, cookieStore);
        return version.get(ServerInfoProvider.generateServerKey(host, port, path, username, password));
    }

    public static boolean isServerLicensed(SPServerInfo infos, CookieStore cookieStore) throws MalformedURLException, IOException {
        return ServerInfoProvider.isServerLicensed(infos.getServerAddress(), String.valueOf(infos.getPort()), infos.getPath(), infos.getUsername(), infos.getPassword(), cookieStore);
    }

    public static boolean isServerLicensed(String host, String port, String path, String username, String password, CookieStore cookieStore) throws MalformedURLException, IOException {
        ServerInfoProvider.init(ServerInfoProvider.toURL(host, port, path), username, password, cookieStore);
        return licenses.get(ServerInfoProvider.generateServerKey(host, port, path, username, password));
    }

    private static URL toURL(String host, String port, String path) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append("http://");
        sb.append(host);
        sb.append(":");
        sb.append(port);
        sb.append(path);
        sb.append(path.endsWith("/") ? "" : "/");
        sb.append("rest");
        sb.append("/serverinfo");
        return new URL(sb.toString());
    }

    private static void init(URL url, String username, String password, CookieStore cookieStore) throws IOException {
        if (version.containsKey(ServerInfoProvider.generateServerKey(url, username, password))) {
            return;
        }
        try {
            String watermarkMessage;
            Boolean licensedServer;
            String serverVersion;
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)2000);
            DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)params);
            httpClient.setCookieStore(cookieStore);
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(url.getHost(), -1), (Credentials)new UsernamePasswordCredentials(username, password));
            HttpOptions request = new HttpOptions(url.toURI());
            String responseBody = (String)httpClient.execute((HttpUriRequest)request, (ResponseHandler)new BasicResponseHandler());
            try {
                JSONObject jsonObject = new JSONObject(responseBody);
                serverVersion = jsonObject.getString(ServerProperties.SERVER_VERSION.toString());
                licensedServer = jsonObject.getBoolean(ServerProperties.SERVER_LICENSED.toString());
                watermarkMessage = jsonObject.getString(ServerProperties.SERVER_WATERMARK_MESSAGE.toString());
            }
            catch (JSONException e) {
                throw new IOException(e.getMessage());
            }
            version.put(ServerInfoProvider.generateServerKey(url, username, password), new Version(serverVersion));
            licenses.put(ServerInfoProvider.generateServerKey(url, username, password), licensedServer);
            watermarkMessages.put(ServerInfoProvider.generateServerKey(url, username, password), watermarkMessage);
            if (!licensedServer.booleanValue() || watermarkMessage != null && watermarkMessage.trim().length() > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HyperlinkListener hyperlinkListener = new HyperlinkListener(){

                            @Override
                            public void hyperlinkUpdate(HyperlinkEvent e) {
                                try {
                                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getURL() != null) {
                                        BrowserUtil.launch(e.getURL().toString());
                                    }
                                }
                                catch (IOException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                        };
                        HTMLUserPrompter htmlPrompter = new HTMLUserPrompter(UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, watermarkMessage, hyperlinkListener, "OK");
                        htmlPrompter.promptUser("");
                    }
                });
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static String getWatermarkMessage(SPServerInfo infos, CookieStore cookieStore) throws MalformedURLException, IOException {
        return ServerInfoProvider.getWatermarkMessage(infos.getServerAddress(), String.valueOf(infos.getPort()), infos.getPath(), infos.getUsername(), infos.getPassword(), cookieStore);
    }

    public static String getWatermarkMessage(String host, String port, String path, String username, String password, CookieStore cookieStore) {
        String message = defaultWatermarkMessage;
        try {
            message = !ServerInfoProvider.isServerLicensed(host, port, path, username, password, cookieStore) ? watermarkMessages.get(ServerInfoProvider.generateServerKey(host, port, path, username, password)) : "";
        }
        catch (Exception e) {
            // empty catch block
        }
        return message;
    }

    private static String generateServerKey(String host, String port, String path, String username, String password) throws MalformedURLException {
        return ServerInfoProvider.generateServerKey(ServerInfoProvider.toURL(host, port, path), username, password);
    }

    private static String generateServerKey(URL url, String username, String password) {
        return String.valueOf(url.toString().concat(username).concat(password).hashCode());
    }
}

