/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp;

import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandler;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerTcpTransportHandler
extends TransportHandler {
    private ServerSocket serverSocket;
    private Socket socket;
    private final int port;
    private boolean externalServerSocket = false;

    public ServerTcpTransportHandler(long timeout, int port) {
        super(timeout, ConnectionEndType.SERVER);
        this.port = port;
    }

    public ServerTcpTransportHandler(long timeout, ServerSocket serverSocket) throws IOException {
        super(timeout, ConnectionEndType.SERVER);
        this.port = serverSocket.getLocalPort();
        this.serverSocket = serverSocket;
    }

    public ServerTcpTransportHandler(long timeout, Socket socket) throws IOException {
        super(timeout, ConnectionEndType.SERVER);
        this.port = socket.getLocalPort();
        this.socket = socket;
        socket.setSoTimeout(1);
        this.externalServerSocket = true;
    }

    public void closeServerSocket() throws IOException {
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        } else if (!this.externalServerSocket) {
            throw new IOException("TransportHandler not initialised");
        }
    }

    @Override
    public void initialize() throws IOException {
        if (!this.externalServerSocket) {
            if (this.serverSocket == null || this.serverSocket.isClosed()) {
                this.serverSocket = new ServerSocket(this.port);
            }
            this.socket = this.serverSocket.accept();
            this.socket.setSoTimeout(1);
        }
        this.setStreams(new PushbackInputStream(this.socket.getInputStream()), this.socket.getOutputStream());
    }

    @Override
    public boolean isClosed() throws IOException {
        if (this.isInitialized()) {
            if (this.socket != null && (this.socket.isClosed() || this.socket.isInputShutdown())) {
                if (this.externalServerSocket) {
                    return true;
                }
                if (this.serverSocket.isClosed()) {
                    return true;
                }
            } else if (this.socket == null) {
                if (this.externalServerSocket) {
                    return true;
                }
                if (this.serverSocket.isClosed()) {
                    return true;
                }
            }
            return false;
        }
        throw new IOException("Transporthandler is not initalized!");
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Override
    public void closeClientConnection() throws IOException {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public int getPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.port;
    }
}

