/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public class MathTransformsOrFactory {
    private static final MathTransformsOrFactory INSTANCE = new MathTransformsOrFactory();

    private MathTransformsOrFactory() {
    }

    public static MathTransformsOrFactory wrap(MathTransformFactory mathTransformFactory) {
        return mathTransformFactory != null ? new Specified(mathTransformFactory) : INSTANCE;
    }

    public MathTransform linear(Matrix matrix) throws FactoryException {
        return MathTransforms.linear(matrix);
    }

    public MathTransform passThrough(int n, MathTransform mathTransform, int n2) throws FactoryException {
        return MathTransforms.passThrough(n, mathTransform, n2);
    }

    public MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        return MathTransforms.concatenate(mathTransform, mathTransform2);
    }

    public final MathTransform concatenate(boolean bl, MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
        if (bl) {
            return this.concatenate(mathTransform2, mathTransform);
        }
        return this.concatenate(mathTransform, mathTransform2);
    }

    private static final class Specified
    extends MathTransformsOrFactory {
        private final MathTransformFactory factory;

        Specified(MathTransformFactory mathTransformFactory) {
            this.factory = mathTransformFactory;
        }

        @Override
        public MathTransform linear(Matrix matrix) throws FactoryException {
            return this.factory.createAffineTransform(matrix);
        }

        @Override
        public MathTransform passThrough(int n, MathTransform mathTransform, int n2) throws FactoryException {
            return this.factory.createPassThroughTransform(n, mathTransform, n2);
        }

        @Override
        public MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2) throws FactoryException {
            return this.factory.createConcatenatedTransform(mathTransform, mathTransform2);
        }
    }
}

