/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class SolrMultiCollectorManager
implements CollectorManager<Collectors, Object[]> {
    private final CollectorManager<Collector, ?>[] collectorManagers;

    @SafeVarargs
    public SolrMultiCollectorManager(CollectorManager<? extends Collector, ?> ... collectorManagers) {
        if (collectorManagers.length < 1) {
            throw new IllegalArgumentException("There must be at least one collector");
        }
        this.collectorManagers = collectorManagers;
    }

    public Collectors newCollector() throws IOException {
        return new Collectors();
    }

    public Object[] reduce(Collection<Collectors> reducableCollectors) throws IOException {
        int size = reducableCollectors.size();
        Object[] results = new Object[this.collectorManagers.length];
        for (int i = 0; i < this.collectorManagers.length; ++i) {
            ArrayList<Collector> reducableCollector = new ArrayList<Collector>(size);
            for (Collectors collectors : reducableCollectors) {
                reducableCollector.add(collectors.collectors[i]);
            }
            results[i] = this.collectorManagers[i].reduce(reducableCollector);
        }
        return results;
    }

    public static ScoreMode scoreMode(Collector[] collectors) {
        ScoreMode scoreMode = null;
        for (Collector collector : collectors) {
            if (scoreMode == null) {
                scoreMode = collector.scoreMode();
                continue;
            }
            if (scoreMode == collector.scoreMode()) continue;
            return ScoreMode.COMPLETE;
        }
        return scoreMode;
    }

    class Collectors
    implements Collector {
        private final Collector[] collectors;

        private Collectors() throws IOException {
            this.collectors = new Collector[SolrMultiCollectorManager.this.collectorManagers.length];
            for (int i = 0; i < this.collectors.length; ++i) {
                this.collectors[i] = SolrMultiCollectorManager.this.collectorManagers[i].newCollector();
            }
        }

        public final LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            return new LeafCollectors(context, this.scoreMode() == ScoreMode.TOP_SCORES);
        }

        public final ScoreMode scoreMode() {
            return SolrMultiCollectorManager.scoreMode(this.collectors);
        }

        private class LeafCollectors
        implements LeafCollector {
            private final LeafCollector[] leafCollectors;
            private final boolean skipNonCompetitiveScores;

            private LeafCollectors(LeafReaderContext context, boolean skipNonCompetitiveScores) throws IOException {
                this.skipNonCompetitiveScores = skipNonCompetitiveScores;
                this.leafCollectors = new LeafCollector[Collectors.this.collectors.length];
                for (int i = 0; i < Collectors.this.collectors.length; ++i) {
                    this.leafCollectors[i] = Collectors.this.collectors[i].getLeafCollector(context);
                }
            }

            public final void setScorer(Scorable scorer) throws IOException {
                if (this.skipNonCompetitiveScores) {
                    for (LeafCollector leafCollector : this.leafCollectors) {
                        if (leafCollector == null) continue;
                        leafCollector.setScorer(scorer);
                    }
                } else {
                    FilterScorable fScorer = new FilterScorable(scorer){

                        public void setMinCompetitiveScore(float minScore) throws IOException {
                        }
                    };
                    for (LeafCollector leafCollector : this.leafCollectors) {
                        if (leafCollector == null) continue;
                        leafCollector.setScorer((Scorable)fScorer);
                    }
                }
            }

            public final void collect(int doc) throws IOException {
                for (LeafCollector leafCollector : this.leafCollectors) {
                    if (leafCollector == null) continue;
                    leafCollector.collect(doc);
                }
            }
        }
    }
}

