/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.QueryBitSetProducer;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.ChildDocTransformer;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.search.SyntaxError;

public class ChildDocTransformerFactory
extends TransformerFactory {
    static final char PATH_SEP_CHAR = '/';
    static final char NUM_SEP_CHAR = '#';
    private static final ThreadLocal<Boolean> recursionCheckThreadLocal = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final BooleanQuery rootFilter = new BooleanQuery.Builder().add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST)).add(new BooleanClause((Query)new DocValuesFieldExistsQuery("_nest_path_"), BooleanClause.Occur.MUST_NOT)).build();
    public static final String CACHE_NAME = "perSegFilter";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocTransformer create(String field, SolrParams params, SolrQueryRequest req) {
        if (recursionCheckThreadLocal.get().booleanValue()) {
            return new DocTransformer.NoopFieldTransformer();
        }
        try {
            recursionCheckThreadLocal.set(true);
            DocTransformer docTransformer = this.createChildDocTransformer(field, params, req);
            return docTransformer;
        }
        finally {
            recursionCheckThreadLocal.set(false);
        }
    }

    private DocTransformer createChildDocTransformer(String field, SolrParams params, SolrQueryRequest req) {
        DocSet childDocSet;
        BitSetProducer parentsFilter;
        SchemaField uniqueKeyField = req.getSchema().getUniqueKeyField();
        if (uniqueKeyField == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, " ChildDocTransformer requires the schema to have a uniqueKeyField.");
        }
        boolean buildHierarchy = req.getSchema().hasExplicitField("_nest_path_");
        String parentFilterStr = params.get("parentFilter");
        if (parentFilterStr == null) {
            parentsFilter = !buildHierarchy ? null : ChildDocTransformerFactory.getCachedBitSetProducer(req, (Query)rootFilter);
        } else {
            if (buildHierarchy) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Parent filter should not be sent when the schema is nested");
            }
            Query query = ChildDocTransformerFactory.parseQuery(parentFilterStr, req, "parentFilter");
            if (query == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Parent filter '" + parentFilterStr + "', resolves to null");
            }
            parentsFilter = ChildDocTransformerFactory.getCachedBitSetProducer(req, query);
        }
        String childFilterStr = params.get("childFilter");
        if (childFilterStr == null) {
            childDocSet = null;
        } else {
            if (buildHierarchy) {
                childFilterStr = ChildDocTransformerFactory.processPathHierarchyQueryString(childFilterStr);
            }
            Query childFilter = ChildDocTransformerFactory.parseQuery(childFilterStr, req, "childFilter");
            try {
                childDocSet = req.getSearcher().getDocSet(childFilter);
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        String childReturnFields = params.get("fl");
        SolrReturnFields childSolrReturnFields = childReturnFields != null ? new SolrReturnFields(childReturnFields, req) : new SolrReturnFields(req);
        int limit = params.getInt("limit", -1);
        if (limit == -1) {
            limit = Integer.MAX_VALUE;
        }
        return new ChildDocTransformer(field, parentsFilter, childDocSet, childSolrReturnFields, buildHierarchy, limit, req.getSchema().getUniqueKeyField().getName());
    }

    private static Query parseQuery(String qstr, SolrQueryRequest req, String param) {
        try {
            return QParser.getParser(qstr, req).getQuery();
        }
        catch (SyntaxError syntaxError) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Failed to parse '" + param + "' param: " + syntaxError.getMessage(), (Throwable)syntaxError);
        }
    }

    protected static String processPathHierarchyQueryString(String queryString) {
        int indexOfFirstColon = queryString.indexOf(58);
        if (indexOfFirstColon <= 0) {
            return queryString;
        }
        int indexOfLastPathSepChar = queryString.lastIndexOf(47, indexOfFirstColon);
        if (indexOfLastPathSepChar < 0) {
            return queryString;
        }
        boolean isAbsolutePath = queryString.charAt(0) == '/';
        String path = ClientUtils.escapeQueryChars((String)queryString.substring(0, indexOfLastPathSepChar));
        String remaining = queryString.substring(indexOfLastPathSepChar + 1);
        return "+_nest_path_" + (isAbsolutePath ? ":" : ":*\\/") + path + " +(" + remaining + ")";
    }

    private static BitSetProducer getCachedBitSetProducer(SolrQueryRequest request, Query query) {
        SolrCache parentCache = request.getSearcher().getCache(CACHE_NAME);
        if (parentCache != null) {
            try {
                return parentCache.computeIfAbsent(query, QueryBitSetProducer::new);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new QueryBitSetProducer(query);
    }
}

