/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SubstringBytesRefFilter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.facet.FacetDebugInfo;
import org.apache.solr.util.LongPriorityQueue;

public class DocValuesFacets {
    private DocValuesFacets() {
    }

    public static NamedList<Integer> getCounts(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort, String prefix, String contains, boolean ignoreCase, FacetDebugInfo fdebug) throws IOException {
        SubstringBytesRefFilter termFilter = new SubstringBytesRefFilter(contains, ignoreCase);
        return DocValuesFacets.getCounts(searcher, docs, fieldName, offset, limit, mincount, missing, sort, prefix, termFilter, fdebug);
    }

    public static NamedList<Integer> getCounts(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort, String prefix, Predicate<BytesRef> termFilter, FacetDebugInfo fdebug) throws IOException {
        int missingCount;
        NamedList res;
        SchemaField schemaField;
        block35: {
            int lim;
            int endTermIndex;
            int startTermIndex;
            BytesRefBuilder prefixRef;
            SortedSetDocValues si;
            schemaField = searcher.getSchema().getField(fieldName);
            FieldType ft = schemaField.getType();
            res = new NamedList();
            boolean multiValued = schemaField.multiValued() || ft.multiValuedFieldCache();
            OrdinalMap ordinalMap = null;
            if (multiValued) {
                si = searcher.getSlowAtomicReader().getSortedSetDocValues(fieldName);
                if (si instanceof MultiDocValues.MultiSortedSetDocValues) {
                    ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)si).mapping;
                }
            } else {
                SortedDocValues single = searcher.getSlowAtomicReader().getSortedDocValues(fieldName);
                SortedSetDocValues sortedSetDocValues = si = single == null ? null : DocValues.singleton((SortedDocValues)single);
                if (single instanceof MultiDocValues.MultiSortedDocValues) {
                    ordinalMap = ((MultiDocValues.MultiSortedDocValues)single).mapping;
                }
            }
            if (si == null) {
                return DocValuesFacets.finalize((NamedList<Integer>)res, searcher, schemaField, docs, -1, missing);
            }
            if (si.getValueCount() >= Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Currently this faceting method is limited to 2147483647 unique terms");
            }
            if (prefix == null) {
                prefixRef = null;
            } else if (prefix.length() == 0) {
                prefix = null;
                prefixRef = null;
            } else {
                prefixRef = new BytesRefBuilder();
                prefixRef.copyChars((CharSequence)prefix);
            }
            if (prefix != null && si.getValueCount() > 0L) {
                startTermIndex = (int)si.lookupTerm(prefixRef.get());
                if (startTermIndex < 0) {
                    startTermIndex = -startTermIndex - 1;
                }
                prefixRef.append(UnicodeUtil.BIG_TERM);
                endTermIndex = (int)si.lookupTerm(prefixRef.get());
                assert (endTermIndex < 0);
                endTermIndex = -endTermIndex - 1;
            } else {
                startTermIndex = -1;
                endTermIndex = (int)si.getValueCount();
            }
            int nTerms = endTermIndex - startTermIndex;
            missingCount = -1;
            CharsRefBuilder charsRef = new CharsRefBuilder();
            if (nTerms <= 0 || docs.size() < mincount) break block35;
            int[] counts = new int[nTerms];
            if (fdebug != null) {
                fdebug.putInfoItem("numBuckets", nTerms);
            }
            List leaves = searcher.getTopReaderContext().leaves();
            for (int subIndex = 0; subIndex < leaves.size(); ++subIndex) {
                SortedSetDocValues sub;
                LeafReaderContext leaf = (LeafReaderContext)leaves.get(subIndex);
                DocIdSetIterator disi = docs.iterator(leaf);
                if (disi == null) continue;
                if (multiValued) {
                    SortedDocValues singleton;
                    sub = leaf.reader().getSortedSetDocValues(fieldName);
                    if (sub == null) {
                        sub = DocValues.emptySortedSet();
                    }
                    if ((singleton = DocValues.unwrapSingleton((SortedSetDocValues)sub)) != null) {
                        DocValuesFacets.accumSingle(counts, startTermIndex, singleton, disi, subIndex, ordinalMap);
                        continue;
                    }
                    DocValuesFacets.accumMulti(counts, startTermIndex, sub, disi, subIndex, ordinalMap);
                    continue;
                }
                sub = leaf.reader().getSortedDocValues(fieldName);
                if (sub == null) {
                    sub = DocValues.emptySorted();
                }
                DocValuesFacets.accumSingle(counts, startTermIndex, (SortedDocValues)sub, disi, subIndex, ordinalMap);
            }
            if (startTermIndex == -1) {
                missingCount = counts[0];
            }
            if (limit == 0) {
                return DocValuesFacets.finalize((NamedList<Integer>)res, searcher, schemaField, docs, missingCount, missing);
            }
            int off = offset;
            int n = lim = limit >= 0 ? limit : Integer.MAX_VALUE;
            if (sort.equals("count") || sort.equals("true")) {
                int i;
                int maxsize = limit > 0 ? offset + limit : 0x7FFFFFFE;
                maxsize = Math.min(maxsize, nTerms);
                LongPriorityQueue queue = new LongPriorityQueue(Math.min(maxsize, 1000), maxsize, Long.MIN_VALUE);
                int min = mincount - 1;
                int n2 = i = startTermIndex == -1 ? 1 : 0;
                while (i < nTerms) {
                    long pair;
                    boolean displaced;
                    BytesRef term;
                    int c = counts[i];
                    if (c > min && (termFilter == null || termFilter.test(term = si.lookupOrd((long)(startTermIndex + i)))) && (displaced = queue.insert(pair = ((long)c << 32) + (long)(Integer.MAX_VALUE - i)))) {
                        min = (int)(queue.top() >>> 32);
                    }
                    ++i;
                }
                int collectCount = Math.max(0, queue.size() - off);
                assert (collectCount <= lim);
                int sortedIdxStart = queue.size() - (collectCount - 1);
                int sortedIdxEnd = queue.size() + 1;
                long[] sorted = queue.sort(collectCount);
                for (int i2 = sortedIdxStart; i2 < sortedIdxEnd; ++i2) {
                    long pair = sorted[i2];
                    int c = (int)(pair >>> 32);
                    int tnum = Integer.MAX_VALUE - (int)pair;
                    BytesRef term = si.lookupOrd((long)(startTermIndex + tnum));
                    ft.indexedToReadable(term, charsRef);
                    res.add(charsRef.toString(), (Object)c);
                }
            } else {
                int i;
                int n3 = i = startTermIndex == -1 ? 1 : 0;
                if (mincount <= 0 && termFilter == null) {
                    i += off;
                    off = 0;
                }
                while (i < nTerms) {
                    int c = counts[i];
                    if (c >= mincount) {
                        BytesRef term = null;
                        if ((termFilter == null || termFilter.test(term = si.lookupOrd((long)(startTermIndex + i)))) && --off < 0) {
                            if (--lim < 0) break;
                            if (term == null) {
                                term = si.lookupOrd((long)(startTermIndex + i));
                            }
                            ft.indexedToReadable(term, charsRef);
                            res.add(charsRef.toString(), (Object)c);
                        }
                    }
                    ++i;
                }
            }
        }
        return DocValuesFacets.finalize((NamedList<Integer>)res, searcher, schemaField, docs, missingCount, missing);
    }

    static NamedList<Integer> finalize(NamedList<Integer> res, SolrIndexSearcher searcher, SchemaField schemaField, DocSet docs, int missingCount, boolean missing) throws IOException {
        if (missing) {
            if (missingCount < 0) {
                missingCount = SimpleFacets.getFieldMissingCount(searcher, docs, schemaField.getName());
            }
            res.add(null, (Object)missingCount);
        }
        return res;
    }

    static void accumSingle(int[] counts, int startTermIndex, SortedDocValues si, DocIdSetIterator disi, int subIndex, OrdinalMap map) throws IOException {
        if (startTermIndex == -1 && (map == null || (long)si.getValueCount() < disi.cost() * 10L)) {
            DocValuesFacets.accumSingleSeg(counts, si, disi, subIndex, map);
        } else {
            DocValuesFacets.accumSingleGeneric(counts, startTermIndex, si, disi, subIndex, map);
        }
    }

    static void accumSingleGeneric(int[] counts, int startTermIndex, SortedDocValues si, DocIdSetIterator disi, int subIndex, OrdinalMap map) throws IOException {
        int doc;
        LongValues ordmap;
        LongValues longValues = ordmap = map == null ? null : map.getGlobalOrds(subIndex);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int arrIdx;
            int term = si.advanceExact(doc) ? si.ordValue() : -1;
            if (map != null && term >= 0) {
                term = (int)ordmap.get((long)term);
            }
            if ((arrIdx = term - startTermIndex) < 0 || arrIdx >= counts.length) continue;
            int n = arrIdx;
            counts[n] = counts[n] + 1;
        }
    }

    static void accumSingleSeg(int[] counts, SortedDocValues si, DocIdSetIterator disi, int subIndex, OrdinalMap map) throws IOException {
        int doc;
        int[] segCounts = map == null ? counts : new int[1 + si.getValueCount()];
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            if (si.advanceExact(doc)) {
                int n = 1 + si.ordValue();
                segCounts[n] = segCounts[n] + 1;
                continue;
            }
            segCounts[0] = segCounts[0] + 1;
        }
        if (map != null) {
            DocValuesFacets.migrateGlobal(counts, segCounts, subIndex, map);
        }
    }

    static void accumMulti(int[] counts, int startTermIndex, SortedSetDocValues si, DocIdSetIterator disi, int subIndex, OrdinalMap map) throws IOException {
        if (startTermIndex == -1 && (map == null || si.getValueCount() < disi.cost() * 10L)) {
            DocValuesFacets.accumMultiSeg(counts, si, disi, subIndex, map);
        } else {
            DocValuesFacets.accumMultiGeneric(counts, startTermIndex, si, disi, subIndex, map);
        }
    }

    static void accumMultiGeneric(int[] counts, int startTermIndex, SortedSetDocValues si, DocIdSetIterator disi, int subIndex, OrdinalMap map) throws IOException {
        int doc;
        LongValues ordMap;
        LongValues longValues = ordMap = map == null ? null : map.getGlobalOrds(subIndex);
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            if (si.advanceExact(doc)) {
                int term = (int)si.nextOrd();
                do {
                    int arrIdx;
                    if (map != null) {
                        term = (int)ordMap.get((long)term);
                    }
                    if ((arrIdx = term - startTermIndex) < 0 || arrIdx >= counts.length) continue;
                    int n = arrIdx;
                    counts[n] = counts[n] + 1;
                } while ((term = (int)si.nextOrd()) >= 0);
                continue;
            }
            if (startTermIndex != -1) continue;
            counts[0] = counts[0] + 1;
        }
    }

    static void accumMultiSeg(int[] counts, SortedSetDocValues si, DocIdSetIterator disi, int subIndex, OrdinalMap map) throws IOException {
        int doc;
        int[] segCounts = map == null ? counts : new int[1 + (int)si.getValueCount()];
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            if (si.advanceExact(doc)) {
                int term = (int)si.nextOrd();
                do {
                    int n = 1 + term;
                    segCounts[n] = segCounts[n] + 1;
                } while ((term = (int)si.nextOrd()) >= 0);
                continue;
            }
            counts[0] = counts[0] + 1;
        }
        if (map != null) {
            DocValuesFacets.migrateGlobal(counts, segCounts, subIndex, map);
        }
    }

    static void migrateGlobal(int[] counts, int[] segCounts, int subIndex, OrdinalMap map) {
        LongValues ordMap = map.getGlobalOrds(subIndex);
        counts[0] = counts[0] + segCounts[0];
        for (int ord = 1; ord < segCounts.length; ++ord) {
            int count = segCounts[ord];
            if (count == 0) continue;
            int n = 1 + (int)ordMap.get((long)(ord - 1));
            counts[n] = counts[n] + count;
        }
    }
}

