/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.endpoint.NodeLoggingApis;
import org.apache.solr.client.api.model.ListLevelsResponse;
import org.apache.solr.client.api.model.LogLevelChange;
import org.apache.solr.client.api.model.LogLevelInfo;
import org.apache.solr.client.api.model.LogMessageInfo;
import org.apache.solr.client.api.model.LogMessagesResponse;
import org.apache.solr.client.api.model.LoggingResponse;
import org.apache.solr.client.api.model.SetThresholdRequestBody;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLogging
extends JerseyResource
implements NodeLoggingApis {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CoreContainer coreContainer;
    private final LogWatcher<?> watcher;

    @Inject
    public NodeLogging(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.watcher = coreContainer.getLogging();
    }

    @PermissionName(value=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public ListLevelsResponse listAllLoggersAndLevels() {
        List loggerInfo;
        this.ensureLogWatcherEnabled();
        ListLevelsResponse response = this.instantiateLoggingResponse(ListLevelsResponse.class);
        response.levels = this.watcher.getAllLevels();
        response.loggers = loggerInfo = this.watcher.getAllLoggers().stream().sorted().map(li -> new LogLevelInfo(li.getName(), li.getLevel(), li.isSet())).collect(Collectors.toList());
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public LoggingResponse modifyLocalLogLevel(List<LogLevelChange> requestBody) {
        this.ensureLogWatcherEnabled();
        LoggingResponse response = this.instantiateLoggingResponse(LoggingResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing request body");
        }
        for (LogLevelChange change : requestBody) {
            this.watcher.setLogLevel(change.logger, change.level);
        }
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public LogMessagesResponse fetchLocalLogMessages(Long boundingTimeMillis) {
        this.ensureLogWatcherEnabled();
        LogMessagesResponse response = this.instantiateLoggingResponse(LogMessagesResponse.class);
        if (boundingTimeMillis == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter, 'since'.");
        }
        AtomicBoolean found = new AtomicBoolean(false);
        SolrDocumentList docs = this.watcher.getHistory(boundingTimeMillis, found);
        if (docs == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "History not enabled");
        }
        LogMessageInfo info = new LogMessageInfo();
        if (boundingTimeMillis > 0L) {
            info.boundingTimeMillis = boundingTimeMillis;
            info.found = found.get();
        } else {
            info.levels = this.watcher.getAllLevels();
        }
        info.lastRecordTimestampMillis = this.watcher.getLastEvent();
        info.buffer = this.watcher.getHistorySize();
        response.info = info;
        response.docs = docs;
        return response;
    }

    @PermissionName(value=PermissionNameProvider.Name.CONFIG_EDIT_PERM)
    public LoggingResponse setMessageThreshold(SetThresholdRequestBody requestBody) {
        this.ensureLogWatcherEnabled();
        LoggingResponse response = this.instantiateLoggingResponse(LoggingResponse.class);
        if (requestBody == null || requestBody.level == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required parameter 'level' missing");
        }
        this.watcher.setThreshold(requestBody.level);
        return response;
    }

    public static void writeLogsForTesting() {
        log.trace("trace message");
        log.debug("debug message");
        RuntimeException exc = new RuntimeException("test");
        log.info("info (with exception) INFO", (Throwable)exc);
        log.warn("warn (with exception) WARN", (Throwable)exc);
        log.error("error (with exception) ERROR", (Throwable)exc);
    }

    private void ensureLogWatcherEnabled() {
        if (this.watcher == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Logging Not Initialized");
        }
    }

    private <T extends LoggingResponse> T instantiateLoggingResponse(Class<T> clazz) {
        LoggingResponse response = (LoggingResponse)this.instantiateJerseyResponse(clazz);
        response.watcherName = this.watcher.getName();
        return (T)response;
    }

    public static List<LogLevelChange> parseLogLevelChanges(String[] rawChangeValues) {
        ArrayList<LogLevelChange> changes = new ArrayList<LogLevelChange>();
        for (String rawChange : rawChangeValues) {
            String[] split = rawChange.split(":");
            if (split.length != 2) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid format, expected level:value, got " + rawChange);
            }
            changes.add(new LogLevelChange(split[0], split[1]));
        }
        return changes;
    }
}

