/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.CLIO;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.snapshots.CollectionSnapshotMetaData;

public class SnapshotDescribeTool
extends ToolBase {
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.getDefault());

    public SnapshotDescribeTool() {
        this(CLIO.getOutStream());
    }

    public SnapshotDescribeTool(PrintStream stdout) {
        super(stdout);
    }

    @Override
    public String getName() {
        return "snapshot-describe";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of collection to be snapshot.").build(), Option.builder().longOpt("snapshot-name").argName("NAME").hasArg().required(true).desc("Name of the snapshot to describe").build(), SolrCLI.OPTION_CREDENTIALS);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String snapshotName = cli.getOptionValue("snapshot-name");
        String collectionName = cli.getOptionValue("name");
        try (SolrClient solrClient = SolrCLI.getSolrClient(cli);){
            this.describeSnapshot(solrClient, collectionName, snapshotName);
        }
    }

    public void describeSnapshot(SolrClient solrClient, String collectionName, String snapshotName) {
        try {
            Collection<CollectionSnapshotMetaData> snaps = this.listCollectionSnapshots(solrClient, collectionName);
            for (CollectionSnapshotMetaData m : snaps) {
                if (!snapshotName.equals(m.getName())) continue;
                this.echo("Name: " + m.getName());
                this.echo("Status: " + m.getStatus());
                this.echo("Time of creation: " + dateFormat.format(m.getCreationDate()));
                this.echo("Total number of cores with snapshot: " + m.getReplicaSnapshots().size());
                this.echo("-----------------------------------");
                for (CollectionSnapshotMetaData.CoreSnapshotMetaData n : m.getReplicaSnapshots()) {
                    String builder = "Core [name=" + n.getCoreName() + ", leader=" + n.isLeader() + ", generation=" + n.getGenerationNumber() + ", indexDirPath=" + n.getIndexDirPath() + "]\n";
                    this.echo(builder);
                }
            }
        }
        catch (Exception e) {
            this.echo("Failed to fetch snapshot details due to following error : " + e.getLocalizedMessage());
        }
    }

    private Collection<CollectionSnapshotMetaData> listCollectionSnapshots(SolrClient solrClient, String collectionName) throws SolrServerException, IOException {
        CollectionAdminRequest.ListSnapshots listSnapshots = new CollectionAdminRequest.ListSnapshots(collectionName);
        CollectionAdminResponse resp = (CollectionAdminResponse)listSnapshots.process(solrClient);
        if (resp.getStatus() != 0) {
            throw new IllegalStateException("The LISTSNAPSHOTS request failed. The status code is " + resp.getStatus());
        }
        NamedList apiResult = (NamedList)resp.getResponse().get("snapshots");
        ArrayList<CollectionSnapshotMetaData> result = new ArrayList<CollectionSnapshotMetaData>();
        for (int i = 0; i < apiResult.size(); ++i) {
            result.add(new CollectionSnapshotMetaData((NamedList)apiResult.getVal(i)));
        }
        return result;
    }
}

