/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.server.log.remote.storage.RemoteStorageMetrics;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\t%v!B)S\u0011\u00039f!B-S\u0011\u0003Q\u0006\"B1\u0002\t\u0003\u0011\u0007bB2\u0002\u0005\u0004%\t\u0001\u001a\u0005\u0007[\u0006\u0001\u000b\u0011B3\t\u000f9\f!\u0019!C\u0001I\"1q.\u0001Q\u0001\n\u0015Dq\u0001]\u0001C\u0002\u0013\u0005A\r\u0003\u0004r\u0003\u0001\u0006I!\u001a\u0005\be\u0006\u0011\r\u0011\"\u0001e\u0011\u0019\u0019\u0018\u0001)A\u0005K\"9A/\u0001b\u0001\n\u0003!\u0007BB;\u0002A\u0003%Q\rC\u0004w\u0003\t\u0007I\u0011\u00013\t\r]\f\u0001\u0015!\u0003f\u0011\u001dA\u0018A1A\u0005\u0002\u0011Da!_\u0001!\u0002\u0013)\u0007b\u0002>\u0002\u0005\u0004%\t\u0001\u001a\u0005\u0007w\u0006\u0001\u000b\u0011B3\t\u000fq\f!\u0019!C\u0001I\"1Q0\u0001Q\u0001\n\u0015DqA`\u0001C\u0002\u0013\u0005A\r\u0003\u0004\u0000\u0003\u0001\u0006I!\u001a\u0005\t\u0003\u0003\t!\u0019!C\u0001I\"9\u00111A\u0001!\u0002\u0013)\u0007\u0002CA\u0003\u0003\t\u0007I\u0011\u00013\t\u000f\u0005\u001d\u0011\u0001)A\u0005K\"A\u0011\u0011B\u0001C\u0002\u0013\u0005A\rC\u0004\u0002\f\u0005\u0001\u000b\u0011B3\t\u0011\u00055\u0011A1A\u0005\u0002\u0011Dq!a\u0004\u0002A\u0003%Q\r\u0003\u0005\u0002\u0012\u0005\u0011\r\u0011\"\u0001e\u0011\u001d\t\u0019\"\u0001Q\u0001\n\u0015D\u0001\"!\u0006\u0002\u0005\u0004%\t\u0001\u001a\u0005\b\u0003/\t\u0001\u0015!\u0003f\u0011!\tI\"\u0001b\u0001\n\u0003!\u0007bBA\u000e\u0003\u0001\u0006I!\u001a\u0005\t\u0003;\t!\u0019!C\u0001I\"9\u0011qD\u0001!\u0002\u0013)\u0007\"CA\u0011\u0003E\u0005I\u0011AA\u0012\r\u0015I&\u000bAA&\u0011)\tI\u0006\u000bB\u0001B\u0003%\u0011q\u0005\u0005\u0007C\"\"\t!a\u0017\t\u0013\u0005\u0005\u0004F1A\u0005\n\u0005\r\u0004\u0002CACQ\u0001\u0006I!!\u001a\t\u0013\u0005\u001d\u0005F1A\u0005\n\u0005%\u0005\u0002CAIQ\u0001\u0006I!a#\t\u0013\u0005M\u0005F1A\u0005\u0002\u0005U\u0005\u0002CALQ\u0001\u0006I!a \t\u000f\u0005e\u0005\u0006\"\u0001\u0002\u001c\"9\u0011q\u0015\u0015\u0005\u0002\u0005%\u0006bBAWQ\u0011\u0005\u0011q\u0016\u0005\b\u0003\u0003DC\u0011BAb\u0011\u001d\t9\r\u000bC\u0001\u0003\u0013Dq!!4)\t\u0003\ty\rC\u0004\u0002T\"\"\t!!6\t\u000f\u0005e\u0007\u0006\"\u0001\u0002\\\"9\u0011q\u001c\u0015\u0005\u0002\u0005\u0005\bbBAsQ\u0011\u0005\u0011q\u001d\u0005\b\u0003kDC\u0011AA|\u0011\u001d\u00119\u0001\u000bC\u0001\u0005\u0013AqAa\u0004)\t\u0003\u0011\t\u0002C\u0004\u0003\u0016!\"\tAa\u0006\t\u000f\t}\u0001\u0006\"\u0001\u0003\"!9!q\u0005\u0015\u0005\u0002\t%\u0002b\u0002B\u0017Q\u0011\u0005!q\u0006\u0005\b\u0005oAC\u0011\u0001B\u001d\u0011\u001d\u0011y\u0004\u000bC\u0001\u0005\u0003BqA!\u0012)\t\u0003\u00119\u0005C\u0004\u0003P!\"\tA!\u0015\t\u000f\t]\u0003\u0006\"\u0001\u0003Z!9!Q\f\u0015\u0005\u0002\t}\u0003b\u0002B4Q\u0011\u0005!\u0011\u000e\u0005\b\u0005_BC\u0011\u0001B9\u0011\u001d\u0011)\b\u000bC\u0001\u0005oBqAa )\t\u0003\u0011\t\tC\u0004\u0003\b\"\"\tA!#\t\u000f\t5\u0005\u0006\"\u0001\u0003\u0010\"9!q\u0013\u0015\u0005\u0002\te\u0005b\u0002BPQ\u0011\u0005!\u0011\u0015\u0005\b\u0005KCC\u0011\u0001BT\u0003A\u0011%o\\6feR{\u0007/[2Ti\u0006$8O\u0003\u0002T)\u000611/\u001a:wKJT\u0011!V\u0001\u0006W\u000647.Y\u0002\u0001!\tA\u0016!D\u0001S\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8o\u0005\u0002\u00027B\u0011AlX\u0007\u0002;*\ta,A\u0003tG\u0006d\u0017-\u0003\u0002a;\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A,\u0002!5+7o]1hKNLe\u000eU3s'\u0016\u001cW#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017\u0001\u00027b]\u001eT\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\n11\u000b\u001e:j]\u001e\f\u0011#T3tg\u0006<Wm]%o!\u0016\u00148+Z2!\u00035\u0011\u0015\u0010^3t\u0013:\u0004VM]*fG\u0006q!)\u001f;fg&s\u0007+\u001a:TK\u000e\u0004\u0013A\u0004\"zi\u0016\u001cx*\u001e;QKJ\u001cVmY\u0001\u0010\u0005f$Xm](viB+'oU3dA\u0005\u0019\")\u001f;fgJ+'.Z2uK\u0012\u0004VM]*fG\u0006!\")\u001f;fgJ+'.Z2uK\u0012\u0004VM]*fG\u0002\n\u0001DU3qY&\u001c\u0017\r^5p]\nKH/Z:J]B+'oU3d\u0003e\u0011V\r\u001d7jG\u0006$\u0018n\u001c8CsR,7/\u00138QKJ\u001cVm\u0019\u0011\u00023I+\u0007\u000f\\5dCRLwN\u001c\"zi\u0016\u001cx*\u001e;QKJ\u001cVmY\u0001\u001b%\u0016\u0004H.[2bi&|gNQ=uKN|U\u000f\u001e)feN+7\rI\u0001\u001c\r\u0006LG.\u001a3Qe>$WoY3SKF,Xm\u001d;t!\u0016\u00148+Z2\u00029\u0019\u000b\u0017\u000e\\3e!J|G-^2f%\u0016\fX/Z:ugB+'oU3dA\u0005Ib)Y5mK\u00124U\r^2i%\u0016\fX/Z:ugB+'oU3d\u0003i1\u0015-\u001b7fI\u001a+Go\u00195SKF,Xm\u001d;t!\u0016\u00148+Z2!\u0003i!v\u000e^1m!J|G-^2f%\u0016\fX/Z:ugB+'oU3d\u0003m!v\u000e^1m!J|G-^2f%\u0016\fX/Z:ugB+'oU3dA\u0005ABk\u001c;bY\u001a+Go\u00195SKF,Xm\u001d;t!\u0016\u00148+Z2\u00023Q{G/\u00197GKR\u001c\u0007NU3rk\u0016\u001cHo\u001d)feN+7\rI\u0001\u001e\r\u0016$8\r['fgN\fw-Z\"p]Z,'o]5p]N\u0004VM]*fG\u0006qb)\u001a;dQ6+7o]1hK\u000e{gN^3sg&|gn\u001d)feN+7\rI\u0001 !J|G-^2f\u001b\u0016\u001c8/Y4f\u0007>tg/\u001a:tS>t7\u000fU3s'\u0016\u001c\u0017\u0001\t)s_\u0012,8-Z'fgN\fw-Z\"p]Z,'o]5p]N\u0004VM]*fG\u0002\n\u0011DU3bgNLwM\\7f]R\u0014\u0015\u0010^3t\u0013:\u0004VM]*fG\u0006Q\"+Z1tg&<g.\\3oi\nKH/Z:J]B+'oU3dA\u0005Q\"+Z1tg&<g.\\3oi\nKH/Z:PkR\u0004VM]*fG\u0006Y\"+Z1tg&<g.\\3oi\nKH/Z:PkR\u0004VM]*fG\u0002\n\u0001ET8LKf\u001cu.\u001c9bGR,G\rV8qS\u000e\u0014VmY8sIN\u0004VM]*fG\u0006\tcj\\&fs\u000e{W\u000e]1di\u0016$Gk\u001c9jGJ+7m\u001c:egB+'oU3dA\u0005y\u0012J\u001c<bY&$W*Y4jG:+XNY3s%\u0016\u001cwN\u001d3t!\u0016\u00148+Z2\u0002A%sg/\u00197jI6\u000bw-[2Ok6\u0014WM\u001d*fG>\u0014Hm\u001d)feN+7\rI\u0001\u001f\u0013:4\u0018\r\\5e\u001b\u0016\u001c8/Y4f\u0007J\u001c'+Z2pe\u0012\u001c\b+\u001a:TK\u000e\fq$\u00138wC2LG-T3tg\u0006<Wm\u0011:d%\u0016\u001cwN\u001d3t!\u0016\u00148+Z2!\u0003\u0011JeN^1mS\u0012|eMZ:fi>\u00138+Z9vK:\u001cWMU3d_J$7\u000fU3s'\u0016\u001c\u0017!J%om\u0006d\u0017\u000eZ(gMN,Go\u0014:TKF,XM\\2f%\u0016\u001cwN\u001d3t!\u0016\u00148+Z2!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0005\u0016\u0005\u0003O\tI\u0004\u0005\u0004\u0002*\u0005=\u00121G\u0007\u0003\u0003WQ1!!\fj\u0003\u0011)H/\u001b7\n\t\u0005E\u00121\u0006\u0002\t\u001fB$\u0018n\u001c8bYB\u0019\u0001,!\u000e\n\u0007\u0005]\"KA\u0006LC\u001a\\\u0017mQ8oM&<7FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015S,\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0014\t!Z\u0016Q\n\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b+\u0002\u000bU$\u0018\u000e\\:\n\t\u0005]\u0013\u0011\u000b\u0002\b\u0019><w-\u001b8h\u0003%\u0019wN\u001c4jO>\u0003H\u000f\u0006\u0003\u0002^\u0005}\u0003C\u0001-)\u0011%\tIF\u000bI\u0001\u0002\u0004\t9#\u0001\u0007wC2,XMR1di>\u0014\u00180\u0006\u0002\u0002fA9A,a\u001a\u0002l\u0005}\u0014bAA5;\nIa)\u001e8di&|g.\r\t\u0005\u0003[\nYH\u0004\u0003\u0002p\u0005]\u0004cAA9;6\u0011\u00111\u000f\u0006\u0004\u0003k2\u0016A\u0002\u001fs_>$h(C\u0002\u0002zu\u000ba\u0001\u0015:fI\u00164\u0017b\u00017\u0002~)\u0019\u0011\u0011P/\u0011\u0007a\u000b\t)C\u0002\u0002\u0004J\u0013!C\u0011:pW\u0016\u0014Hk\u001c9jG6+GO]5dg\u0006ia/\u00197vK\u001a\u000b7\r^8ss\u0002\nQa\u001d;biN,\"!a#\u0011\u0011\u0005=\u0013QRA6\u0003\u007fJA!a$\u0002R\t!\u0001k\\8m\u0003\u0019\u0019H/\u0019;tA\u0005q\u0011\r\u001c7U_BL7m]*uCR\u001cXCAA@\u0003=\tG\u000e\u001c+pa&\u001c7o\u0015;biN\u0004\u0013aE5t)>\u0004\u0018nY*uCR\u001cX\t_5ti\u0016$G\u0003BAO\u0003G\u00032\u0001XAP\u0013\r\t\t+\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\t)+\ra\u0001\u0003W\nQ\u0001^8qS\u000e\f!\u0002^8qS\u000e\u001cF/\u0019;t)\u0011\ty(a+\t\u000f\u0005\u0015&\u00071\u0001\u0002l\u0005AR\u000f\u001d3bi\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8CsR,7/\u00138\u0015\t\u0005E\u0016q\u0017\t\u00049\u0006M\u0016bAA[;\n!QK\\5u\u0011\u001d\tIl\ra\u0001\u0003w\u000bQA^1mk\u0016\u00042\u0001XA_\u0013\r\ty,\u0018\u0002\u0005\u0019>tw-A\rva\u0012\fG/\u001a*fa2L7-\u0019;j_:\u0014\u0015\u0010^3t\u001fV$H\u0003BAY\u0003\u000bDq!!/5\u0001\u0004\tY,A\rva\u0012\fG/\u001a*fCN\u001c\u0018n\u001a8nK:$()\u001f;fg&sG\u0003BAY\u0003\u0017Dq!!/6\u0001\u0004\tY,\u0001\u000eva\u0012\fG/\u001a*fCN\u001c\u0018n\u001a8nK:$()\u001f;fg>+H\u000f\u0006\u0003\u00022\u0006E\u0007bBA]m\u0001\u0007\u00111X\u0001\u0017e\u0016lwN^3PY\u0012dU-\u00193fe6+GO]5dgR!\u0011\u0011WAl\u0011\u001d\t)k\u000ea\u0001\u0003W\n\u0001D]3n_Z,w\n\u001c3G_2dwn^3s\u001b\u0016$(/[2t)\u0011\t\t,!8\t\u000f\u0005\u0015\u0006\b1\u0001\u0002l\u0005i!/Z7pm\u0016lU\r\u001e:jGN$B!!-\u0002d\"9\u0011QU\u001dA\u0002\u0005-\u0014AD;qI\u0006$XMQ=uKN|U\u000f\u001e\u000b\u000b\u0003c\u000bI/a;\u0002p\u0006M\bbBASu\u0001\u0007\u00111\u000e\u0005\b\u0003[T\u0004\u0019AAO\u0003)I7OR8mY><XM\u001d\u0005\b\u0003cT\u0004\u0019AAO\u00039I7OU3bgNLwM\\7f]RDq!!/;\u0001\u0004\tY,\u0001\rsK\u000e|'\u000f\u001a*f[>$XmQ8qs2\u000bwMQ=uKN$\u0002\"!-\u0002z\u0006m(Q\u0001\u0005\b\u0003K[\u0004\u0019AA6\u0011\u001d\tip\u000fa\u0001\u0003\u007f\f\u0011\u0002]1si&$\u0018n\u001c8\u0011\u0007q\u0013\t!C\u0002\u0003\u0004u\u00131!\u00138u\u0011\u001d\tIl\u000fa\u0001\u0003w\u000b\u0001D]3n_Z,'+Z7pi\u0016\u001cu\u000e]=MC\u001e\u0014\u0015\u0010^3t)\u0019\t\tLa\u0003\u0003\u000e!9\u0011Q\u0015\u001fA\u0002\u0005-\u0004bBA\u007fy\u0001\u0007\u0011q`\u0001$e\u0016lwN^3Ce>\\WM\u001d'fm\u0016d'+Z7pi\u0016\u001cu\u000e]=MC\u001e\u0014\u0015\u0010^3t)\u0011\t\tLa\u0005\t\u000f\u0005\u0015V\b1\u0001\u0002l\u0005Y\"/Z2pe\u0012\u0014V-\\8uK\u000e{\u0007/\u001f'bON+w-\\3oiN$\u0002\"!-\u0003\u001a\tm!Q\u0004\u0005\b\u0003Ks\u0004\u0019AA6\u0011\u001d\tiP\u0010a\u0001\u0003\u007fDq!!/?\u0001\u0004\tY,A\u000esK6|g/\u001a*f[>$XmQ8qs2\u000bwmU3h[\u0016tGo\u001d\u000b\u0007\u0003c\u0013\u0019C!\n\t\u000f\u0005\u0015v\b1\u0001\u0002l!9\u0011Q` A\u0002\u0005}\u0018A\n:f[>4XM\u0011:pW\u0016\u0014H*\u001a<fYJ+Wn\u001c;f\u0007>\u0004\u0018\u0010T1h'\u0016<W.\u001a8ugR!\u0011\u0011\u0017B\u0016\u0011\u001d\t)\u000b\u0011a\u0001\u0003W\n!D]3d_J$'+Z7pi\u0016$U\r\\3uK2\u000bwMQ=uKN$\u0002\"!-\u00032\tM\"Q\u0007\u0005\b\u0003K\u000b\u0005\u0019AA6\u0011\u001d\ti0\u0011a\u0001\u0003\u007fDq!!/B\u0001\u0004\tY,\u0001\u000esK6|g/\u001a*f[>$X\rR3mKR,G*Y4CsR,7\u000f\u0006\u0004\u00022\nm\"Q\b\u0005\b\u0003K\u0013\u0005\u0019AA6\u0011\u001d\tiP\u0011a\u0001\u0003\u007f\fQE]3n_Z,'I]8lKJdUM^3m%\u0016lw\u000e^3EK2,G/\u001a'bO\nKH/Z:\u0015\t\u0005E&1\t\u0005\b\u0003K\u001b\u0005\u0019AA6\u0003u\u0011XmY8sIJ+Wn\u001c;f\t\u0016dW\r^3MC\u001e\u001cVmZ7f]R\u001cH\u0003CAY\u0005\u0013\u0012YE!\u0014\t\u000f\u0005\u0015F\t1\u0001\u0002l!9\u0011Q #A\u0002\u0005}\bbBA]\t\u0002\u0007\u00111X\u0001\u001ee\u0016lwN^3SK6|G/\u001a#fY\u0016$X\rT1h'\u0016<W.\u001a8ugR1\u0011\u0011\u0017B*\u0005+Bq!!*F\u0001\u0004\tY\u0007C\u0004\u0002~\u0016\u0003\r!a@\u0002QI,Wn\u001c<f\u0005J|7.\u001a:MKZ,GNU3n_R,G)\u001a7fi\u0016d\u0015mZ*fO6,g\u000e^:\u0015\t\u0005E&1\f\u0005\b\u0003K3\u0005\u0019AA6\u0003q\u0011XmY8sIJ+Wn\u001c;f\u0019><W*\u001a;bI\u0006$\u0018mQ8v]R$\u0002\"!-\u0003b\t\r$Q\r\u0005\b\u0003K;\u0005\u0019AA6\u0011\u001d\tip\u0012a\u0001\u0003\u007fDq!!/H\u0001\u0004\tY,\u0001\u000fsK6|g/\u001a*f[>$X\rT8h\u001b\u0016$\u0018\rZ1uC\u000e{WO\u001c;\u0015\r\u0005E&1\u000eB7\u0011\u001d\t)\u000b\u0013a\u0001\u0003WBq!!@I\u0001\u0004\ty0A\u0014sK6|g/\u001a\"s_.,'\u000fT3wK2\u0014V-\\8uK2{w-T3uC\u0012\fG/Y\"pk:$H\u0003BAY\u0005gBq!!*J\u0001\u0004\tY'\u0001\u0012sK\u000e|'\u000f\u001a*f[>$X\rT8h'&TXmQ8naV$\u0018\r^5p]RKW.\u001a\u000b\t\u0003c\u0013IHa\u001f\u0003~!9\u0011Q\u0015&A\u0002\u0005-\u0004bBA\u007f\u0015\u0002\u0007\u0011q \u0005\b\u0003sS\u0005\u0019AA^\u0003\t\u0012X-\\8wKJ+Wn\u001c;f\u0019><7+\u001b>f\u0007>l\u0007/\u001e;bi&|g\u000eV5nKR1\u0011\u0011\u0017BB\u0005\u000bCq!!*L\u0001\u0004\tY\u0007C\u0004\u0002~.\u0003\r!a@\u0002[I,Wn\u001c<f\u0005J|7.\u001a:MKZ,GNU3n_R,Gj\\4TSj,7i\\7qkR\fG/[8o)&lW\r\u0006\u0003\u00022\n-\u0005bBAS\u0019\u0002\u0007\u00111N\u0001\u0019e\u0016\u001cwN\u001d3SK6|G/\u001a'pONK'0\u001a\"zi\u0016\u001cH\u0003CAY\u0005#\u0013\u0019J!&\t\u000f\u0005\u0015V\n1\u0001\u0002l!9\u0011Q`'A\u0002\u0005}\bbBA]\u001b\u0002\u0007\u00111X\u0001\u0019e\u0016lwN^3SK6|G/\u001a'pONK'0\u001a\"zi\u0016\u001cHCBAY\u00057\u0013i\nC\u0004\u0002&:\u0003\r!a\u001b\t\u000f\u0005uh\n1\u0001\u0002\u0000\u0006\u0019#/Z7pm\u0016\u0014%o\\6fe2+g/\u001a7SK6|G/\u001a'pONK'0\u001a\"zi\u0016\u001cH\u0003BAY\u0005GCq!!*P\u0001\u0004\tY'A\u0003dY>\u001cX\r\u0006\u0002\u00022\u0002")
public class BrokerTopicStats
implements Logging {
    private final Optional<KafkaConfig> configOpt;
    private final Function1<String, BrokerTopicMetrics> valueFactory;
    private final Pool<String, BrokerTopicMetrics> stats;
    private final BrokerTopicMetrics allTopicsStats;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Optional<KafkaConfig> $lessinit$greater$default$1() {
        return Optional.empty();
    }

    public static String InvalidOffsetOrSequenceRecordsPerSec() {
        return BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec();
    }

    public static String InvalidMessageCrcRecordsPerSec() {
        return BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec();
    }

    public static String InvalidMagicNumberRecordsPerSec() {
        return BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec();
    }

    public static String NoKeyCompactedTopicRecordsPerSec() {
        return BrokerTopicStats$.MODULE$.NoKeyCompactedTopicRecordsPerSec();
    }

    public static String ReassignmentBytesOutPerSec() {
        return BrokerTopicStats$.MODULE$.ReassignmentBytesOutPerSec();
    }

    public static String ReassignmentBytesInPerSec() {
        return BrokerTopicStats$.MODULE$.ReassignmentBytesInPerSec();
    }

    public static String ProduceMessageConversionsPerSec() {
        return BrokerTopicStats$.MODULE$.ProduceMessageConversionsPerSec();
    }

    public static String FetchMessageConversionsPerSec() {
        return BrokerTopicStats$.MODULE$.FetchMessageConversionsPerSec();
    }

    public static String TotalFetchRequestsPerSec() {
        return BrokerTopicStats$.MODULE$.TotalFetchRequestsPerSec();
    }

    public static String TotalProduceRequestsPerSec() {
        return BrokerTopicStats$.MODULE$.TotalProduceRequestsPerSec();
    }

    public static String FailedFetchRequestsPerSec() {
        return BrokerTopicStats$.MODULE$.FailedFetchRequestsPerSec();
    }

    public static String FailedProduceRequestsPerSec() {
        return BrokerTopicStats$.MODULE$.FailedProduceRequestsPerSec();
    }

    public static String ReplicationBytesOutPerSec() {
        return BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec();
    }

    public static String ReplicationBytesInPerSec() {
        return BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec();
    }

    public static String BytesRejectedPerSec() {
        return BrokerTopicStats$.MODULE$.BytesRejectedPerSec();
    }

    public static String BytesOutPerSec() {
        return BrokerTopicStats$.MODULE$.BytesOutPerSec();
    }

    public static String BytesInPerSec() {
        return BrokerTopicStats$.MODULE$.BytesInPerSec();
    }

    public static String MessagesInPerSec() {
        return BrokerTopicStats$.MODULE$.MessagesInPerSec();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Function1<String, BrokerTopicMetrics> valueFactory() {
        return this.valueFactory;
    }

    private Pool<String, BrokerTopicMetrics> stats() {
        return this.stats;
    }

    public BrokerTopicMetrics allTopicsStats() {
        return this.allTopicsStats;
    }

    public boolean isTopicStatsExisted(String topic) {
        return this.stats().contains(topic);
    }

    public BrokerTopicMetrics topicStats(String topic) {
        return this.stats().getAndMaybePut(topic);
    }

    public void updateReplicationBytesIn(long value) {
        this.allTopicsStats().replicationBytesInRate().foreach((Function1 & Serializable)metric -> {
            metric.mark(value);
            return BoxedUnit.UNIT;
        });
    }

    private void updateReplicationBytesOut(long value) {
        this.allTopicsStats().replicationBytesOutRate().foreach((Function1 & Serializable)metric -> {
            metric.mark(value);
            return BoxedUnit.UNIT;
        });
    }

    public void updateReassignmentBytesIn(long value) {
        this.allTopicsStats().reassignmentBytesInPerSec().foreach((Function1 & Serializable)metric -> {
            metric.mark(value);
            return BoxedUnit.UNIT;
        });
    }

    public void updateReassignmentBytesOut(long value) {
        this.allTopicsStats().reassignmentBytesOutPerSec().foreach((Function1 & Serializable)metric -> {
            metric.mark(value);
            return BoxedUnit.UNIT;
        });
    }

    public void removeOldLeaderMetrics(String topic) {
        BrokerTopicMetrics topicMetrics = this.topicStats(topic);
        if (topicMetrics != null) {
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.MessagesInPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.BytesInPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.BytesRejectedPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.FailedProduceRequestsPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.TotalProduceRequestsPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ProduceMessageConversionsPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ReplicationBytesOutPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ReassignmentBytesOutPerSec());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_BYTES_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_FETCH_BYTES_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_FETCH_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_DELETE_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.BUILD_REMOTE_LOG_AUX_STATE_REQUESTS_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_REMOTE_FETCH_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_REMOTE_COPY_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_LOG_METADATA_COUNT_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_LOG_SIZE_COMPUTATION_TIME_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_LOG_SIZE_BYTES_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_REMOTE_DELETE_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.FAILED_BUILD_REMOTE_LOG_AUX_STATE_PER_SEC_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_LAG_BYTES_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_COPY_LAG_SEGMENTS_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_DELETE_LAG_BYTES_METRIC.getName());
            topicMetrics.closeMetric(RemoteStorageMetrics.REMOTE_DELETE_LAG_SEGMENTS_METRIC.getName());
            return;
        }
    }

    public void removeOldFollowerMetrics(String topic) {
        BrokerTopicMetrics topicMetrics = this.topicStats(topic);
        if (topicMetrics != null) {
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ReplicationBytesInPerSec());
            topicMetrics.closeMetric(BrokerTopicStats$.MODULE$.ReassignmentBytesInPerSec());
            return;
        }
    }

    public void removeMetrics(String topic) {
        BrokerTopicMetrics metrics = this.stats().remove(topic);
        if (metrics != null) {
            metrics.close();
            return;
        }
    }

    public void updateBytesOut(String topic, boolean isFollower, boolean isReassignment, long value) {
        if (isFollower) {
            if (isReassignment) {
                this.updateReassignmentBytesOut(value);
            }
            this.updateReplicationBytesOut(value);
            return;
        }
        this.topicStats(topic).bytesOutRate().mark(value);
        this.allTopicsStats().bytesOutRate().mark(value);
    }

    public void recordRemoteCopyLagBytes(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteCopyLagBytesAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats().remoteCopyLagBytesAggrMetric().setValue(topic, topicMetric.remoteCopyLagBytes());
    }

    public void removeRemoteCopyLagBytes(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteCopyLagBytesAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats().remoteCopyLagBytesAggrMetric().setValue(topic, topicMetric.remoteCopyLagBytes());
    }

    public void removeBrokerLevelRemoteCopyLagBytes(String topic) {
        this.allTopicsStats().remoteCopyLagBytesAggrMetric().removeKey(topic);
    }

    public void recordRemoteCopyLagSegments(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteCopyLagSegmentsAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats().remoteCopyLagSegmentsAggrMetric().setValue(topic, topicMetric.remoteCopyLagSegments());
    }

    public void removeRemoteCopyLagSegments(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteCopyLagSegmentsAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats().remoteCopyLagSegmentsAggrMetric().setValue(topic, topicMetric.remoteCopyLagSegments());
    }

    public void removeBrokerLevelRemoteCopyLagSegments(String topic) {
        this.allTopicsStats().remoteCopyLagSegmentsAggrMetric().removeKey(topic);
    }

    public void recordRemoteDeleteLagBytes(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteDeleteLagBytesAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats().remoteDeleteLagBytesAggrMetric().setValue(topic, topicMetric.remoteDeleteLagBytes());
    }

    public void removeRemoteDeleteLagBytes(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteDeleteLagBytesAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats().remoteDeleteLagBytesAggrMetric().setValue(topic, topicMetric.remoteDeleteLagBytes());
    }

    public void removeBrokerLevelRemoteDeleteLagBytes(String topic) {
        this.allTopicsStats().remoteDeleteLagBytesAggrMetric().removeKey(topic);
    }

    public void recordRemoteDeleteLagSegments(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteDeleteLagSegmentsAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats().remoteDeleteLagSegmentsAggrMetric().setValue(topic, topicMetric.remoteDeleteLagSegments());
    }

    public void removeRemoteDeleteLagSegments(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteDeleteLagSegmentsAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats().remoteDeleteLagSegmentsAggrMetric().setValue(topic, topicMetric.remoteDeleteLagSegments());
    }

    public void removeBrokerLevelRemoteDeleteLagSegments(String topic) {
        this.allTopicsStats().remoteDeleteLagSegmentsAggrMetric().removeKey(topic);
    }

    public void recordRemoteLogMetadataCount(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogMetadataCountAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats().remoteLogMetadataCountAggrMetric().setValue(topic, topicMetric.remoteLogMetadataCount());
    }

    public void removeRemoteLogMetadataCount(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogMetadataCountAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats().remoteLogMetadataCountAggrMetric().setValue(topic, topicMetric.remoteLogMetadataCount());
    }

    public void removeBrokerLevelRemoteLogMetadataCount(String topic) {
        this.allTopicsStats().remoteLogMetadataCountAggrMetric().removeKey(topic);
    }

    public void recordRemoteLogSizeComputationTime(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogSizeComputationTimeAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats().remoteLogSizeComputationTimeAggrMetric().setValue(topic, topicMetric.remoteLogSizeComputationTime());
    }

    public void removeRemoteLogSizeComputationTime(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogSizeComputationTimeAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats().remoteLogSizeComputationTimeAggrMetric().setValue(topic, topicMetric.remoteLogSizeComputationTime());
    }

    public void removeBrokerLevelRemoteLogSizeComputationTime(String topic) {
        this.allTopicsStats().remoteLogSizeComputationTimeAggrMetric().removeKey(topic);
    }

    public void recordRemoteLogSizeBytes(String topic, int partition, long value) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogSizeBytesAggrMetric().setValue(String.valueOf(partition), value);
        this.allTopicsStats().remoteLogSizeBytesAggrMetric().setValue(topic, topicMetric.remoteLogSizeBytes());
    }

    public void removeRemoteLogSizeBytes(String topic, int partition) {
        BrokerTopicMetrics topicMetric = this.topicStats(topic);
        topicMetric.remoteLogSizeBytesAggrMetric().removeKey(String.valueOf(partition));
        this.allTopicsStats().remoteLogSizeBytesAggrMetric().setValue(topic, topicMetric.remoteLogSizeBytes());
    }

    public void removeBrokerLevelRemoteLogSizeBytes(String topic) {
        this.allTopicsStats().remoteLogSizeBytesAggrMetric().removeKey(topic);
    }

    public void close() {
        this.allTopicsStats().close();
        this.stats().values().foreach((Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> "Broker and topic stats closed");
    }

    public BrokerTopicStats(Optional<KafkaConfig> configOpt) {
        this.configOpt = configOpt;
        this.valueFactory = (Function1 & Serializable)k -> new BrokerTopicMetrics((Option<String>)new Some(k), $this.configOpt);
        this.stats = new Pool(new Some(this.valueFactory()));
        this.allTopicsStats = new BrokerTopicMetrics((Option<String>)None$.MODULE$, configOpt);
    }
}

