/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.geoapi.filter.Literal;
import org.apache.sis.internal.geoapi.filter.ValueReference;

public interface FeatureExpression<R, V>
extends Expression<R, V> {
    default public Class<?> getValueClass() {
        return Object.class;
    }

    public PropertyTypeBuilder expectedType(DefaultFeatureType var1, FeatureTypeBuilder var2);

    public static FeatureExpression<?, ?> castOrCopy(Expression<?, ?> expression) {
        Expression<Object, Object> expression2;
        if (expression instanceof FeatureExpression) {
            return (FeatureExpression)expression;
        }
        if (expression instanceof Literal) {
            expression2 = Optimization.literal(((Literal)expression).getValue());
        } else if (expression instanceof ValueReference) {
            String string = ((ValueReference)expression).getXPath();
            expression2 = DefaultFilterFactory.forFeatures().property(string);
        } else {
            return null;
        }
        return (FeatureExpression)expression2;
    }
}

