/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.reflect.Array;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.SourceAlignedImage;
import org.apache.sis.image.Transferer;
import org.apache.sis.internal.coverage.j2d.ImageLayout;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileOpExecutor;
import org.apache.sis.internal.coverage.j2d.WriteSupport;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class BandedSampleConverter
extends ComputedImage {
    private static final String[] ADDED_PROPERTIES = new String[]{"org.apache.sis.SampleResolution"};
    private final MathTransform1D[] converters;
    private final ColorModel colorModel;
    private final double[] sampleResolutions;

    private BandedSampleConverter(RenderedImage renderedImage, BandedSampleModel bandedSampleModel, ColorModel colorModel, NumberRange<?>[] numberRangeArray, MathTransform1D[] mathTransform1DArray) {
        super(bandedSampleModel, renderedImage);
        this.colorModel = colorModel;
        this.converters = mathTransform1DArray;
        boolean bl = false;
        double[] dArray = new double[mathTransform1DArray.length];
        Object object = renderedImage.getProperty("org.apache.sis.SampleResolution");
        int n = object != null && Numbers.isNumber(object.getClass().getComponentType()) ? Array.getLength(object) : 0;
        for (int i = 0; i < dArray.length; ++i) {
            Number number;
            double d;
            Object object2;
            double d2 = Double.NaN;
            if (numberRangeArray != null && i < numberRangeArray.length && (object2 = numberRangeArray[i]) != null) {
                d2 = ((NumberRange)object2).getMedian();
            }
            if (!Double.isFinite(d2)) {
                object2 = renderedImage.getSampleModel();
                d2 = ImageUtilities.isUnsignedType((SampleModel)object2) ? Math.scalb(0.5, ((SampleModel)object2).getSampleSize(i)) : 0.0;
            }
            object2 = mathTransform1DArray[i];
            try {
                d = object2.derivative(d2);
                if (!Double.isFinite(d)) {
                    d = object2.derivative(1.0);
                }
            }
            catch (TransformException transformException) {
                d = Double.NaN;
            }
            if (i < n && (number = (Number)Array.get(object, i)) != null) {
                d *= number instanceof Float ? DecimalFunctions.floatToDouble(number.floatValue()) : number.doubleValue();
            }
            dArray[i] = d;
            bl |= Double.isFinite(d);
        }
        this.sampleResolutions = (double[])(bl ? dArray : null);
    }

    static BandedSampleConverter create(RenderedImage renderedImage, ImageLayout imageLayout, NumberRange<?>[] numberRangeArray, MathTransform1D[] mathTransform1DArray, int n, ColorModel colorModel) {
        if (renderedImage instanceof RecoloredImage) {
            renderedImage = ((RecoloredImage)renderedImage).source;
        }
        int n2 = mathTransform1DArray.length;
        BandedSampleModel bandedSampleModel = imageLayout.createBandedSampleModel(n, n2, renderedImage, null);
        if (renderedImage instanceof WritableRenderedImage) {
            try {
                MathTransform1D[] mathTransform1DArray2 = new MathTransform1D[n2];
                for (int i = 0; i < n2; ++i) {
                    mathTransform1DArray2[i] = mathTransform1DArray[i].inverse();
                }
                return new Writable((WritableRenderedImage)renderedImage, bandedSampleModel, colorModel, numberRangeArray, mathTransform1DArray, mathTransform1DArray2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Logging.recoverableException(Logging.getLogger("org.apache.sis.raster"), ImageProcessor.class, "convert", noninvertibleTransformException);
            }
        }
        return new BandedSampleConverter(renderedImage, bandedSampleModel, colorModel, numberRangeArray, mathTransform1DArray);
    }

    @Override
    public Object getProperty(String string) {
        if (SourceAlignedImage.POSITIONAL_PROPERTIES.contains(string)) {
            if ("org.apache.sis.SampleResolution".equals(string)) {
                if (this.sampleResolutions != null) {
                    return this.sampleResolutions.clone();
                }
            } else {
                return this.getSource().getProperty(string);
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String[] getPropertyNames() {
        return SourceAlignedImage.filterPropertyNames(this.getSource().getPropertyNames(), SourceAlignedImage.POSITIONAL_PROPERTIES, (String[])(this.sampleResolutions != null ? ADDED_PROPERTIES : null));
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public int getWidth() {
        return this.getSource().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getSource().getHeight();
    }

    @Override
    public int getMinX() {
        return this.getSource().getMinX();
    }

    @Override
    public int getMinY() {
        return this.getSource().getMinY();
    }

    @Override
    public int getMinTileX() {
        return this.getSource().getMinTileX();
    }

    @Override
    public int getMinTileY() {
        return this.getSource().getMinTileY();
    }

    @Override
    protected Raster computeTile(int n, int n2, WritableRaster writableRaster) throws TransformException {
        if (writableRaster == null) {
            writableRaster = this.createTile(n, n2);
        }
        Transferer.create(this.getSource(), writableRaster).compute(this.converters);
        return writableRaster;
    }

    @Override
    protected Disposable prefetch(Rectangle rectangle) {
        RenderedImage renderedImage = this.getSource();
        if (renderedImage instanceof PlanarImage) {
            Rectangle rectangle2 = ImageUtilities.tilesToPixels(this, rectangle);
            ImageUtilities.clipBounds(renderedImage, rectangle2);
            return ((PlanarImage)renderedImage).prefetch(ImageUtilities.pixelsToTiles(renderedImage, rectangle2));
        }
        return super.prefetch(rectangle);
    }

    private static final class Writable
    extends BandedSampleConverter
    implements WritableRenderedImage {
        private final MathTransform1D[] inverses;
        private volatile TileObserver[] observers;

        Writable(WritableRenderedImage writableRenderedImage, BandedSampleModel bandedSampleModel, ColorModel colorModel, NumberRange<?>[] numberRangeArray, MathTransform1D[] mathTransform1DArray, MathTransform1D[] mathTransform1DArray2) {
            super(writableRenderedImage, bandedSampleModel, colorModel, numberRangeArray, mathTransform1DArray);
            this.inverses = mathTransform1DArray2;
        }

        @Override
        public synchronized void addTileObserver(TileObserver tileObserver) {
            this.observers = WriteSupport.addTileObserver(this.observers, tileObserver);
        }

        @Override
        public synchronized void removeTileObserver(TileObserver tileObserver) {
            this.observers = WriteSupport.removeTileObserver(this.observers, tileObserver);
        }

        @Override
        protected boolean markTileWritable(int n, int n2, boolean bl) {
            boolean bl2 = super.markTileWritable(n, n2, bl);
            if (bl2) {
                WriteSupport.fireTileUpdate(this.observers, this, n, n2, bl);
            }
            return bl2;
        }

        @Override
        public WritableRaster getWritableTile(int n, int n2) {
            WritableRaster writableRaster = (WritableRaster)this.getTile(n, n2);
            this.markTileWritable(n, n2, true);
            return writableRaster;
        }

        @Override
        public void releaseWritableTile(int n, int n2) {
            if (this.markTileWritable(n, n2, false)) {
                this.setData(this.getTile(n, n2));
            }
        }

        @Override
        public void setData(final Raster raster) {
            final Rectangle rectangle = raster.getBounds();
            WritableRenderedImage writableRenderedImage = (WritableRenderedImage)this.getSource();
            ImageUtilities.clipBounds(writableRenderedImage, rectangle);
            if (!rectangle.isEmpty()) {
                TileOpExecutor tileOpExecutor = new TileOpExecutor(writableRenderedImage, rectangle){

                    @Override
                    protected void writeTo(WritableRaster writableRaster) throws TransformException {
                        Rectangle rectangle2 = writableRaster.getBounds().intersection(rectangle);
                        Transferer.create(raster, writableRaster, rectangle2).compute(inverses);
                    }
                };
                tileOpExecutor.writeTo(writableRenderedImage);
                this.markDirtyTiles(tileOpExecutor.getTileIndices());
            }
        }
    }
}

