/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.util.format.FormatElement;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum FormatElementEnum implements FormatElement
{
    CC("cc", "century (2 digits) (the twenty-first century starts on 2001-01-01)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%2d", calendar.get(1) / 100 + 1));
        }
    }
    ,
    D("F", "The weekday (Monday as the first day of the week) as a decimal number (1-7)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(7)));
        }
    }
    ,
    DAY("EEEE", "The full weekday name, in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.FULL).toUpperCase(Locale.ROOT));
        }
    }
    ,
    Day("EEEE", "The full weekday name, capitalized"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.FULL));
        }
    }
    ,
    day("EEEE", "The full weekday name, in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.FULL).toLowerCase(Locale.ROOT));
        }
    }
    ,
    DD("dd", "The day of the month as a decimal number (01-31)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(5)));
        }
    }
    ,
    DDD("D", "The day of the year as a decimal number (001-366)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%03d", calendar.get(6)));
        }
    }
    ,
    DY("EEE", "The abbreviated weekday name, in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.SHORT).toUpperCase(Locale.ROOT));
        }
    }
    ,
    Dy("EEE", "The abbreviated weekday name, capitalized"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.SHORT));
        }
    }
    ,
    dy("EEE", "The abbreviated weekday name, in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.getDayFromDate(date, TextStyle.SHORT).toLowerCase(Locale.ROOT));
        }
    }
    ,
    E("d", "The day of the month as a decimal number (1-31); single digits are left-padded with space."){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%2d", calendar.get(5)));
        }
    }
    ,
    FF1("S", "Fractional seconds to 1 digit"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sssFormat.format(date).charAt(0));
        }
    }
    ,
    FF2("S", "Fractional seconds to 2 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sssFormat.format(date), 0, 2);
        }
    }
    ,
    FF3("S", "Fractional seconds to 3 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.sssFormat.format(date));
        }
    }
    ,
    FF4("S", "Fractional seconds to 4 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad((String)work.sssFormat.format(date), (int)4, (String)"0"));
        }
    }
    ,
    FF5("S", "Fractional seconds to 5 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad((String)work.sssFormat.format(date), (int)5, (String)"0"));
        }
    }
    ,
    FF6("S", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad((String)work.sssFormat.format(date), (int)6, (String)"0"));
        }
    }
    ,
    FF7("S", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad((String)work.sssFormat.format(date), (int)7, (String)"0"));
        }
    }
    ,
    FF8("S", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad((String)work.sssFormat.format(date), (int)8, (String)"0"));
        }
    }
    ,
    FF9("S", "Fractional seconds to 6 digits"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(StringUtils.rightPad((String)work.sssFormat.format(date), (int)9, (String)"0"));
        }
    }
    ,
    HH12("h", "The hour (12-hour clock) as a decimal number (01-12)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            int hour = calendar.get(10);
            sb.append(String.format(Locale.ROOT, "%02d", hour == 0 ? 12 : hour));
        }
    }
    ,
    HH24("H", "The hour (24-hour clock) as a decimal number (00-23)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(11)));
        }
    }
    ,
    IW("w", "The ISO 8601 week number of the year (Monday as the first day of the week) as a decimal number (01-53)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            calendar.setFirstDayOfWeek(2);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(3)));
        }
    }
    ,
    MI("m", "The minute as a decimal number (00-59)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(12)));
        }
    }
    ,
    MM("MM", "The month as a decimal number (01-12)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(2) + 1));
        }
    }
    ,
    MON("MMM", "The abbreviated month name, in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmFormat.format(date).toUpperCase(Locale.ROOT));
        }
    }
    ,
    Mon("MMM", "The abbreviated month name, capitalized"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmFormat.format(date));
        }
    }
    ,
    mon("MMM", "The abbreviated month name, in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmFormat.format(date).toLowerCase(Locale.ROOT));
        }
    }
    ,
    MONTH("MMMM", "The full month name (English), in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmmFormat.format(date).toUpperCase(Locale.ROOT));
        }
    }
    ,
    Month("MMMM", "The full month name (English), capitalized"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmmFormat.format(date));
        }
    }
    ,
    month("MMMM", "The full month name (English), in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.mmmmFormat.format(date).toLowerCase(Locale.ROOT));
        }
    }
    ,
    PM("a", "Meridian indicator without periods"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            String meridian = calendar.get(11) < 12 ? "AM" : "PM";
            sb.append(meridian);
        }
    }
    ,
    Q("", "The quarter as a decimal number (1-4)"){

        @Override
        public void toPattern(StringBuilder sb) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Cannot convert 'Q' FormatElement to Java pattern");
        }

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(2) / 3 + 1));
        }
    }
    ,
    AMPM("", "The time as Meridian Indicator in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(calendar.get(9) == 0 ? "AM" : "PM");
        }
    }
    ,
    AM_PM("", "The time as Meridian Indicator in uppercase with dot"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(calendar.get(9) == 0 ? "A.M." : "P.M.");
        }
    }
    ,
    ampm("", "The time as Meridian Indicator in lowercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(calendar.get(9) == 0 ? "am" : "pm");
        }
    }
    ,
    am_pm("", "The time as Meridian Indicator in uppercase"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(calendar.get(9) == 0 ? "a.m." : "p.m.");
        }
    }
    ,
    MS("SSS", "The millisecond as a decimal number (000-999)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%03d", calendar.get(14)));
        }
    }
    ,
    SS("s", "The second as a decimal number (00-60)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(13)));
        }
    }
    ,
    SSSSS("s", "The seconds of the day (00000-86400)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            long timeInMillis = calendar.getTimeInMillis();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            long dayStartInMillis = calendar.getTimeInMillis();
            long secondsPassed = (timeInMillis - dayStartInMillis) / 1000L;
            sb.append(String.format(Locale.ROOT, "%05d", secondsPassed));
        }
    }
    ,
    TZR("z", "The time zone name"){

        @Override
        public void format(StringBuilder sb, Date date) {
        }
    }
    ,
    W("W", "The week number of the month (Sunday as the first day of the week) as a decimal number (1-5)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(4)));
        }
    }
    ,
    WW("w", "The week number of the year (Sunday as the first day of the week) as a decimal number (00-53)"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            calendar.setFirstDayOfWeek(1);
            sb.append(String.format(Locale.ROOT, "%02d", calendar.get(3)));
        }
    }
    ,
    Y("y", "Last digit of year"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            String formattedYear = work.yyFormat.format(date);
            sb.append(formattedYear.substring(formattedYear.length() - 1));
        }
    }
    ,
    YY("yy", "Last 2 digits of year"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.yyFormat.format(date));
        }
    }
    ,
    YYY("yyy", "Last 3 digits of year"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            String formattedYear = work.yyyyFormat.format(date);
            sb.append(formattedYear.substring(formattedYear.length() - 3));
        }
    }
    ,
    YYYY("yyyy", "The year with century as a decimal number"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Work work = Work.get();
            sb.append(work.yyyyFormat.format(date));
        }
    }
    ,
    pctY("yyyy", "The year with century as a decimal number"){

        @Override
        public void format(StringBuilder sb, Date date) {
            Calendar calendar = Work.get().calendar;
            calendar.setTime(date);
            sb.append(String.format(Locale.ROOT, "%d", calendar.get(1)));
        }
    };

    private final String description;
    final String javaFmt;

    private FormatElementEnum(String javaFmt, String description) {
        this.javaFmt = Objects.requireNonNull(javaFmt, "javaFmt");
        this.description = Objects.requireNonNull(description, "description");
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void toPattern(StringBuilder sb) {
        sb.append(this.javaFmt);
    }

    static class Work {
        private static final ThreadLocal<@Nullable Work> THREAD_WORK = ThreadLocal.withInitial(Work::new);
        final Calendar calendar = Calendar.getInstance(DateTimeUtils.DEFAULT_ZONE, Locale.ROOT);
        final DateFormat mmmFormat;
        final DateFormat mmmmFormat;
        final DateFormat sssFormat;
        final DateFormat yyFormat;
        final DateFormat yyyyFormat;

        Work() {
            this.mmmFormat = new SimpleDateFormat(FormatElementEnum.MON.javaFmt, Locale.US);
            this.mmmmFormat = new SimpleDateFormat(FormatElementEnum.MONTH.javaFmt, Locale.US);
            this.sssFormat = new SimpleDateFormat(FormatElementEnum.FF3.javaFmt, Locale.ROOT);
            this.yyFormat = new SimpleDateFormat(FormatElementEnum.YY.javaFmt, Locale.ROOT);
            this.yyyyFormat = new SimpleDateFormat(FormatElementEnum.YYYY.javaFmt, Locale.ROOT);
        }

        static Work get() {
            return (Work)Nullness.castNonNull((Object)THREAD_WORK.get());
        }

        private String getDayFromDate(Date date, TextStyle style) {
            this.calendar.setTime(date);
            LocalDate ld = LocalDate.of(this.calendar.get(1), this.calendar.get(2) + 1, this.calendar.get(5));
            return ld.getDayOfWeek().getDisplayName(style, Locale.ENGLISH);
        }
    }
}

