/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.attrs;

import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.carrot2.attrs.AcceptingVisitor;
import org.carrot2.attrs.AttrBoolean;
import org.carrot2.attrs.AttrDouble;
import org.carrot2.attrs.AttrEnum;
import org.carrot2.attrs.AttrInteger;
import org.carrot2.attrs.AttrObject;
import org.carrot2.attrs.AttrObjectArray;
import org.carrot2.attrs.AttrString;
import org.carrot2.attrs.AttrStringArray;
import org.carrot2.attrs.AttrVisitor;

public final class AttrGroup {
    private Map<String, Consumer<AttrVisitor>> attrs = new TreeMap<String, Consumer<AttrVisitor>>();

    public <T extends AcceptingVisitor> AttrObject<T> register(String key, AttrObject<T> attr) {
        this.checkNewKey(key);
        this.attrs.put(key, visitor -> visitor.visit(key, attr));
        return attr;
    }

    public <T extends AcceptingVisitor> AttrObjectArray<T> register(String key, AttrObjectArray<T> attr) {
        this.checkNewKey(key);
        this.attrs.put(key, visitor -> visitor.visit(key, attr));
        return attr;
    }

    public <T extends Enum<T>> AttrEnum<T> register(String key, AttrEnum<T> attr) {
        this.checkNewKey(key);
        this.attrs.put(key, visitor -> visitor.visit(key, attr));
        return attr;
    }

    public AttrInteger register(String key, AttrInteger attr) {
        this.checkNewKey(key);
        this.attrs.put(key, visitor -> visitor.visit(key, attr));
        return attr;
    }

    public AttrBoolean register(String key, AttrBoolean attr) {
        this.checkNewKey(key);
        this.attrs.put(key, visitor -> visitor.visit(key, attr));
        return attr;
    }

    public AttrDouble register(String key, AttrDouble attr) {
        this.checkNewKey(key);
        this.attrs.put(key, visitor -> visitor.visit(key, attr));
        return attr;
    }

    public AttrString register(String key, AttrString attr) {
        this.checkNewKey(key);
        this.attrs.put(key, visitor -> visitor.visit(key, attr));
        return attr;
    }

    public AttrStringArray register(String key, AttrStringArray attr) {
        this.checkNewKey(key);
        this.attrs.put(key, visitor -> visitor.visit(key, attr));
        return attr;
    }

    private void checkNewKey(String key) {
        if (this.attrs.containsKey(key)) {
            throw new RuntimeException(String.format(Locale.ROOT, "An attribute with key '%s' already exists.", key));
        }
    }

    public void visit(AttrVisitor visitor) {
        this.attrs.values().forEach(c -> c.accept(visitor));
    }
}

