/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.migration;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.controller.metrics.QuorumControllerMetrics;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LoaderManifestType;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.migration.BufferingBatchConsumer;
import org.apache.kafka.metadata.migration.KRaftMigrationOperation;
import org.apache.kafka.metadata.migration.KRaftMigrationOperationConsumer;
import org.apache.kafka.metadata.migration.KRaftMigrationZkWriter;
import org.apache.kafka.metadata.migration.LegacyPropagator;
import org.apache.kafka.metadata.migration.MigrationClient;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.MigrationDriverState;
import org.apache.kafka.metadata.migration.MigrationManifest;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.kafka.metadata.migration.ZkMigrationState;
import org.apache.kafka.metadata.migration.ZkRecordConsumer;
import org.apache.kafka.metadata.util.RecordRedactor;
import org.apache.kafka.queue.EventQueue;
import org.apache.kafka.queue.KafkaEventQueue;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.Deadline;
import org.apache.kafka.server.util.FutureUtils;
import org.slf4j.Logger;

public class KRaftMigrationDriver
implements MetadataPublisher {
    private static final Consumer<Throwable> NO_OP_HANDLER = ex -> {};
    static final int METADATA_COMMIT_MAX_WAIT_MS = 300000;
    private final Time time;
    private final Logger log;
    private final int nodeId;
    private final MigrationClient zkMigrationClient;
    private final KRaftMigrationZkWriter zkMetadataWriter;
    private final LegacyPropagator propagator;
    private final ZkRecordConsumer zkRecordConsumer;
    private final KafkaEventQueue eventQueue;
    private final PollTimeSupplier pollTimeSupplier;
    private final QuorumControllerMetrics controllerMetrics;
    private final FaultHandler faultHandler;
    private final QuorumFeatures quorumFeatures;
    private final RecordRedactor recordRedactor;
    private final Consumer<MetadataPublisher> initialZkLoadHandler;
    private final int minBatchSize;
    private volatile MigrationDriverState migrationState;
    private volatile ZkMigrationLeadershipState migrationLeadershipState;
    private volatile MetadataImage image;
    private volatile boolean firstPublish;

    KRaftMigrationDriver(int nodeId, ZkRecordConsumer zkRecordConsumer, MigrationClient zkMigrationClient, LegacyPropagator propagator, Consumer<MetadataPublisher> initialZkLoadHandler, FaultHandler faultHandler, QuorumFeatures quorumFeatures, KafkaConfigSchema configSchema, QuorumControllerMetrics controllerMetrics, int minBatchSize, Time time) {
        Logger log;
        this.nodeId = nodeId;
        this.zkRecordConsumer = zkRecordConsumer;
        this.zkMigrationClient = zkMigrationClient;
        this.propagator = propagator;
        this.time = time;
        LogContext logContext = new LogContext("[KRaftMigrationDriver id=" + nodeId + "] ");
        this.controllerMetrics = controllerMetrics;
        this.log = log = logContext.logger(KRaftMigrationDriver.class);
        this.migrationState = MigrationDriverState.UNINITIALIZED;
        this.migrationLeadershipState = ZkMigrationLeadershipState.EMPTY;
        this.eventQueue = new KafkaEventQueue(Time.SYSTEM, logContext, "controller-" + nodeId + "-migration-driver-");
        this.pollTimeSupplier = new PollTimeSupplier();
        this.image = MetadataImage.EMPTY;
        this.firstPublish = false;
        this.initialZkLoadHandler = initialZkLoadHandler;
        this.faultHandler = faultHandler;
        this.quorumFeatures = quorumFeatures;
        this.zkMetadataWriter = new KRaftMigrationZkWriter(zkMigrationClient, arg_0 -> ((Logger)log).error(arg_0));
        this.recordRedactor = new RecordRedactor(configSchema);
        this.minBatchSize = minBatchSize;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void start() {
        this.eventQueue.prepend((EventQueue.Event)new PollEvent());
    }

    public CompletableFuture<MigrationDriverState> migrationState() {
        CompletableFuture<MigrationDriverState> stateFuture = new CompletableFuture<MigrationDriverState>();
        this.eventQueue.append(() -> stateFuture.complete(this.migrationState));
        return stateFuture;
    }

    private boolean isControllerQuorumReadyForMigration() {
        Optional<String> notReadyMsg = this.quorumFeatures.reasonAllControllersZkMigrationNotReady(this.image.features().metadataVersion(), this.image.cluster().controllers());
        if (notReadyMsg.isPresent()) {
            this.log.warn("Still waiting for all controller nodes ready to begin the migration. Not ready due to:" + notReadyMsg.get());
            return false;
        }
        return true;
    }

    private boolean imageDoesNotContainAllBrokers(MetadataImage image, Set<Integer> brokerIds) {
        for (BrokerRegistration broker : image.cluster().brokers().values()) {
            if (!broker.isMigratingZkBroker()) continue;
            brokerIds.remove(broker.id());
        }
        return !brokerIds.isEmpty();
    }

    private boolean areZkBrokersReadyForMigration() {
        if (!this.firstPublish) {
            this.log.info("Waiting for initial metadata publish before checking if Zk brokers are registered.");
            return false;
        }
        if (this.image.cluster().isEmpty()) {
            this.log.info("No brokers are known to KRaft, waiting for brokers to register.");
            return false;
        }
        Set<Integer> zkBrokerRegistrations = this.zkMigrationClient.readBrokerIds();
        if (zkBrokerRegistrations.isEmpty()) {
            this.log.info("No brokers are registered in ZK, waiting for brokers to register.");
            return false;
        }
        if (this.imageDoesNotContainAllBrokers(this.image, zkBrokerRegistrations)) {
            this.log.info("Still waiting for ZK brokers {} to register with KRaft.", zkBrokerRegistrations);
            return false;
        }
        HashSet<Integer> zkBrokersWithAssignments = new HashSet<Integer>();
        this.zkMigrationClient.topicClient().iterateTopics(EnumSet.of(TopicMigrationClient.TopicVisitorInterest.TOPICS), (topicName, topicId, assignments) -> assignments.values().forEach(zkBrokersWithAssignments::addAll));
        if (this.imageDoesNotContainAllBrokers(this.image, zkBrokersWithAssignments)) {
            this.log.info("Still waiting for ZK brokers {} found in metadata to register with KRaft.", zkBrokersWithAssignments);
            return false;
        }
        return true;
    }

    private void applyMigrationOperation(String name, KRaftMigrationOperation migrationOp) {
        ZkMigrationLeadershipState beforeState = this.migrationLeadershipState;
        ZkMigrationLeadershipState afterState = migrationOp.apply(beforeState);
        if (afterState.loggableChangeSinceState(beforeState)) {
            this.log.info("{}. Transitioned migration state from {} to {}", new Object[]{name, beforeState, afterState});
        } else if (afterState.equals(beforeState)) {
            this.log.trace("{}. Kept migration state as {}", (Object)name, (Object)afterState);
        } else {
            this.log.trace("{}. Transitioned migration state from {} to {}", new Object[]{name, beforeState, afterState});
        }
        this.migrationLeadershipState = afterState;
    }

    private boolean isValidStateChange(MigrationDriverState newState) {
        if (this.migrationState == newState) {
            return true;
        }
        if (newState == MigrationDriverState.UNINITIALIZED) {
            return false;
        }
        switch (this.migrationState) {
            case UNINITIALIZED: 
            case DUAL_WRITE: {
                return newState == MigrationDriverState.INACTIVE;
            }
            case INACTIVE: {
                return newState == MigrationDriverState.WAIT_FOR_CONTROLLER_QUORUM;
            }
            case WAIT_FOR_CONTROLLER_QUORUM: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.BECOME_CONTROLLER || newState == MigrationDriverState.WAIT_FOR_BROKERS;
            }
            case WAIT_FOR_BROKERS: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.BECOME_CONTROLLER;
            }
            case BECOME_CONTROLLER: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.ZK_MIGRATION || newState == MigrationDriverState.SYNC_KRAFT_TO_ZK;
            }
            case ZK_MIGRATION: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.SYNC_KRAFT_TO_ZK;
            }
            case SYNC_KRAFT_TO_ZK: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.KRAFT_CONTROLLER_TO_BROKER_COMM;
            }
            case KRAFT_CONTROLLER_TO_BROKER_COMM: {
                return newState == MigrationDriverState.INACTIVE || newState == MigrationDriverState.DUAL_WRITE;
            }
        }
        this.log.error("Migration driver trying to transition from an unknown state {}", (Object)this.migrationState);
        return false;
    }

    private boolean checkDriverState(MigrationDriverState expectedState, MigrationEvent migrationEvent) {
        if (this.migrationState.equals((Object)expectedState)) {
            return true;
        }
        this.log.info("Expected driver state {} but found {}. Not running this event {}.", new Object[]{expectedState, this.migrationState, migrationEvent.getClass().getSimpleName()});
        return false;
    }

    void transitionTo(MigrationDriverState newState) {
        if (!this.isValidStateChange(newState)) {
            throw new IllegalStateException(String.format("Invalid transition in migration driver from %s to %s", new Object[]{this.migrationState, newState}));
        }
        if (newState != this.migrationState) {
            this.log.info("{} transitioning from {} to {} state", new Object[]{this.nodeId, this.migrationState, newState});
            this.pollTimeSupplier.reset();
            this.wakeup();
        } else {
            this.log.trace("{} transitioning from {} to {} state", new Object[]{this.nodeId, this.migrationState, newState});
        }
        this.migrationState = newState;
    }

    private void wakeup() {
        this.eventQueue.append((EventQueue.Event)new PollEvent());
    }

    @Override
    public String name() {
        return "KRaftMigrationDriver";
    }

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        this.eventQueue.append((EventQueue.Event)new KRaftLeaderEvent(newLeaderAndEpoch));
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.enqueueMetadataChangeEvent(delta, newImage, manifest.provenance(), manifest.type() == LoaderManifestType.SNAPSHOT, NO_OP_HANDLER);
    }

    @Override
    public void close() throws InterruptedException {
        this.eventQueue.beginShutdown("KRaftMigrationDriver#shutdown");
        this.log.debug("Shutting down KRaftMigrationDriver");
        this.eventQueue.close();
    }

    void enqueueMetadataChangeEvent(MetadataDelta delta, MetadataImage newImage, MetadataProvenance provenance, boolean isSnapshot, Consumer<Throwable> completionHandler) {
        MetadataChangeEvent metadataChangeEvent = new MetadataChangeEvent(delta, newImage, provenance, isSnapshot, completionHandler);
        this.eventQueue.append((EventQueue.Event)metadataChangeEvent);
    }

    private BufferingBatchConsumer<ApiMessageAndVersion> buildMigrationBatchConsumer(MigrationManifest.Builder manifestBuilder) {
        return new BufferingBatchConsumer<ApiMessageAndVersion>(batch -> {
            try {
                if (this.log.isTraceEnabled()) {
                    batch.forEach(apiMessageAndVersion -> this.log.trace(this.recordRedactor.toLoggableString(apiMessageAndVersion.message())));
                }
                CompletableFuture<?> future = this.zkRecordConsumer.acceptBatch((List<ApiMessageAndVersion>)batch);
                long batchStart = this.time.nanoseconds();
                FutureUtils.waitWithLogging((Logger)this.log, (String)"", (String)("the metadata layer to commit " + batch.size() + " migration records"), future, (Deadline)Deadline.fromDelay((Time)this.time, (long)300000L, (TimeUnit)TimeUnit.MILLISECONDS), (Time)this.time);
                long batchEnd = this.time.nanoseconds();
                manifestBuilder.acceptBatch((List<ApiMessageAndVersion>)batch, batchEnd - batchStart);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, this.minBatchSize);
    }

    static KRaftMigrationOperationConsumer countingOperationConsumer(Map<String, Integer> dualWriteCounts, BiConsumer<String, KRaftMigrationOperation> operationConsumer) {
        return (opType, logMsg, operation) -> {
            dualWriteCounts.compute(opType, (key, value) -> {
                if (value == null) {
                    return 1;
                }
                return value + 1;
            });
            operationConsumer.accept(logMsg, operation);
        };
    }

    public static class Builder {
        private Integer nodeId;
        private ZkRecordConsumer zkRecordConsumer;
        private MigrationClient zkMigrationClient;
        private LegacyPropagator propagator;
        private Consumer<MetadataPublisher> initialZkLoadHandler;
        private FaultHandler faultHandler;
        private QuorumFeatures quorumFeatures;
        private KafkaConfigSchema configSchema;
        private QuorumControllerMetrics controllerMetrics;
        private Integer minBatchSize;
        private Time time;

        public Builder setNodeId(int nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder setZkRecordConsumer(ZkRecordConsumer zkRecordConsumer) {
            this.zkRecordConsumer = zkRecordConsumer;
            return this;
        }

        public Builder setZkMigrationClient(MigrationClient zkMigrationClient) {
            this.zkMigrationClient = zkMigrationClient;
            return this;
        }

        public Builder setPropagator(LegacyPropagator propagator) {
            this.propagator = propagator;
            return this;
        }

        public Builder setInitialZkLoadHandler(Consumer<MetadataPublisher> initialZkLoadHandler) {
            this.initialZkLoadHandler = initialZkLoadHandler;
            return this;
        }

        public Builder setFaultHandler(FaultHandler faultHandler) {
            this.faultHandler = faultHandler;
            return this;
        }

        public Builder setQuorumFeatures(QuorumFeatures quorumFeatures) {
            this.quorumFeatures = quorumFeatures;
            return this;
        }

        public Builder setConfigSchema(KafkaConfigSchema configSchema) {
            this.configSchema = configSchema;
            return this;
        }

        public Builder setControllerMetrics(QuorumControllerMetrics controllerMetrics) {
            this.controllerMetrics = controllerMetrics;
            return this;
        }

        public Builder setTime(Time time) {
            this.time = time;
            return this;
        }

        public Builder setMinMigrationBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            return this;
        }

        public KRaftMigrationDriver build() {
            if (this.nodeId == null) {
                throw new IllegalStateException("You must specify the node ID of this controller.");
            }
            if (this.zkRecordConsumer == null) {
                throw new IllegalStateException("You must specify the ZkRecordConsumer.");
            }
            if (this.zkMigrationClient == null) {
                throw new IllegalStateException("You must specify the MigrationClient.");
            }
            if (this.propagator == null) {
                throw new IllegalStateException("You must specify the MetadataPropagator.");
            }
            if (this.initialZkLoadHandler == null) {
                throw new IllegalStateException("You must specify the initial ZK load callback.");
            }
            if (this.faultHandler == null) {
                throw new IllegalStateException("You must specify the FaultHandler.");
            }
            if (this.configSchema == null) {
                throw new IllegalStateException("You must specify the KafkaConfigSchema.");
            }
            if (this.controllerMetrics == null) {
                throw new IllegalStateException("You must specify the QuorumControllerMetrics.");
            }
            if (this.time == null) {
                throw new IllegalStateException("You must specify the Time.");
            }
            if (this.minBatchSize == null) {
                this.minBatchSize = 200;
            }
            return new KRaftMigrationDriver(this.nodeId, this.zkRecordConsumer, this.zkMigrationClient, this.propagator, this.initialZkLoadHandler, this.faultHandler, this.quorumFeatures, this.configSchema, this.controllerMetrics, this.minBatchSize, this.time);
        }
    }

    class PollEvent
    extends MigrationEvent {
        PollEvent() {
        }

        public void run() throws Exception {
            switch (KRaftMigrationDriver.this.migrationState) {
                case UNINITIALIZED: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new RecoverMigrationStateFromZKEvent());
                    break;
                }
                case INACTIVE: {
                    break;
                }
                case WAIT_FOR_CONTROLLER_QUORUM: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new WaitForControllerQuorumEvent());
                    break;
                }
                case WAIT_FOR_BROKERS: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new WaitForZkBrokersEvent());
                    break;
                }
                case BECOME_CONTROLLER: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new BecomeZkControllerEvent());
                    break;
                }
                case ZK_MIGRATION: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new MigrateMetadataEvent());
                    break;
                }
                case SYNC_KRAFT_TO_ZK: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new SyncKRaftMetadataEvent());
                    break;
                }
                case KRAFT_CONTROLLER_TO_BROKER_COMM: {
                    KRaftMigrationDriver.this.eventQueue.append((EventQueue.Event)new SendRPCsToBrokersEvent());
                    break;
                }
            }
            long deadline = KRaftMigrationDriver.this.time.nanoseconds() + TimeUnit.NANOSECONDS.convert(KRaftMigrationDriver.this.pollTimeSupplier.nextPollTimeMs(), TimeUnit.MILLISECONDS);
            KRaftMigrationDriver.this.eventQueue.scheduleDeferred("poll", (Function)new EventQueue.DeadlineFunction(deadline), (EventQueue.Event)new PollEvent());
        }
    }

    class RecoverMigrationStateFromZKEvent
    extends MigrationEvent {
        RecoverMigrationStateFromZKEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.UNINITIALIZED, this)) {
                KRaftMigrationDriver.this.applyMigrationOperation("Recovering migration state from ZK", KRaftMigrationDriver.this.zkMigrationClient::getOrCreateMigrationRecoveryState);
                String maybeDone = KRaftMigrationDriver.this.migrationLeadershipState.initialZkMigrationComplete() ? "done" : "not done";
                KRaftMigrationDriver.this.log.info("Initial migration of ZK metadata is {}.", (Object)maybeDone);
                KRaftMigrationDriver.this.initialZkLoadHandler.accept(KRaftMigrationDriver.this);
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
            }
        }
    }

    class SendRPCsToBrokersEvent
    extends MigrationEvent {
        SendRPCsToBrokersEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.KRAFT_CONTROLLER_TO_BROKER_COMM, this)) {
                if (KRaftMigrationDriver.this.image.highestOffsetAndEpoch().compareTo(KRaftMigrationDriver.this.migrationLeadershipState.offsetAndEpoch()) >= 0) {
                    KRaftMigrationDriver.this.log.info("Sending RPCs to broker before moving to dual-write mode using at offset and epoch {}", (Object)KRaftMigrationDriver.this.image.highestOffsetAndEpoch());
                    KRaftMigrationDriver.this.propagator.sendRPCsToBrokersFromMetadataImage(KRaftMigrationDriver.this.image, KRaftMigrationDriver.this.migrationLeadershipState.zkControllerEpoch());
                    KRaftMigrationDriver.this.transitionTo(MigrationDriverState.DUAL_WRITE);
                } else {
                    KRaftMigrationDriver.this.log.info("Not sending metadata RPCs with current metadata image since does not contain the offset that was last written to ZK during the migration. Image offset {} is less than migration leadership state offset {}", (Object)KRaftMigrationDriver.this.image.highestOffsetAndEpoch(), (Object)KRaftMigrationDriver.this.migrationLeadershipState.offsetAndEpoch());
                }
            }
        }
    }

    class SyncKRaftMetadataEvent
    extends MigrationEvent {
        SyncKRaftMetadataEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.SYNC_KRAFT_TO_ZK, this)) {
                if (KRaftMigrationDriver.this.image.highestOffsetAndEpoch().compareTo(KRaftMigrationDriver.this.migrationLeadershipState.offsetAndEpoch()) < 0) {
                    KRaftMigrationDriver.this.log.info("Ignoring image {} which does not contain a superset of the metadata in ZK. Staying in SYNC_KRAFT_TO_ZK until a newer image is loaded", (Object)KRaftMigrationDriver.this.image.provenance());
                    return;
                }
                KRaftMigrationDriver.this.log.info("Performing a full metadata sync from KRaft to ZK.");
                TreeMap<String, Integer> dualWriteCounts = new TreeMap<String, Integer>();
                long startTime = KRaftMigrationDriver.this.time.nanoseconds();
                KRaftMigrationDriver.this.zkMetadataWriter.handleSnapshot(KRaftMigrationDriver.this.image, KRaftMigrationDriver.countingOperationConsumer(dualWriteCounts, (x$0, x$1) -> KRaftMigrationDriver.this.applyMigrationOperation(x$0, x$1)));
                long endTime = KRaftMigrationDriver.this.time.nanoseconds();
                KRaftMigrationDriver.this.controllerMetrics.updateZkWriteSnapshotTimeMs(TimeUnit.NANOSECONDS.toMillis(startTime - endTime));
                KRaftMigrationDriver.this.log.info("Made the following ZK writes when reconciling with KRaft state: {}", dualWriteCounts);
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.KRAFT_CONTROLLER_TO_BROKER_COMM);
            }
        }
    }

    class MigrateMetadataEvent
    extends MigrationEvent {
        MigrateMetadataEvent() {
        }

        public void run() throws Exception {
            if (!KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.ZK_MIGRATION, this)) {
                return;
            }
            HashSet brokersInMetadata = new HashSet();
            KRaftMigrationDriver.this.log.info("Starting ZK migration");
            MigrationManifest.Builder manifestBuilder = MigrationManifest.newBuilder(KRaftMigrationDriver.this.time);
            try {
                FutureUtils.waitWithLogging((Logger)KRaftMigrationDriver.this.log, (String)"", (String)"the metadata layer to begin the migration transaction", KRaftMigrationDriver.this.zkRecordConsumer.beginMigration(), (Deadline)Deadline.fromDelay((Time)KRaftMigrationDriver.this.time, (long)300000L, (TimeUnit)TimeUnit.MILLISECONDS), (Time)KRaftMigrationDriver.this.time);
            }
            catch (Throwable t) {
                KRaftMigrationDriver.this.log.error("Could not start the migration", t);
                super.handleException(t);
            }
            try {
                BufferingBatchConsumer migrationBatchConsumer = KRaftMigrationDriver.this.buildMigrationBatchConsumer(manifestBuilder);
                KRaftMigrationDriver.this.zkMigrationClient.readAllMetadata(migrationBatchConsumer, brokersInMetadata::add);
                migrationBatchConsumer.flush();
                CompletableFuture<OffsetAndEpoch> completeMigrationFuture = KRaftMigrationDriver.this.zkRecordConsumer.completeMigration();
                OffsetAndEpoch offsetAndEpochAfterMigration = (OffsetAndEpoch)FutureUtils.waitWithLogging((Logger)KRaftMigrationDriver.this.log, (String)"", (String)"the metadata layer to complete the migration", completeMigrationFuture, (Deadline)Deadline.fromDelay((Time)KRaftMigrationDriver.this.time, (long)300000L, (TimeUnit)TimeUnit.MILLISECONDS), (Time)KRaftMigrationDriver.this.time);
                MigrationManifest manifest = manifestBuilder.build();
                KRaftMigrationDriver.this.log.info("Completed migration of metadata from ZooKeeper to KRaft. {}. The current metadata offset is now {} with an epoch of {}. Saw {} brokers in the migrated metadata {}.", new Object[]{manifest, offsetAndEpochAfterMigration.offset(), offsetAndEpochAfterMigration.epoch(), brokersInMetadata.size(), brokersInMetadata});
                ZkMigrationLeadershipState newState = KRaftMigrationDriver.this.migrationLeadershipState.withKRaftMetadataOffsetAndEpoch(offsetAndEpochAfterMigration.offset(), offsetAndEpochAfterMigration.epoch());
                KRaftMigrationDriver.this.applyMigrationOperation("Finished initial migration of ZK metadata to KRaft", state -> KRaftMigrationDriver.this.zkMigrationClient.setMigrationRecoveryState(newState));
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.SYNC_KRAFT_TO_ZK);
            }
            catch (Throwable t) {
                MigrationManifest partialManifest = manifestBuilder.build();
                KRaftMigrationDriver.this.log.error("Aborting the metadata migration from ZooKeeper to KRaft. {}.", (Object)partialManifest, (Object)t);
                KRaftMigrationDriver.this.zkRecordConsumer.abortMigration();
                super.handleException(t);
            }
        }
    }

    class BecomeZkControllerEvent
    extends MigrationEvent {
        BecomeZkControllerEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.BECOME_CONTROLLER, this)) {
                KRaftMigrationDriver.this.applyMigrationOperation("Claiming ZK controller leadership", KRaftMigrationDriver.this.zkMigrationClient::claimControllerLeadership);
                if (KRaftMigrationDriver.this.migrationLeadershipState.zkControllerEpochZkVersion() == -2) {
                    KRaftMigrationDriver.this.log.info("Unable to claim leadership, will retry until we learn of a different KRaft leader");
                } else if (!KRaftMigrationDriver.this.migrationLeadershipState.initialZkMigrationComplete()) {
                    KRaftMigrationDriver.this.transitionTo(MigrationDriverState.ZK_MIGRATION);
                } else {
                    KRaftMigrationDriver.this.applyMigrationOperation("Re-reading migration state", state -> {
                        ZkMigrationLeadershipState reloadedState = KRaftMigrationDriver.this.zkMigrationClient.getOrCreateMigrationRecoveryState(ZkMigrationLeadershipState.EMPTY);
                        return KRaftMigrationDriver.this.migrationLeadershipState.withMigrationZkVersion(reloadedState.migrationZkVersion()).withKRaftMetadataOffsetAndEpoch(reloadedState.kraftMetadataOffset(), reloadedState.kraftMetadataEpoch());
                    });
                    KRaftMigrationDriver.this.transitionTo(MigrationDriverState.SYNC_KRAFT_TO_ZK);
                }
            }
        }
    }

    class WaitForZkBrokersEvent
    extends MigrationEvent {
        WaitForZkBrokersEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.WAIT_FOR_BROKERS, this) && KRaftMigrationDriver.this.areZkBrokersReadyForMigration()) {
                KRaftMigrationDriver.this.log.info("Zk brokers are registered and ready for migration");
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.BECOME_CONTROLLER);
            }
        }
    }

    class WaitForControllerQuorumEvent
    extends MigrationEvent {
        WaitForControllerQuorumEvent() {
        }

        public void run() throws Exception {
            if (KRaftMigrationDriver.this.checkDriverState(MigrationDriverState.WAIT_FOR_CONTROLLER_QUORUM, this)) {
                if (!KRaftMigrationDriver.this.firstPublish) {
                    KRaftMigrationDriver.this.log.trace("Waiting until we have received metadata before proceeding with migration");
                    return;
                }
                ZkMigrationState zkMigrationState = KRaftMigrationDriver.this.image.features().zkMigrationState();
                switch (zkMigrationState) {
                    case NONE: {
                        KRaftMigrationDriver.this.log.error("The controller's ZkMigrationState is NONE which means this cluster should not be migrated from ZooKeeper. This controller should not be configured with 'zookeeper.metadata.migration.enable' set to true. Will not proceed with a migration.");
                        KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
                        break;
                    }
                    case PRE_MIGRATION: {
                        if (!KRaftMigrationDriver.this.isControllerQuorumReadyForMigration()) break;
                        KRaftMigrationDriver.this.log.info("Controller Quorum is ready for Zk to KRaft migration. Now waiting for ZK brokers.");
                        KRaftMigrationDriver.this.transitionTo(MigrationDriverState.WAIT_FOR_BROKERS);
                        break;
                    }
                    case MIGRATION: {
                        if (!KRaftMigrationDriver.this.migrationLeadershipState.initialZkMigrationComplete()) {
                            KRaftMigrationDriver.this.log.error("KRaft controller indicates an active migration, but the ZK state does not.");
                            KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
                            break;
                        }
                        KRaftMigrationDriver.this.log.info("Migration is in already progress, not waiting on ZK brokers.");
                        KRaftMigrationDriver.this.transitionTo(MigrationDriverState.BECOME_CONTROLLER);
                        break;
                    }
                    case POST_MIGRATION: {
                        KRaftMigrationDriver.this.log.error("KRaft controller indicates a completed migration, but the migration driver is somehow active.");
                        KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported ZkMigrationState " + (Object)((Object)zkMigrationState));
                    }
                }
            }
        }
    }

    class MetadataChangeEvent
    extends MigrationEvent {
        private final MetadataDelta delta;
        private final MetadataImage image;
        private final MetadataProvenance provenance;
        private final boolean isSnapshot;
        private final Consumer<Throwable> completionHandler;

        MetadataChangeEvent(MetadataDelta delta, MetadataImage image, MetadataProvenance provenance, boolean isSnapshot, Consumer<Throwable> completionHandler) {
            this.delta = delta;
            this.image = image;
            this.provenance = provenance;
            this.isSnapshot = isSnapshot;
            this.completionHandler = completionHandler;
        }

        public void run() throws Exception {
            String metadataType;
            if (!KRaftMigrationDriver.this.firstPublish && this.image.isEmpty()) {
                KRaftMigrationDriver.this.log.debug("Encountered an empty MetadataImage while waiting for the first image to be published. Ignoring this image since it either does not include bootstrap records or it is a valid image for an older unsupported metadata version.");
                this.completionHandler.accept(null);
                return;
            }
            KRaftMigrationDriver.this.firstPublish = true;
            MetadataImage prevImage = KRaftMigrationDriver.this.image;
            KRaftMigrationDriver.this.image = this.image;
            String string = metadataType = this.isSnapshot ? "snapshot" : "delta";
            if (KRaftMigrationDriver.this.migrationState.equals((Object)MigrationDriverState.INACTIVE)) {
                this.completionHandler.accept(null);
                return;
            }
            if (!KRaftMigrationDriver.this.migrationState.allowDualWrite()) {
                KRaftMigrationDriver.this.log.trace("Received metadata {}, but the controller is not in dual-write mode. Ignoring the change to be replicated to Zookeeper", (Object)metadataType);
                this.completionHandler.accept(null);
                if (this.delta.clusterDelta() != null) {
                    KRaftMigrationDriver.this.wakeup();
                }
                return;
            }
            if (!KRaftMigrationDriver.this.migrationLeadershipState.initialZkMigrationComplete()) {
                KRaftMigrationDriver.this.log.info("Ignoring {} {} since the migration has not finished.", (Object)metadataType, (Object)this.provenance);
                this.completionHandler.accept(null);
                return;
            }
            if (this.image.highestOffsetAndEpoch().compareTo(KRaftMigrationDriver.this.migrationLeadershipState.offsetAndEpoch()) < 0) {
                KRaftMigrationDriver.this.log.info("Ignoring {} {} which contains metadata that has already been written to ZK.", (Object)metadataType, (Object)this.provenance);
                this.completionHandler.accept(null);
                return;
            }
            TreeMap<String, Integer> dualWriteCounts = new TreeMap<String, Integer>();
            long startTime = KRaftMigrationDriver.this.time.nanoseconds();
            if (this.isSnapshot) {
                KRaftMigrationDriver.this.zkMetadataWriter.handleSnapshot(this.image, KRaftMigrationDriver.countingOperationConsumer(dualWriteCounts, (x$0, x$1) -> KRaftMigrationDriver.this.applyMigrationOperation(x$0, x$1)));
                KRaftMigrationDriver.this.controllerMetrics.updateZkWriteSnapshotTimeMs(TimeUnit.NANOSECONDS.toMillis(KRaftMigrationDriver.this.time.nanoseconds() - startTime));
            } else if (KRaftMigrationDriver.this.zkMetadataWriter.handleDelta(prevImage, this.image, this.delta, KRaftMigrationDriver.countingOperationConsumer(dualWriteCounts, (x$0, x$1) -> KRaftMigrationDriver.this.applyMigrationOperation(x$0, x$1)))) {
                KRaftMigrationDriver.this.controllerMetrics.updateZkWriteDeltaTimeMs(TimeUnit.NANOSECONDS.toMillis(KRaftMigrationDriver.this.time.nanoseconds() - startTime));
            }
            if (dualWriteCounts.isEmpty()) {
                KRaftMigrationDriver.this.log.trace("Did not make any ZK writes when handling KRaft {}", (Object)(this.isSnapshot ? "snapshot" : "delta"));
            } else {
                KRaftMigrationDriver.this.log.debug("Made the following ZK writes when handling KRaft {}: {}", (Object)(this.isSnapshot ? "snapshot" : "delta"), dualWriteCounts);
            }
            ZkMigrationLeadershipState zkStateAfterDualWrite = KRaftMigrationDriver.this.migrationLeadershipState.withKRaftMetadataOffsetAndEpoch(this.image.highestOffsetAndEpoch().offset(), this.image.highestOffsetAndEpoch().epoch());
            KRaftMigrationDriver.this.controllerMetrics.updateDualWriteOffset(this.image.highestOffsetAndEpoch().offset());
            KRaftMigrationDriver.this.applyMigrationOperation("Updating ZK migration state after " + metadataType, state -> KRaftMigrationDriver.this.zkMigrationClient.setMigrationRecoveryState(zkStateAfterDualWrite));
            if (this.isSnapshot) {
                KRaftMigrationDriver.this.log.debug("Sending full metadata RPCs to brokers for snapshot.");
                KRaftMigrationDriver.this.propagator.sendRPCsToBrokersFromMetadataImage(this.image, KRaftMigrationDriver.this.migrationLeadershipState.zkControllerEpoch());
            } else if (this.delta.topicsDelta() != null || this.delta.clusterDelta() != null) {
                KRaftMigrationDriver.this.log.trace("Sending incremental metadata RPCs to brokers for delta.");
                KRaftMigrationDriver.this.propagator.sendRPCsToBrokersFromMetadataDelta(this.delta, this.image, KRaftMigrationDriver.this.migrationLeadershipState.zkControllerEpoch());
            } else {
                KRaftMigrationDriver.this.log.trace("Not sending RPCs to brokers for metadata {} since no relevant metadata has changed", (Object)metadataType);
            }
            this.completionHandler.accept(null);
        }

        @Override
        public void handleException(Throwable e) {
            this.completionHandler.accept(e);
            super.handleException(e);
        }
    }

    class KRaftLeaderEvent
    extends MigrationEvent {
        private final LeaderAndEpoch leaderAndEpoch;

        KRaftLeaderEvent(LeaderAndEpoch leaderAndEpoch) {
            this.leaderAndEpoch = leaderAndEpoch;
        }

        public void run() throws Exception {
            boolean isActive = this.leaderAndEpoch.isLeader(KRaftMigrationDriver.this.nodeId);
            if (!isActive) {
                KRaftMigrationDriver.this.applyMigrationOperation("Became inactive migration driver", state -> state.withNewKRaftController(this.leaderAndEpoch.leaderId().orElse(ZkMigrationLeadershipState.EMPTY.kraftControllerId()), this.leaderAndEpoch.epoch()));
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.INACTIVE);
            } else {
                KRaftMigrationDriver.this.applyMigrationOperation("Became active migration driver", state -> {
                    ZkMigrationLeadershipState recoveredState = KRaftMigrationDriver.this.zkMigrationClient.getOrCreateMigrationRecoveryState(state);
                    return recoveredState.withNewKRaftController(KRaftMigrationDriver.this.nodeId, this.leaderAndEpoch.epoch());
                });
                KRaftMigrationDriver.this.transitionTo(MigrationDriverState.WAIT_FOR_CONTROLLER_QUORUM);
            }
        }
    }

    abstract class MigrationEvent
    implements EventQueue.Event {
        MigrationEvent() {
        }

        public void handleException(Throwable e) {
            if (e instanceof MigrationClientAuthException) {
                KRaftMigrationDriver.this.faultHandler.handleFault("Encountered ZooKeeper authentication in " + this, e);
            } else if (e instanceof MigrationClientException) {
                KRaftMigrationDriver.this.log.info(String.format("Encountered ZooKeeper error during event %s. Will retry.", this), e.getCause());
            } else if (e instanceof RejectedExecutionException) {
                KRaftMigrationDriver.this.log.debug("Not processing {} because the event queue is closed.", (Object)this);
            } else {
                KRaftMigrationDriver.this.faultHandler.handleFault("Unhandled error in " + this, e);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class PollTimeSupplier {
        private final ExponentialBackoff pollBackoff = new ExponentialBackoff(100L, 2, 60000L, 0.02);
        private long pollCount = 0L;

        PollTimeSupplier() {
        }

        void reset() {
            this.pollCount = 0L;
        }

        public long nextPollTimeMs() {
            long next = this.pollBackoff.backoff(this.pollCount);
            ++this.pollCount;
            return next;
        }
    }
}

