/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.FileListResponse;
import org.apache.solr.client.api.model.IndexVersionResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ReplicationApi {

    public static class FetchIndexVersion
    extends SolrRequest<FetchIndexVersionResponse> {
        private final String coreName;

        public FetchIndexVersion(String coreName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cores/{coreName}/replication/indexversion".replace("{coreName}", coreName));
            this.coreName = coreName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected FetchIndexVersionResponse createResponse(SolrClient client) {
            return new FetchIndexVersionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class FetchIndexVersionResponse
    extends JacksonParsingResponse<IndexVersionResponse> {
        public FetchIndexVersionResponse() {
            super(IndexVersionResponse.class);
        }
    }

    public static class FetchFileList
    extends SolrRequest<FetchFileListResponse> {
        private final String coreName;
        private final Long generation;

        public FetchFileList(String coreName, Long generation) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cores/{coreName}/replication/files".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.generation = generation;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.generation != null) {
                params.add("generation", this.generation.toString());
            }
            return params;
        }

        @Override
        protected FetchFileListResponse createResponse(SolrClient client) {
            return new FetchFileListResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class FetchFileListResponse
    extends JacksonParsingResponse<FileListResponse> {
        public FetchFileListResponse() {
            super(FileListResponse.class);
        }
    }
}

