/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.Map;
import org.apache.solr.client.api.model.BackupDeletionResponseBody;
import org.apache.solr.client.api.model.CreateCollectionBackupRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.ListCollectionBackupsResponse;
import org.apache.solr.client.api.model.PurgeUnusedFilesRequestBody;
import org.apache.solr.client.api.model.PurgeUnusedResponse;
import org.apache.solr.client.api.model.RestoreCollectionRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CollectionBackupsApi {

    public static class RestoreCollection
    extends SolrRequest<RestoreCollectionResponse> {
        private final RestoreCollectionRequestBody requestBody;
        private final String backupName;

        public RestoreCollection(String backupName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/backups/{backupName}/restore".replace("{backupName}", backupName));
            this.backupName = backupName;
            this.requestBody = new RestoreCollectionRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setCollection(String collection) {
            this.requestBody.collection = collection;
        }

        public void setLocation(String location) {
            this.requestBody.location = location;
        }

        public void setRepository(String repository) {
            this.requestBody.repository = repository;
        }

        public void setBackupId(Integer backupId) {
            this.requestBody.backupId = backupId;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setCreateCollectionParams(CreateCollectionRequestBody createCollectionParams) {
            this.requestBody.createCollectionParams = createCollectionParams;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected RestoreCollectionResponse createResponse(SolrClient client) {
            return new RestoreCollectionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class RestoreCollectionResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public RestoreCollectionResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class ListBackupsAtLocation
    extends SolrRequest<ListBackupsAtLocationResponse> {
        private final String backupName;
        private String location;
        private String repository;

        public ListBackupsAtLocation(String backupName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/backups/{backupName}/versions".replace("{backupName}", backupName));
            this.backupName = backupName;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.location != null) {
                params.add("location", this.location);
            }
            if (this.repository != null) {
                params.add("repository", this.repository);
            }
            return params;
        }

        @Override
        protected ListBackupsAtLocationResponse createResponse(SolrClient client) {
            return new ListBackupsAtLocationResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListBackupsAtLocationResponse
    extends JacksonParsingResponse<ListCollectionBackupsResponse> {
        public ListBackupsAtLocationResponse() {
            super(ListCollectionBackupsResponse.class);
        }
    }

    public static class GarbageCollectUnusedBackupFiles
    extends SolrRequest<GarbageCollectUnusedBackupFilesResponse> {
        private final PurgeUnusedFilesRequestBody requestBody;
        private final String backupName;

        public GarbageCollectUnusedBackupFiles(String backupName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/backups/{backupName}/purgeUnused".replace("{backupName}", backupName));
            this.backupName = backupName;
            this.requestBody = new PurgeUnusedFilesRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setLocation(String location) {
            this.requestBody.location = location;
        }

        public void setRepositoryName(String repositoryName) {
            this.requestBody.repositoryName = repositoryName;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GarbageCollectUnusedBackupFilesResponse createResponse(SolrClient client) {
            return new GarbageCollectUnusedBackupFilesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GarbageCollectUnusedBackupFilesResponse
    extends JacksonParsingResponse<PurgeUnusedResponse> {
        public GarbageCollectUnusedBackupFilesResponse() {
            super(PurgeUnusedResponse.class);
        }
    }

    public static class DeleteSingleBackupById
    extends SolrRequest<DeleteSingleBackupByIdResponse> {
        private final String backupName;
        private final String backupId;
        private String location;
        private String repository;
        private String async;

        public DeleteSingleBackupById(String backupName, String backupId) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/backups/{backupName}/versions/{backupId}".replace("{backupName}", backupName).replace("{backupId}", backupId));
            this.backupName = backupName;
            this.backupId = backupId;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.location != null) {
                params.add("location", this.location);
            }
            if (this.repository != null) {
                params.add("repository", this.repository);
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteSingleBackupByIdResponse createResponse(SolrClient client) {
            return new DeleteSingleBackupByIdResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteSingleBackupByIdResponse
    extends JacksonParsingResponse<BackupDeletionResponseBody> {
        public DeleteSingleBackupByIdResponse() {
            super(BackupDeletionResponseBody.class);
        }
    }

    public static class DeleteMultipleBackupsByRecency
    extends SolrRequest<DeleteMultipleBackupsByRecencyResponse> {
        private final String backupName;
        private Integer retainLatest;
        private String location;
        private String repository;
        private String async;

        public DeleteMultipleBackupsByRecency(String backupName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/backups/{backupName}/versions".replace("{backupName}", backupName));
            this.backupName = backupName;
        }

        public void setRetainLatest(Integer retainLatest) {
            this.retainLatest = retainLatest;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.retainLatest != null) {
                params.add("retainLatest", this.retainLatest.toString());
            }
            if (this.location != null) {
                params.add("location", this.location);
            }
            if (this.repository != null) {
                params.add("repository", this.repository);
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteMultipleBackupsByRecencyResponse createResponse(SolrClient client) {
            return new DeleteMultipleBackupsByRecencyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteMultipleBackupsByRecencyResponse
    extends JacksonParsingResponse<BackupDeletionResponseBody> {
        public DeleteMultipleBackupsByRecencyResponse() {
            super(BackupDeletionResponseBody.class);
        }
    }

    public static class CreateCollectionBackup
    extends SolrRequest<CreateCollectionBackupResponse> {
        private final CreateCollectionBackupRequestBody requestBody;
        private final String collectionName;
        private final String backupName;

        public CreateCollectionBackup(String collectionName, String backupName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/backups/{backupName}/versions".replace("{collectionName}", collectionName).replace("{backupName}", backupName));
            this.collectionName = collectionName;
            this.backupName = backupName;
            this.requestBody = new CreateCollectionBackupRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setLocation(String location) {
            this.requestBody.location = location;
        }

        public void setRepository(String repository) {
            this.requestBody.repository = repository;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.requestBody.followAliases = followAliases;
        }

        public void setBackupStrategy(String backupStrategy) {
            this.requestBody.backupStrategy = backupStrategy;
        }

        public void setSnapshotName(String snapshotName) {
            this.requestBody.snapshotName = snapshotName;
        }

        public void setIncremental(Boolean incremental) {
            this.requestBody.incremental = incremental;
        }

        public void setBackupConfigset(Boolean backupConfigset) {
            this.requestBody.backupConfigset = backupConfigset;
        }

        public void setMaxNumBackupPoints(Integer maxNumBackupPoints) {
            this.requestBody.maxNumBackupPoints = maxNumBackupPoints;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setExtraProperties(Map<String, String> extraProperties) {
            this.requestBody.extraProperties = extraProperties;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected CreateCollectionBackupResponse createResponse(SolrClient client) {
            return new CreateCollectionBackupResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateCollectionBackupResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public CreateCollectionBackupResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

