/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.dt.point.UnidataObsDatasetHelper;
import ucar.nc2.dt.trajectory.MultiTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.SingleTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.UnidataTrajectoryObsDataset;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonRect;

public class UnidataTrajectoryObsDataset2
extends TypedDatasetImpl
implements TrajectoryObsDataset,
TypedDatasetFactoryIF {
    protected Variable trajVar;
    protected Dimension trajDim;
    protected Variable timeVar;
    protected Dimension timeDim;
    protected Structure recordVar;
    protected Variable latVar;
    protected Variable lonVar;
    protected Variable elevVar;
    protected String trajDimName;
    protected String trajVarName;
    protected String timeDimName;
    protected String timeVarName;
    protected String latVarName;
    protected String lonVarName;
    protected String elevVarName;
    protected boolean isMultiTrajStructure;
    protected boolean isTimeDimensionFirst;
    protected TrajectoryObsDataset backingTraj;

    public static boolean isValidFile(NetcdfFile ds) {
        Attribute cdmDtAtt = ds.findGlobalAttributeIgnoreCase("cdm_data_type");
        if (cdmDtAtt == null) {
            cdmDtAtt = ds.findGlobalAttributeIgnoreCase("cdm_datatype");
        }
        if (cdmDtAtt == null) {
            return false;
        }
        if (!cdmDtAtt.isString()) {
            return false;
        }
        String cdmDtString = cdmDtAtt.getStringValue();
        if (cdmDtString == null) {
            return false;
        }
        if (!cdmDtString.equalsIgnoreCase(FeatureType.TRAJECTORY.toString())) {
            return false;
        }
        Attribute conventionsAtt = ds.findGlobalAttributeIgnoreCase("Conventions");
        if (conventionsAtt == null) {
            return false;
        }
        if (!conventionsAtt.isString()) {
            return false;
        }
        String convString = conventionsAtt.getStringValue();
        StringTokenizer stoke = new StringTokenizer(convString, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equalsIgnoreCase("Unidata Observation Dataset v1.0")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return UnidataTrajectoryObsDataset2.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new UnidataTrajectoryObsDataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.TRAJECTORY;
    }

    public UnidataTrajectoryObsDataset2() {
    }

    public UnidataTrajectoryObsDataset2(NetcdfDataset ncd) throws IOException {
        super(ncd);
        this.timeVar = UnidataObsDatasetHelper.getCoordinate(ncd, AxisType.Time);
        if (this.timeVar == null) {
            throw new IllegalArgumentException("Dataset has no time coordinate variable.");
        }
        int timeVarNumOfDims = this.timeVar.getDimensions().size();
        if (timeVarNumOfDims != 1) {
            throw new IllegalArgumentException("Dataset time variable does not have exactly one (1) dimension [" + timeVarNumOfDims + "].");
        }
        this.timeVarName = this.timeVar.getShortName();
        this.timeDim = this.timeVar.getDimension(0);
        this.timeDimName = this.timeDim.getShortName();
        this.latVar = UnidataObsDatasetHelper.getCoordinate(ncd, AxisType.Lat);
        if (this.latVar == null) {
            throw new IllegalArgumentException("Dataset has no Latitude/GeoY variable.");
        }
        List<Dimension> latVarDimList = this.latVar.getDimensions();
        int latVarNumOfDims = latVarDimList.size();
        if (latVarNumOfDims == 1) {
            this.isMultiTrajStructure = false;
        }
        if (latVarNumOfDims == 2) {
            this.isMultiTrajStructure = true;
            if (latVarDimList.get(0).equals(this.timeDim)) {
                this.isTimeDimensionFirst = true;
                this.trajDim = latVarDimList.get(1);
                this.trajDimName = this.trajDim.getShortName();
            } else {
                if (!latVarDimList.get(1).equals(this.timeDim)) {
                    throw new IllegalArgumentException("Dataset Latitude/GeoY variable has no time dimension. ");
                }
                this.isTimeDimensionFirst = false;
                this.trajDim = latVarDimList.get(0);
                this.trajDimName = this.trajDim.getShortName();
            }
        } else {
            throw new IllegalArgumentException("Dataset Latitude/GeoY variable does not have 1 or 2 dimensions [" + latVarNumOfDims + "].");
        }
        if (this.isMultiTrajStructure) {
            this.trajVarName = this.trajDimName;
            this.trajVar = ncd.getRootGroup().findVariable(this.trajVarName);
        }
        this.lonVar = UnidataObsDatasetHelper.getCoordinate(ncd, AxisType.Lon);
        if (this.lonVar == null) {
            throw new IllegalArgumentException("Missing Longitude/GeoX coordinate variable.");
        }
        this.elevVar = UnidataObsDatasetHelper.getCoordinate(ncd, AxisType.Height);
        this.timeDimName = this.timeVar.getDimension(0).getShortName();
        this.timeVarName = this.timeVar.getShortName();
        this.latVarName = this.latVar.getShortName();
        this.lonVarName = this.lonVar.getShortName();
        String string = this.elevVarName = this.elevVar != null ? this.elevVar.getShortName() : null;
        if (!this.isMultiTrajStructure) {
            this.backingTraj = new SingleTrajectoryObsDataset(ncd);
            SingleTrajectoryObsDataset.Config trajConfig = new SingleTrajectoryObsDataset.Config("1Hz data", ncd.getRootGroup().findDimension(this.timeDimName), ncd.getRootGroup().findVariable(this.timeVarName), ncd.getRootGroup().findVariable(this.latVarName), ncd.getRootGroup().findVariable(this.lonVarName), ncd.getRootGroup().findVariable(this.elevVarName));
            ((SingleTrajectoryObsDataset)this.backingTraj).setTrajectoryInfo(trajConfig);
        } else {
            this.backingTraj = new MultiTrajectoryObsDataset(ncd);
            ((MultiTrajectoryObsDataset)this.backingTraj).setTrajectoryInfo(this.ncfile.getRootGroup().findDimension(this.trajDimName), this.ncfile.getRootGroup().findVariable(this.trajVarName), this.ncfile.getRootGroup().findDimension(this.timeDimName), this.ncfile.getRootGroup().findVariable(this.timeVarName), this.ncfile.getRootGroup().findVariable(this.latVarName), this.ncfile.getRootGroup().findVariable(this.lonVarName), this.ncfile.getRootGroup().findVariable(this.elevVarName));
        }
    }

    @Override
    public String getDetailInfo() {
        return this.backingTraj.getDetailInfo();
    }

    @Override
    public String getTitle() {
        return this.backingTraj.getTitle();
    }

    @Override
    public String getDescription() {
        return this.backingTraj.getDescription();
    }

    @Override
    public String getLocation() {
        return this.backingTraj.getLocationURI();
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    public Date getStartDate() {
        return this.backingTraj.getStartDate();
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    public Date getEndDate() {
        return this.backingTraj.getEndDate();
    }

    @Override
    protected void setBoundingBox() {
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.backingTraj.getBoundingBox();
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return this.backingTraj.getGlobalAttributes();
    }

    @Override
    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.backingTraj.findGlobalAttributeIgnoreCase(name);
    }

    @Override
    public List<VariableSimpleIF> getDataVariables() {
        return this.backingTraj.getDataVariables();
    }

    @Override
    public VariableSimpleIF getDataVariable(String shortName) {
        return this.backingTraj.getDataVariable(shortName);
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.backingTraj.getNetcdfFile();
    }

    @Override
    public void close() throws IOException {
        this.backingTraj.close();
    }

    @Override
    public List<String> getTrajectoryIds() {
        return this.backingTraj.getTrajectoryIds();
    }

    @Override
    public List getTrajectories() {
        return this.backingTraj.getTrajectories();
    }

    @Override
    public TrajectoryObsDatatype getTrajectory(String trajectoryId) {
        return this.backingTraj.getTrajectory(trajectoryId);
    }

    @Override
    public boolean syncExtend() {
        return this.backingTraj.syncExtend();
    }
}

