/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.TopologyConfig;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.internals.InternalNameProvider;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.DslStoreSuppliers;
import org.apache.kafka.streams.state.StoreSupplier;

public class MaterializedInternal<K, V, S extends StateStore>
extends Materialized<K, V, S> {
    private final boolean queryable;

    public MaterializedInternal(Materialized<K, V, S> materialized) {
        this(materialized, null, null);
    }

    public MaterializedInternal(Materialized<K, V, S> materialized, InternalNameProvider nameProvider, String generatedStorePrefix) {
        super(materialized);
        TopologyConfig topologyConfig;
        boolean bl = this.queryable = this.storeName() != null;
        if (!this.queryable && nameProvider != null) {
            this.storeName = nameProvider.newStoreName(generatedStorePrefix);
        }
        if (this.dslStoreSuppliers == null && nameProvider instanceof InternalStreamsBuilder && (topologyConfig = ((InternalStreamsBuilder)nameProvider).internalTopologyBuilder.topologyConfigs()) != null) {
            this.dslStoreSuppliers = topologyConfig.resolveDslStoreSuppliers().orElse(null);
        }
    }

    public static Materialized.StoreType parse(String storeType) {
        switch (storeType) {
            case "in_memory": {
                return Materialized.StoreType.IN_MEMORY;
            }
            case "rocksDB": {
                return Materialized.StoreType.ROCKS_DB;
            }
        }
        throw new IllegalStateException("Unexpected storeType: " + storeType);
    }

    public String queryableStoreName() {
        return this.queryable ? this.storeName() : null;
    }

    public String storeName() {
        if (this.storeSupplier != null) {
            return this.storeSupplier.name();
        }
        return this.storeName;
    }

    public Optional<DslStoreSuppliers> dslStoreSuppliers() {
        return Optional.ofNullable(this.dslStoreSuppliers);
    }

    public StoreSupplier<S> storeSupplier() {
        return this.storeSupplier;
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public boolean loggingEnabled() {
        return this.loggingEnabled;
    }

    public Map<String, String> logConfig() {
        return this.topicConfig;
    }

    public boolean cachingEnabled() {
        return this.cachingEnabled;
    }

    Duration retention() {
        return this.retention;
    }
}

