/*
 * Decompiled with CFR 0.152.
 */
package ua.co.k.strftime;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import ua.co.k.strftime.LiteralPattern;
import ua.co.k.strftime.Token;
import ua.co.k.strftime.ZoneIdResolver;
import ua.co.k.strftime.formatters.DateTimeFormatterFactory;
import ua.co.k.strftime.formatters.HybridFormat;

class ValueToken
implements Token {
    private static final DateTimeFormatterFactory factory = new DateTimeFormatterFactory();
    static final List<Integer> flags = new ArrayList<Integer>(6);
    private HybridFormat formatter;
    private int zoneColumns = 0;
    private final List<Character> widthRaw = new ArrayList<Character>();
    private FlagCaseMode flagCaseMode = FlagCaseMode.none;
    private FlagPadMode flagPadMode = FlagPadMode.flagPadModeDefaults;
    private int conversion;
    Parts current;

    ValueToken() {
    }

    public static boolean isFlag(int codepoint) {
        return flags.contains(codepoint);
    }

    public static boolean isWidth(int codepoint) {
        return Character.isDigit(codepoint);
    }

    public static boolean isModifier(int codepoint) {
        return 69 == codepoint || 79 == codepoint;
    }

    public static boolean isConversion(int codepoint) {
        return factory.isKnownConversion(codepoint);
    }

    public void addFlag(int codepoint) {
        switch (codepoint) {
            case 45: {
                this.flagPadMode = FlagPadMode.flagPadModeNone;
                break;
            }
            case 48: {
                this.flagPadMode = FlagPadMode.flagPadModeZeros;
                break;
            }
            case 95: {
                this.flagPadMode = FlagPadMode.flagPadModeSpaces;
                break;
            }
            case 35: {
                this.flagCaseMode = FlagCaseMode.change;
                break;
            }
            case 94: {
                this.flagCaseMode = FlagCaseMode.upper;
                break;
            }
            case 58: {
                ++this.zoneColumns;
            }
        }
    }

    public void addWidth(int codepoint) {
        this.widthRaw.add(Character.valueOf((char)codepoint));
    }

    public boolean applyConversion(int codepoint) {
        if (codepoint != 122 && this.zoneColumns > 0) {
            return false;
        }
        if (codepoint == 122 && this.zoneColumns > 2) {
            return false;
        }
        this.conversion = codepoint;
        HybridFormat targetFormatter = factory.getFormatter(codepoint);
        if (targetFormatter == null) {
            return false;
        }
        if (targetFormatter instanceof LiteralPattern && (this.flagPadMode != FlagPadMode.flagPadModeDefaults || this.flagCaseMode != FlagCaseMode.none)) {
            return false;
        }
        if (factory.needZoneFormatWithColumns(targetFormatter, this.zoneColumns)) {
            targetFormatter = factory.zoneFormatWithColumns(this.zoneColumns);
        }
        this.formatter = targetFormatter;
        return true;
    }

    @Override
    public void render(Object date, StringBuilder out, boolean strict, Locale locale, ZoneIdResolver zoneIdResolver) {
        int padWidth = 0;
        if (!this.widthRaw.isEmpty()) {
            padWidth = Integer.parseInt(this.widthRaw.stream().map(Object::toString).collect(Collectors.joining()));
        }
        String formatted = this.formatter.formatTo(date, padWidth, strict, locale, zoneIdResolver);
        if (!this.formatter.isCombination()) {
            switch (this.flagPadMode) {
                case flagPadModeNone: {
                    formatted = HybridFormat.removeLeadingZeros(formatted);
                    break;
                }
                case flagPadModeZeros: {
                    formatted = HybridFormat.padWithZeros(formatted, padWidth);
                    break;
                }
                case flagPadModeSpaces: {
                    formatted = HybridFormat.padWithSpaces(HybridFormat.removeLeadingZeros(formatted), Math.max(padWidth, 2));
                    break;
                }
            }
        }
        switch (this.flagCaseMode) {
            case none: {
                break;
            }
            case upper: 
            case change: {
                formatted = formatted.toUpperCase(locale);
            }
        }
        out.append(formatted);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValueToken{");
        sb.appendCodePoint(this.conversion);
        sb.append('}');
        return sb.toString();
    }

    static {
        flags.add(45);
        flags.add(95);
        flags.add(48);
        flags.add(94);
        flags.add(35);
        flags.add(58);
    }

    static enum Parts {
        flags,
        width,
        modifier,
        conversion;

    }

    static enum FlagPadMode {
        flagPadModeDefaults,
        flagPadModeNone,
        flagPadModeZeros,
        flagPadModeSpaces;

    }

    static enum FlagCaseMode {
        none,
        upper,
        change;

    }
}

