/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts.templates;

import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.qodana.inspectionKts.templates.InspectionKtsTemplateKDoc;
import org.jetbrains.qodana.inspectionKts.templates.InspectionKtsTemplateKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u00a8\u0006\u0004"}, d2={"templateAnyLanguageInspectionKts", "", "filename", "templateEmptyGlobalInspectionKts", "intellij.qodana"})
public final class AnyLanguageInspectionKtsTemplateProviderKt {
    private static final String templateAnyLanguageInspectionKts(String filename) {
        String imports = "import com.intellij.psi.*";
        String topComment = "/**\n * This is an auto-generated template of custom inspection\n * It doesn't report anything, you need to implement your casts and additional logic in [localInspection]\n * and call [inspection.registerProblem] to report result from inspection\n *\n * The inspection is applied automatically and executed on-fly: to see the inspection results, open the file in the editor\n */";
        String inspectionVisitorContent = "val anyLanguageInspectionTemplate = localInspection { psiFile, inspection ->\n    // obtain here some concrete children nodes of PsiFile and implement your inspection logic, examples:\n    // val javaClasses = psiFile.descendantsOfType<PsiClass>\n    // val javaMethods = psiFile.descendantsOfType<PsiMethods> \n    // val jsVariables = psiFile.descendantsOfType<JSVariable>\n    \n    // call inspection.registerProblem(element, \"message\") to report a problem from inspection\n}";
        return InspectionKtsTemplateKt.standardLocalInspectionKtsTemplateContent$default(filename, imports, topComment, null, inspectionVisitorContent, "anyLanguageInspectionTemplate", null, 72, null);
    }

    private static final String templateEmptyGlobalInspectionKts(String filename) {
        String inspectionName = InspectionKtsTemplateKt.templateInspectionKtsFilenameToInspectionName(filename);
        String inspectionId = InspectionKtsTemplateKt.templateInspectionKtsFilenameToInspectionId(filename);
        String imports = "import com.intellij.psi.*";
        String topComment = "/**\n * This is an auto-generated template of custom global inspection\n * It doesn't report anything, you need to implement your logic in [globalInspection]\n * and call [inspection.registerProblem] to report result from inspection\n *\n * The global inspections are executed ONLY in full project analysis: in Qodana Analysis or Inspect Code...\n * \n * How to run Qodana Locally: https://www.jetbrains.com/help/qodana/quick-start.html#quickstart-run-in-ide \n */";
        String inspectionVisitorContent = "val anyLanguageInspectionTemplate = globalInspection { inspection ->\n    // obtain project files: (example)\n    val aJava: PsiFile? = inspection.findPsiFileByRelativeToProjectPath(\"relative/to/project/path/A.java\")\n    val bJava: PsiFile? = inspection.findPsiFileByRelativeToProjectPath(\"relative/to/project/path/B.java\")\n\n    // obtain here some concrete nodes of PsiFile and implement your inspection logic, examples:\n    // val javaClasses = aJava.descendantsOfType<PsiClass>\n    // val javaMethods = aJava.descendantsOfType<PsiMethods>\n    // val jsVariables = aJava.descendantsOfType<JSVariable>\n    \n    // call inspection.registerProblem(element, \"message\") to report a problem from inspection\n    // or inspection.registerProblem(\"message\") to report a project-wide problem\n}";
        String content = StringsKt.trimIndent((String)("\nimport org.intellij.lang.annotations.Language\n" + ((Object)StringsKt.trim((CharSequence)imports)).toString() + "\n\n" + ((Object)StringsKt.trim((CharSequence)topComment)).toString() + "\n\n" + ((Object)StringsKt.trim((CharSequence)InspectionKtsTemplateKDoc.INSTANCE.htmlDescription())).toString() + "\n" + ((Object)StringsKt.trim((CharSequence)InspectionKtsTemplateKt.standardInspectionKtsHtmlDescription())).toString() + "\n\n" + ((Object)StringsKt.trim((CharSequence)InspectionKtsTemplateKDoc.INSTANCE.visitor())).toString() + "\n" + ((Object)StringsKt.trim((CharSequence)inspectionVisitorContent)).toString() + "\n\n// You can define multiple inspections in one .inspection.kts file \nlistOf(\n    InspectionKts(\n        id = \"" + inspectionId + "\", " + InspectionKtsTemplateKDoc.INSTANCE.inspectionId() + "\n        globalTool = anyLanguageInspectionTemplate,\n        name = \"" + inspectionName + "\", " + InspectionKtsTemplateKDoc.INSTANCE.inspectionName() + "\n        htmlDescription = htmlDescription,\n        level = HighlightDisplayLevel.WARNING,\n    )\n    // ...\n)\n  "));
        return content;
    }

    public static final /* synthetic */ String access$templateAnyLanguageInspectionKts(String filename) {
        return AnyLanguageInspectionKtsTemplateProviderKt.templateAnyLanguageInspectionKts(filename);
    }

    public static final /* synthetic */ String access$templateEmptyGlobalInspectionKts(String filename) {
        return AnyLanguageInspectionKtsTemplateProviderKt.templateEmptyGlobalInspectionKts(filename);
    }
}

