/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyAssertTypeInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.python.psi.impl"})
public final class PyAssertTypeInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        return new PyInspectionVisitor(holder, typeEvalContext){

            public void visitPyCallExpression(PyCallExpression callExpression) {
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                List<PyCallable> list = callExpression.multiResolveCalleeFunction(this.getResolveContext());
                Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveCalleeFunction(...)");
                PyCallable callable = (PyCallable)CollectionsKt.singleOrNull(list);
                if (callable instanceof PyFunction && Intrinsics.areEqual((Object)"typing.assert_type", (Object)((PyFunction)callable).getQualifiedName())) {
                    PyType expectedType;
                    PyType actualType;
                    PyExpression[] pyExpressionArray = callExpression.getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
                    PyExpression[] arguments = pyExpressionArray;
                    if (arguments.length == 2 && !Intrinsics.areEqual((Object)(actualType = this.myTypeEvalContext.getType(arguments[0])), (Object)(expectedType = (PyType)Ref.deref(PyTypingTypeProvider.getType(arguments[1], this.myTypeEvalContext))))) {
                        String string = PythonDocumentationProvider.getVerboseTypeName(expectedType, this.myTypeEvalContext);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVerboseTypeName(...)");
                        String expectedName = string;
                        String string2 = PythonDocumentationProvider.getTypeName(actualType, this.myTypeEvalContext);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeName(...)");
                        String actualName = string2;
                        Object[] objectArray = new Object[]{expectedName, actualName};
                        this.registerProblem((PsiElement)arguments[0], PyPsiBundle.message("INSP.assert.type.expected.type.got.type.instead", objectArray));
                    }
                }
            }
        };
    }
}

