/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import java.math.BigDecimal;
import java.math.RoundingMode;

public final class Precision {
    public static final double EPSILON = Double.longBitsToDouble(4368491638549381120L);
    public static final double SAFE_MIN = Double.MIN_NORMAL;
    private static final long EXPONENT_OFFSET = 1023L;
    private static final double POSITIVE_ZERO = 0.0;

    private Precision() {
    }

    public static int compareTo(double x, double y, double eps) {
        if (Precision.equals(x, y, eps)) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        return Double.compare(x, y);
    }

    public static int compareTo(double x, double y, int maxUlps) {
        if (Precision.equals(x, y, maxUlps)) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        return Double.compare(x, y);
    }

    public static boolean equals(float x, float y) {
        return Precision.equals(x, y, 1);
    }

    public static boolean equalsIncludingNaN(float x, float y) {
        boolean yIsNan;
        boolean xIsNan = Float.isNaN(x);
        return xIsNan | (yIsNan = Float.isNaN(y)) ? xIsNan == yIsNan : Precision.equals(x, y, 1);
    }

    public static boolean equals(float x, float y, float eps) {
        return Precision.equals(x, y, 1) || Math.abs(y - x) <= eps;
    }

    public static boolean equalsIncludingNaN(float x, float y, float eps) {
        return Precision.equalsIncludingNaN(x, y, 1) || Math.abs(y - x) <= eps;
    }

    public static boolean equals(float x, float y, int maxUlps) {
        int deltaMinus;
        int deltaPlus;
        int yInt;
        int xInt = Float.floatToRawIntBits(x);
        boolean isEqual = (xInt ^ (yInt = Float.floatToRawIntBits(y))) < 0 ? (long)(deltaPlus = xInt & Integer.MAX_VALUE) + (long)(deltaMinus = yInt & Integer.MAX_VALUE) <= (long)maxUlps : Math.abs(xInt - yInt) <= maxUlps;
        return isEqual && !Float.isNaN(x) && !Float.isNaN(y);
    }

    public static boolean equalsIncludingNaN(float x, float y, int maxUlps) {
        boolean yIsNan;
        boolean xIsNan = Float.isNaN(x);
        return xIsNan | (yIsNan = Float.isNaN(y)) ? xIsNan == yIsNan : Precision.equals(x, y, maxUlps);
    }

    public static boolean equals(double x, double y) {
        return Precision.equals(x, y, 1);
    }

    public static boolean equalsIncludingNaN(double x, double y) {
        boolean yIsNan;
        boolean xIsNan = Double.isNaN(x);
        return xIsNan | (yIsNan = Double.isNaN(y)) ? xIsNan == yIsNan : Precision.equals(x, y, 1);
    }

    public static boolean equals(double x, double y, double eps) {
        return Precision.equals(x, y, 1) || Math.abs(y - x) <= eps;
    }

    public static boolean equalsWithRelativeTolerance(double x, double y, double eps) {
        if (Precision.equals(x, y, 1)) {
            return true;
        }
        double absoluteMax = Math.max(Math.abs(x), Math.abs(y));
        double relativeDifference = Math.abs((x - y) / absoluteMax);
        return relativeDifference <= eps;
    }

    public static boolean equalsIncludingNaN(double x, double y, double eps) {
        return Precision.equalsIncludingNaN(x, y) || Math.abs(y - x) <= eps;
    }

    public static boolean equals(double x, double y, int maxUlps) {
        long yInt;
        long xInt = Double.doubleToRawLongBits(x);
        if ((xInt ^ (yInt = Double.doubleToRawLongBits(y))) < 0L) {
            long deltaPlus = xInt & Long.MAX_VALUE;
            long deltaMinus = yInt & Long.MAX_VALUE;
            return deltaPlus <= (long)maxUlps && deltaMinus <= (long)maxUlps - deltaPlus;
        }
        return Math.abs(xInt - yInt) <= (long)maxUlps && !Double.isNaN(x) && !Double.isNaN(y);
    }

    public static boolean equalsIncludingNaN(double x, double y, int maxUlps) {
        boolean yIsNan;
        boolean xIsNan = Double.isNaN(x);
        return xIsNan | (yIsNan = Double.isNaN(y)) ? xIsNan == yIsNan : Precision.equals(x, y, maxUlps);
    }

    public static double round(double x, int scale) {
        return Precision.round(x, scale, RoundingMode.HALF_UP);
    }

    public static double round(double x, int scale, RoundingMode roundingMethod) {
        try {
            double rounded = new BigDecimal(Double.toString(x)).setScale(scale, roundingMethod).doubleValue();
            return rounded == 0.0 ? 0.0 * x : rounded;
        }
        catch (NumberFormatException ex) {
            if (Double.isInfinite(x)) {
                return x;
            }
            return Double.NaN;
        }
    }

    public static double representableDelta(double x, double delta) {
        return x + delta - x;
    }

    public static DoubleEquivalence doubleEquivalenceOfEpsilon(final double eps) {
        if (!Double.isFinite(eps) || eps < 0.0) {
            throw new IllegalArgumentException("Invalid epsilon value: " + eps);
        }
        return new DoubleEquivalence(){
            private final double epsilon;
            {
                this.epsilon = eps;
            }

            @Override
            public int compare(double a, double b) {
                return Precision.compareTo(a, b, this.epsilon);
            }
        };
    }

    public static interface DoubleEquivalence {
        default public boolean eq(double a, double b) {
            return this.compare(a, b) == 0;
        }

        default public boolean eqZero(double a) {
            return this.eq(a, 0.0);
        }

        default public boolean lt(double a, double b) {
            return this.compare(a, b) < 0;
        }

        default public boolean lte(double a, double b) {
            return this.compare(a, b) <= 0;
        }

        default public boolean gt(double a, double b) {
            return this.compare(a, b) > 0;
        }

        default public boolean gte(double a, double b) {
            return this.compare(a, b) >= 0;
        }

        default public double signum(double a) {
            if (a == 0.0 || Double.isNaN(a)) {
                return a;
            }
            return this.eqZero(a) ? Math.copySign(0.0, a) : Math.copySign(1.0, a);
        }

        public int compare(double var1, double var3);
    }
}

