/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.util;

import org.jetbrains.annotations.NotNull;

public final class Utf8Util {
    private static final long NON_SHORTEST_FORM = Long.MIN_VALUE;
    private static final long NO_FOLLOWING_BYTE = -4611686018427387904L;
    private static final long UTF_16_SURROGATES = -2305843009213693952L;
    private static final long INVALID_CODE_POINTS = -1152921504606846976L;

    public static long isWellFormed(byte @NotNull [] bytes) {
        int index = 0;
        int end = bytes.length;
        while (true) {
            byte byte4;
            byte byte3;
            byte byte2;
            byte byte1;
            if (index >= end) {
                return 0L;
            }
            if ((byte1 = bytes[index++]) >= 0) continue;
            if (byte1 < -32) {
                if (index == end) {
                    return (long)index + -4611686018427387904L;
                }
                if (byte1 < -62) {
                    return (long)index + Long.MIN_VALUE;
                }
                if ((byte2 = bytes[index++]) <= -65) continue;
                return (long)index + -4611686018427387904L;
            }
            if (byte1 < -16) {
                if (index + 1 >= end) {
                    return (long)index + -4611686018427387904L;
                }
                if ((byte2 = bytes[index++]) > -65) {
                    return (long)index + -4611686018427387904L;
                }
                if (byte1 == -32 && byte2 < -96) {
                    return (long)index + Long.MIN_VALUE;
                }
                if (byte1 == -19 && byte2 >= -96) {
                    return (long)index + -2305843009213693952L;
                }
                if ((byte3 = bytes[index++]) <= -65) continue;
                return (long)index + -4611686018427387904L;
            }
            if (index + 2 >= end) {
                return (long)index + -4611686018427387904L;
            }
            if ((byte2 = bytes[index++]) > -65) {
                return (long)index + -4611686018427387904L;
            }
            if (byte1 == -16 && byte2 < -112) {
                return (long)index + Long.MIN_VALUE;
            }
            if (byte1 == -12 && byte2 > -113 || byte1 > -12) {
                return (long)index + -1152921504606846976L;
            }
            if ((byte3 = bytes[index++]) > -65) {
                return (long)index + -4611686018427387904L;
            }
            if ((byte4 = bytes[index++]) > -65) break;
        }
        return (long)index + -4611686018427387904L;
    }

    public static int encodedLength(@NotNull String string) {
        int utf16Length;
        int utf8Length = utf16Length = string.length();
        for (int i = 0; i < utf16Length; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') continue;
            ++utf8Length;
            if (c <= '\u07ff') continue;
            ++utf8Length;
            if (!Character.isHighSurrogate(c)) continue;
            ++i;
        }
        return utf8Length;
    }

    private Utf8Util() {
    }
}

