/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;

public abstract class CounterStatisticManager {
    protected final SimpleCounterStatistic.AlignGroup align = new SimpleCounterStatistic.AlignGroup();
    private final ConcurrentMap<String, SimpleCounterStatistic> statistics = new ConcurrentHashMap<String, SimpleCounterStatistic>();
    private final List<String> orderedKeys = new CopyOnWriteArrayList<String>();
    protected final String tag;
    private AtomicLong lastTransfer = new AtomicLong(ClockUtil.nanoRealtime());

    protected CounterStatisticManager(String tag) {
        this.tag = StringUtil.normalizeLoggingTag(tag);
    }

    protected void add(String head, SimpleCounterStatistic statistic) {
        this.addByKey(head + statistic.getName(), statistic);
    }

    protected void add(SimpleCounterStatistic statistic) {
        this.addByKey(statistic.getName(), statistic);
    }

    protected void addByKey(String key, SimpleCounterStatistic statistic) {
        SimpleCounterStatistic previous = this.statistics.put(key, statistic);
        if (previous != null) {
            this.orderedKeys.remove(key);
        }
        this.orderedKeys.add(key);
    }

    protected void removeByKey(String key, SimpleCounterStatistic statistic) {
        if (this.statistics.remove(key, statistic)) {
            this.orderedKeys.remove(key);
        }
    }

    protected void removeByKey(String key) {
        if (this.statistics.containsKey(key)) {
            this.statistics.remove(key);
            this.orderedKeys.remove(key);
        }
    }

    public SimpleCounterStatistic getByKey(String key) {
        return (SimpleCounterStatistic)this.statistics.get(key);
    }

    public List<String> getKeys() {
        return Collections.unmodifiableList(this.orderedKeys);
    }

    public List<String> getKeys(Principal principal) {
        return Collections.unmodifiableList(this.orderedKeys);
    }

    public abstract boolean isEnabled();

    public abstract void dump();

    public long getLastTransferTime() {
        return this.lastTransfer.get();
    }

    public void transferCounter() {
        for (SimpleCounterStatistic statistic : this.statistics.values()) {
            statistic.transferCounter();
        }
        this.lastTransfer.set(ClockUtil.nanoRealtime());
    }

    public void reset() {
        for (SimpleCounterStatistic statistic : this.statistics.values()) {
            statistic.reset();
        }
        this.lastTransfer.set(ClockUtil.nanoRealtime());
    }

    public long getCounterByKey(String key) {
        return this.getByKey(key).getCounter();
    }

    public String getTag() {
        return this.tag;
    }
}

