/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.concurrent.serial;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialExecutor
implements AutoCloseable {
    static final Logger logger = LoggerFactory.getLogger(SerialExecutor.class);
    final Executor executor;
    final Deque<Runnable> tasks = new ArrayDeque<Runnable>();
    final PromiseFactory factory;
    volatile Thread thread;

    public SerialExecutor(Executor executor) {
        this.executor = executor;
        this.factory = new PromiseFactory(executor);
    }

    public <T> Promise<T> submit(Callable<T> callable) {
        Deferred deferred = this.factory.deferred();
        Runnable r = () -> {
            try {
                Object value = callable.call();
                deferred.resolve(value);
            }
            catch (Throwable e) {
                deferred.fail(e);
            }
        };
        this.run(r);
        return deferred.getPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable runnable) {
        Deque<Runnable> deque = this.tasks;
        synchronized (deque) {
            this.tasks.push(runnable);
            if (this.tasks.size() == 1) {
                this.executor.execute(() -> {
                    this.thread = Thread.currentThread();
                    while (true) {
                        Runnable r;
                        Deque<Runnable> deque = this.tasks;
                        synchronized (deque) {
                            if (this.tasks.isEmpty() || this.thread.isInterrupted()) {
                                this.thread = null;
                                return;
                            }
                            r = this.tasks.pop();
                        }
                        try {
                            r.run();
                            continue;
                        }
                        catch (Throwable e) {
                            logger.warn("failed to execute task {} {}", new Object[]{runnable, e, e});
                            continue;
                        }
                        break;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Deque<Runnable> deque = this.tasks;
        synchronized (deque) {
            this.tasks.clear();
            Thread t = this.thread;
            if (t != null) {
                t.interrupt();
            }
        }
    }
}

