/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import org.keycloak.models.ClientModel;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;

public class ConsentRequiredClientRegistrationPolicy
implements ClientRegistrationPolicy {
    @Override
    public void beforeRegister(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
    }

    @Override
    public void afterRegister(ClientRegistrationContext context, ClientModel clientModel) {
        clientModel.setConsentRequired(true);
    }

    @Override
    public void beforeUpdate(ClientRegistrationContext context, ClientModel clientModel) throws ClientRegistrationPolicyException {
        if (context.getClient().isConsentRequired() == null) {
            return;
        }
        if (clientModel == null) {
            return;
        }
        boolean isEnabled = clientModel.isConsentRequired();
        boolean newEnabled = context.getClient().isConsentRequired();
        if (isEnabled && !newEnabled) {
            throw new ClientRegistrationPolicyException("Not permitted to update consentRequired to false");
        }
    }

    @Override
    public void afterUpdate(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeView(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }

    @Override
    public void beforeDelete(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
    }
}

