/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import org.openstreetmap.josm.gui.datatransfer.data.TagTransferData;

public class TagTransferable
implements Transferable {
    private final TagTransferData data;

    public TagTransferable(TagTransferData data) {
        this.data = data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{TagTransferData.FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Stream.of(this.getTransferDataFlavors()).anyMatch(f -> f.equals(flavor));
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.getStringData();
        }
        if (TagTransferData.FLAVOR.equals(flavor)) {
            return this.data;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private String getStringData() {
        StringBuilder string = new StringBuilder();
        for (Map.Entry<String, String> e : this.data.getTags().entrySet()) {
            if (string.length() > 0) {
                string.append('\n');
            }
            string.append(e.getKey());
            string.append('=');
            string.append(e.getValue());
        }
        return string.toString();
    }
}

