/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.model.history;

import java.net.URI;
import java.util.ArrayList;

public class History {
    protected URI current = null;
    protected ArrayList<URI> backward = new ArrayList();
    protected ArrayList<URI> forward = new ArrayList();

    public void add(URI uri) {
        if (this.current == null) {
            this.forward.clear();
            this.current = uri;
            return;
        }
        if (this.current.equals(uri)) {
            return;
        }
        if (uri.getPath().toString().equals(this.current.getPath().toString())) {
            if (uri.getFragment() != null || uri.getQuery() != null) {
                if (this.current.getFragment() == null && this.current.getQuery() == null) {
                    this.current = uri;
                } else {
                    this.forward.clear();
                    this.backward.add(this.current);
                    this.current = uri;
                }
            }
            return;
        }
        if (uri.toString().startsWith(this.current.toString())) {
            this.current = uri;
            return;
        }
        if (this.current.toString().startsWith(uri.toString())) {
            return;
        }
        this.forward.clear();
        this.backward.add(this.current);
        this.current = uri;
    }

    public URI backward() {
        if (!this.backward.isEmpty()) {
            this.forward.add(this.current);
            int size = this.backward.size();
            this.current = this.backward.remove(size - 1);
        }
        return this.current;
    }

    public URI forward() {
        if (!this.forward.isEmpty()) {
            this.backward.add(this.current);
            int size = this.forward.size();
            this.current = this.forward.remove(size - 1);
        }
        return this.current;
    }

    public boolean canBackward() {
        return !this.backward.isEmpty();
    }

    public boolean canForward() {
        return !this.forward.isEmpty();
    }
}

