/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import net.i2p.util.TryCache;

public final class ByteCache
extends TryCache<ByteArray> {
    private static final Map<Integer, ByteCache> _caches = new ConcurrentHashMap<Integer, ByteCache>(16);
    private static final int MAX_CACHE;
    private final int _entrySize;
    private static final int CLEANUP_FREQUENCY = 33000;
    private static final long EXPIRE_PERIOD = 120000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteCache getInstance(int cacheSize, int size) {
        ByteCache cache;
        if (cacheSize * size > MAX_CACHE) {
            cacheSize = MAX_CACHE / size;
        }
        Integer sz = size;
        Map<Integer, ByteCache> map = _caches;
        synchronized (map) {
            cache = _caches.get(sz);
            if (cache == null) {
                cache = new ByteCache(cacheSize, size);
                _caches.put(sz, cache);
            }
        }
        cache.resize(cacheSize);
        return cache;
    }

    public static void clearAll() {
        for (ByteCache bc : _caches.values()) {
            bc.clear();
        }
    }

    private ByteCache(int maxCachedEntries, int entrySize) {
        super(new ByteArrayFactory(entrySize), maxCachedEntries);
        this._entrySize = entrySize;
        int stagger = SystemVersion.isAndroid() ? 0 : entrySize % 777;
        SimpleTimer2.getInstance().addPeriodicEvent(new Cleanup(), 33000 + stagger);
        I2PAppContext.getGlobalContext().statManager().createRateStat("byteCache.memory." + entrySize, "Memory usage (B)", "Router", new long[]{600000L});
    }

    private void resize(int maxCachedEntries) {
    }

    @Override
    public final void release(ByteArray entry) {
        this.release(entry, true);
    }

    public final void release(ByteArray entry, boolean shouldZero) {
        if (entry == null || entry.getData() == null) {
            return;
        }
        if (entry.getData().length != this._entrySize) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(ByteCache.class);
            if (log.shouldLog(30)) {
                log.warn("Bad size", new Exception("I did it"));
            }
            return;
        }
        entry.setValid(0);
        entry.setOffset(0);
        if (shouldZero) {
            Arrays.fill(entry.getData(), (byte)0);
        }
        super.release(entry);
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        MAX_CACHE = (int)Math.min(0x400000L, Math.max(131072L, maxMemory / 128L));
    }

    private static class ByteArrayFactory
    implements TryCache.ObjectFactory<ByteArray> {
        private final int sz;

        ByteArrayFactory(int entrySize) {
            this.sz = entrySize;
        }

        @Override
        public ByteArray newInstance() {
            byte[] data = new byte[this.sz];
            ByteArray rv = new ByteArray(data);
            rv.setValid(0);
            return rv;
        }
    }

    private class Cleanup
    implements SimpleTimer.TimedEvent {
        private Cleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            int origsz;
            ByteCache.this.lock.lock();
            try {
                origsz = ByteCache.this.items.size();
                if (origsz > 1 && System.currentTimeMillis() - ByteCache.this._lastUnderflow > 120000L) {
                    int toRemove = origsz / 2;
                    for (int i = 0; i < toRemove; ++i) {
                        ByteCache.this.items.remove(ByteCache.this.items.size() - 1);
                    }
                }
            }
            finally {
                ByteCache.this.lock.unlock();
            }
            I2PAppContext.getGlobalContext().statManager().addRateData("byteCache.memory." + ByteCache.this._entrySize, ByteCache.this._entrySize * origsz);
        }

        public String toString() {
            return "Cleaner for " + ByteCache.this._entrySize + " byte cache";
        }
    }
}

