/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.Resource;
import net.sf.freecol.common.resources.ResourceFactory;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;

public class FreeColDataFile {
    private static final Logger logger = Logger.getLogger(FreeColDataFile.class.getName());
    protected static final String ZIP_FILE_EXTENSION = "zip";
    private static final String resourceScheme = "resource:";
    private final File file;
    private final String jarDirectory;

    public FreeColDataFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File " + file.getName() + " does not exist");
        }
        this.file = file;
        this.jarDirectory = file.isDirectory() ? null : FreeColDataFile.findJarDirectory(file);
    }

    private static String findJarDirectory(File file) {
        String string;
        JarFile jf = new JarFile(file);
        try {
            JarEntry entry = jf.entries().nextElement();
            String en = entry.getName();
            int index = en.lastIndexOf(47);
            String name = "";
            if (index > 0) {
                name = en.substring(0, index + 1);
            }
            string = name;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                logger.warning("Failed to create jar file: " + file.getName());
                return null;
            }
        }
        jf.close();
        return string;
    }

    protected URI getURI(String name) {
        try {
            if (name.startsWith("urn:")) {
                try {
                    return new URI(name);
                }
                catch (URISyntaxException e) {
                    logger.log(Level.WARNING, "Resource creation failure with: " + name, e);
                    return null;
                }
            }
            if (this.file.isDirectory()) {
                return new File(this.file, name).toURI();
            }
            return new URI("jar:file", this.file + "!/" + this.jarDirectory + name, null);
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "Failed to lookup: " + this.file + "/" + name, e);
            return null;
        }
    }

    public BufferedInputStream getInputStream(String filename) throws IOException {
        URLConnection connection = this.getURI(filename).toURL().openConnection();
        connection.setDefaultUseCaches(false);
        return new BufferedInputStream(connection.getInputStream());
    }

    public ResourceMapping getResourceMapping() {
        LogBuilder lb = new LogBuilder(64);
        lb.add("Resource mappings:");
        lb.mark();
        Properties properties = this.readResourcesProperties(lb);
        if (properties == null) {
            return null;
        }
        ResourceMapping rc = new ResourceMapping();
        List<String> virtualResources = this.handleResources(properties, rc);
        this.handleVirtualResources(virtualResources, lb, properties, rc);
        if (lb.grew(new Object[0])) {
            lb.log(logger, Level.FINE);
        }
        return rc;
    }

    private List<String> handleResources(Properties properties, ResourceMapping rc) {
        ResourceFactory resourceFactory = new ResourceFactory();
        ArrayList<String> virtualResources = new ArrayList<String>();
        Enumeration<?> pn = properties.propertyNames();
        while (pn.hasMoreElements()) {
            String key = (String)pn.nextElement();
            String updatedKey = this.stripEnding(key, ".r0");
            String value = properties.getProperty(key);
            if (value.startsWith(resourceScheme)) {
                virtualResources.add(updatedKey);
                continue;
            }
            this.handleNormalResource(resourceFactory, rc, key, value);
        }
        return virtualResources;
    }

    private void handleNormalResource(ResourceFactory resourceFactory, ResourceMapping rc, String key, String value) {
        boolean supportsVariations;
        URI uri = this.getURI(value);
        if (uri == null) {
            return;
        }
        String cachingKey = uri.toString();
        Resource resource = resourceFactory.createResource(key, cachingKey, uri);
        boolean bl = supportsVariations = !key.contains(".improvement.river.");
        if (resource instanceof ImageResource && supportsVariations) {
            ImageResource imageResource = (ImageResource)resource;
            this.extendWithAdditionalSizesAndVariations(resourceFactory, imageResource, value);
        }
        if (resource != null) {
            rc.add(key, resource);
        }
    }

    private void handleVirtualResources(List<String> virtualResources, LogBuilder lb, Properties properties, ResourceMapping rc) {
        boolean progress = true;
        ArrayList<String> miss = new ArrayList<String>();
        while (progress && !virtualResources.isEmpty()) {
            miss.clear();
            progress = false;
            while (!virtualResources.isEmpty()) {
                String key = virtualResources.remove(0);
                String updatedKey = this.stripEnding(key, ".r0");
                String value = properties.getProperty(key).substring(resourceScheme.length());
                if (!rc.duplicateResource(value, updatedKey)) {
                    miss.add(key);
                    continue;
                }
                progress = true;
            }
            virtualResources.addAll(miss);
        }
        if (!virtualResources.isEmpty()) {
            lb.add(", could not resolve virtual resource/s: ", StringUtils.join(" ", virtualResources));
        }
    }

    private Properties readResourcesProperties(LogBuilder lb) {
        Properties properties = new Properties();
        for (String fileName : FreeColDirectories.getResourceFileNames()) {
            try {
                BufferedInputStream is = this.getInputStream(fileName);
                try {
                    properties.load(is);
                    lb.add(Character.valueOf(' '), this.file, Character.valueOf('/'), fileName, ":ok");
                }
                finally {
                    if (is == null) continue;
                    ((InputStream)is).close();
                }
            }
            catch (FileNotFoundException e) {
                lb.add(Character.valueOf(' '), this.file, Character.valueOf('/'), fileName, ":not-found");
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "ResourceMapping read exception: " + this.file + "/" + fileName, e);
                return null;
            }
        }
        return properties;
    }

    private String stripEnding(String key, String ending) {
        return key.endsWith(ending) ? key.substring(0, key.length() - 3) : key;
    }

    private void extendWithAdditionalSizesAndVariations(ResourceFactory resourceFactory, ImageResource imageResource, String value) {
        Map<URI, List<URI>> variationsWithAlternateSizes = this.findVariationsWithAlternateSizes(value);
        imageResource.addAlternativeResourceLocators(variationsWithAlternateSizes.get(null));
        variationsWithAlternateSizes.entrySet().stream().filter(entry -> entry.getKey() != null).forEach(entry -> {
            ImageResource variationResource = (ImageResource)resourceFactory.createResource("", imageResource.getCachingKey(), (URI)entry.getKey());
            if (variationResource != null) {
                variationResource.addAlternativeResourceLocators((List)entry.getValue());
                imageResource.addVariation(variationResource);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URI, List<URI>> findVariationsWithAlternateSizes(String name) {
        if (name.indexOf(".") <= 0) {
            return Map.of();
        }
        FileSystem fileSystem = null;
        try {
            Path filePath;
            if (this.file.isDirectory()) {
                filePath = new File(this.file, name).toPath();
            } else {
                fileSystem = FileSystems.newFileSystem(new URI("jar:file", this.file.getAbsolutePath(), null), Map.of());
                filePath = fileSystem.getPath(this.jarDirectory + name, new String[0]);
            }
            LinkedHashMap<URI, List<URI>> result = new LinkedHashMap<URI, List<URI>>();
            result.put(null, this.findFilesWithVariationOrAlternativeSizeAsUri(filePath, false));
            List<Path> variations = this.findFilesWithVariationOrAlternativeSize(filePath, true);
            for (Path variationPath : variations) {
                result.put(variationPath.toUri(), this.findFilesWithVariationOrAlternativeSizeAsUri(variationPath, false));
            }
            LinkedHashMap<URI, List<URI>> linkedHashMap = result;
            return linkedHashMap;
        }
        catch (IOException | URISyntaxException e) {
            logger.log(Level.WARNING, "Failed to read directory from jar/zip file: " + this.file + " jarDirectory" + this.jarDirectory, e);
            Map<URI, List<URI>> map = Map.of();
            return map;
        }
        finally {
            if (fileSystem != null) {
                try {
                    fileSystem.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<URI> findFilesWithVariationOrAlternativeSizeAsUri(Path filePath, boolean findVariation) throws IOException {
        return this.findFilesWithVariationOrAlternativeSize(filePath, findVariation).stream().map(p -> p.toUri()).collect(Collectors.toList());
    }

    private List<Path> findFilesWithVariationOrAlternativeSize(Path filePath, boolean findVariation) throws IOException {
        String variationFileRegex = "[0-9][0-9]?";
        String sizeFileRegex = "\\.size[0-9][0-9]*";
        String regex = findVariation ? "[0-9][0-9]?" : "\\.size[0-9][0-9]*";
        String resourceFilename = filePath.getFileName().toString();
        String prefix = resourceFilename.substring(0, resourceFilename.lastIndexOf("."));
        if (findVariation) {
            prefix = prefix.replaceAll("[0-9]*$", "");
        }
        String suffix = resourceFilename.substring(resourceFilename.lastIndexOf("."));
        String completeRegex = Pattern.quote(prefix) + regex + Pattern.quote(suffix);
        try (Stream<Path> pathStream = Files.list(filePath.getParent());){
            List<Path> list = pathStream.sorted().filter(p -> p.getFileName().toString().matches(completeRegex) && (!findVariation || !p.equals(filePath))).collect(Collectors.toList());
            return list;
        }
    }

    public String getPath() {
        return this.file.getPath();
    }

    public static FileFilter getFileFilter(String extension) {
        final String s = Messages.message("filter." + extension);
        if (extension.equals("*")) {
            return new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return true;
                }

                @Override
                public String getDescription() {
                    return s;
                }
            };
        }
        return new FileNameExtensionFilter(s, extension);
    }
}

