untrusted comment: verify with openbsd-78-base.pub
RWS3/nvFmk4SWcFCBbT5izz1KFz5Oj9Lx+Mv9LvsaimqM2JUMAZC4xmTuX8I6bhPsohyOpTVmxZydYya9MA3pXm/5eLbBFDrqws=

OpenBSD 7.8 errata 001, October 26, 2025:

syspatch(8) is confused by aliased /dev/*rootdisk nodes in the database
generated by dev_mkdb(8).  If syspatch fails (probably because /usr
is not a seperate filesystem), perform these steps:
    sed -e 's/.checkfs/#checkfs/g' /usr/sbin/syspatch > /root/syspatch
    ksh /root/syspatch
    syspatch # re-run new syspatch command as instructed
    rm /root/syspatch
    dev_mkdb

Apply by doing:
    signify -Vep /etc/signify/openbsd-78-base.pub -x 001_syspatch.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild dev_mkdb and rebuild the database:
    cd /usr/src/usr.sbin/syspatch
    make obj
    make
    make install
    cd /usr/src/usr.sbin/dev_mkdb
    make obj
    make
    make install
    dev_mkdb	# run it to create a corrected database

Index: usr.sbin/syspatch/syspatch.sh
===================================================================
RCS file: /cvs/src/usr.sbin/syspatch/syspatch.sh,v
diff -u -p -u -r1.168 syspatch.sh
--- usr.sbin/syspatch/syspatch.sh	13 Dec 2023 17:50:23 -0000	1.168
+++ usr.sbin/syspatch/syspatch.sh	27 Oct 2025 01:43:31 -0000
@@ -91,10 +91,15 @@ checkfs()
 	set +e # ignore errors due to:
 	# - nonexistent files (i.e. syspatch is installing new files)
 	# - broken interpolation due to bogus devices like remote filesystems
-	eval $(cd / &&
-		stat -qf "_dev=\"\${_dev} %Sd\";
-			local %Sd=\"\${%Sd:+\${%Sd}\+}%Uz\"" ${_files}) \
-			2>/dev/null
+	for _f in ${_files}; do
+		_fdev=$(df /${_f} 2>/dev/null | grep "^/dev/" | \
+		    cut -d' ' -f1 | cut -d/ -f3)
+		[[ -n ${_fdev} ]] || continue
+		_dev="${_dev} ${_fdev}"
+		eval $(stat -qf "local ${_fdev}=\$((\$${_fdev}+%Uz))" /${_f} ) \
+		    2>/dev/null
+
+	done
 	set -e
 
 	for _d in $(printf '%s\n' ${_dev} | sort -u); do
Index: usr.sbin/dev_mkdb/dev_mkdb.c
===================================================================
RCS file: /cvs/src/usr.sbin/dev_mkdb/dev_mkdb.c,v
diff -u -p -u -r1.20 dev_mkdb.c
--- usr.sbin/dev_mkdb/dev_mkdb.c	24 Dec 2023 06:35:05 -0000	1.20
+++ usr.sbin/dev_mkdb/dev_mkdb.c	26 Oct 2025 04:16:00 -0000
@@ -112,11 +112,15 @@ main(int argc, char *argv[])
 			continue;
 
 		/* Create the key. */
-		if (S_ISCHR(dp->fts_statp->st_mode))
+		if (S_ISCHR(dp->fts_statp->st_mode)) {
+			if (strcmp(dp->fts_path, "./rrootdisk") == 0)
+				continue;
 			bkey.type = S_IFCHR;
-		else if (S_ISBLK(dp->fts_statp->st_mode))
+		} else if (S_ISBLK(dp->fts_statp->st_mode)) {
+			if (strcmp(dp->fts_path, "./rootdisk") == 0)
+				continue;
 			bkey.type = S_IFBLK;
-		else
+		} else
 			continue;
 		bkey.dev = dp->fts_statp->st_rdev;
 
