untrusted comment: verify with openbsd-66-base.pub
RWSvK/c+cFe24ID9OJ5hTILQ5qcxhfllimT9+6/LaNJzjiSYD3SLY6NCBGjluB/Uq+1W5hxt5S7znebI79zmeNaWHJcdPRyyIwg=

OpenBSD 6.6 errata 008, November 22, 2019:

Shared memory regions used by some Mesa drivers had permissions which
allowed others to access that memory.

Apply by doing:
    signify -Vep /etc/signify/openbsd-66-base.pub -x 008_mesa.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild Mesa
    cd /usr/xenocara/lib/mesa
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: lib/mesa/src/gallium/winsys/sw/dri/dri_sw_winsys.c
===================================================================
RCS file: /cvs/xenocara/lib/mesa/src/gallium/winsys/sw/dri/dri_sw_winsys.c,v
retrieving revision 1.7
diff -u -p -r1.7 dri_sw_winsys.c
--- lib/mesa/src/gallium/winsys/sw/dri/dri_sw_winsys.c	19 Feb 2019 04:24:01 -0000	1.7
+++ lib/mesa/src/gallium/winsys/sw/dri/dri_sw_winsys.c	20 Nov 2019 07:15:32 -0000
@@ -93,7 +93,8 @@ alloc_shm(struct dri_sw_displaytarget *d
 {
    char *addr;
 
-   dri_sw_dt->shmid = shmget(IPC_PRIVATE, size, IPC_CREAT|0777);
+   /* 0600 = user read+write */
+   dri_sw_dt->shmid = shmget(IPC_PRIVATE, size, IPC_CREAT | 0600);
    if (dri_sw_dt->shmid < 0)
       return NULL;
 
Index: lib/mesa/src/gallium/winsys/sw/xlib/xlib_sw_winsys.c
===================================================================
RCS file: /cvs/xenocara/lib/mesa/src/gallium/winsys/sw/xlib/xlib_sw_winsys.c,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 xlib_sw_winsys.c
--- lib/mesa/src/gallium/winsys/sw/xlib/xlib_sw_winsys.c	19 Feb 2019 03:47:27 -0000	1.1.1.3
+++ lib/mesa/src/gallium/winsys/sw/xlib/xlib_sw_winsys.c	20 Nov 2019 07:15:32 -0000
@@ -126,7 +126,8 @@ alloc_shm(struct xlib_displaytarget *buf
    shminfo->shmid = -1;
    shminfo->shmaddr = (char *) -1;
 
-   shminfo->shmid = shmget(IPC_PRIVATE, size, IPC_CREAT|0777);
+   /* 0600 = user read+write */
+   shminfo->shmid = shmget(IPC_PRIVATE, size, IPC_CREAT | 0600);
    if (shminfo->shmid < 0) {
       return NULL;
    }
Index: lib/mesa/src/mesa/drivers/x11/xm_buffer.c
===================================================================
RCS file: /cvs/xenocara/lib/mesa/src/mesa/drivers/x11/xm_buffer.c,v
retrieving revision 1.1.1.3
diff -u -p -r1.1.1.3 xm_buffer.c
--- lib/mesa/src/mesa/drivers/x11/xm_buffer.c	29 Jan 2019 10:50:11 -0000	1.1.1.3
+++ lib/mesa/src/mesa/drivers/x11/xm_buffer.c	20 Nov 2019 07:15:32 -0000
@@ -89,8 +89,9 @@ alloc_back_shm_ximage(XMesaBuffer b, GLu
       return GL_FALSE;
    }
 
+   /* 0600 = user read+write */
    b->shminfo.shmid = shmget(IPC_PRIVATE, b->backxrb->ximage->bytes_per_line
-			     * b->backxrb->ximage->height, IPC_CREAT|0777);
+                             * b->backxrb->ximage->height, IPC_CREAT | 0600);
    if (b->shminfo.shmid < 0) {
       _mesa_warning(NULL, "shmget failed while allocating back buffer.\n");
       XDestroyImage(b->backxrb->ximage);
