/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.cca;

import de.rub.nds.x509attacker.filesystem.BinaryFileReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CcaFileManager {
    private static Logger LOGGER = LogManager.getLogger();
    private static Map<String, CcaFileManager> references = new HashMap<String, CcaFileManager>();
    private File fileDirectory;
    private final Map<String, byte[]> fileMap = new HashMap<String, byte[]>();

    private CcaFileManager(String fileDirectory) {
        this.init(fileDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CcaFileManager getReference(String fileDirectory) {
        if (references.get(fileDirectory) != null) return references.get(fileDirectory);
        Class<CcaFileManager> clazz = CcaFileManager.class;
        synchronized (CcaFileManager.class) {
            if (references.get(fileDirectory) != null) return references.get(fileDirectory);
            references.put(fileDirectory, new CcaFileManager(fileDirectory));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return references.get(fileDirectory);
        }
    }

    public void init(String fileDirectory) {
        if (this.fileMap.isEmpty()) {
            this.fileDirectory = new File(fileDirectory);
            this.readAllFiles();
        }
    }

    private void readAllFiles() {
        File[] files = this.fileDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                this.readFile(file);
            }
        }
    }

    private void readFile(File file) {
        try {
            BinaryFileReader binaryFileReader = new BinaryFileReader(file.getAbsolutePath());
            byte[] xmlFileContent = binaryFileReader.read();
            this.addFile(file.getName(), xmlFileContent);
        }
        catch (IOException e) {
            LOGGER.error("Encountered IOException when reading xmlInputFile. " + e);
        }
    }

    private void addFile(String filename, byte[] content) {
        String sanitizedFilename = this.sanitizeFileName(filename);
        if (!this.fileMap.containsKey(sanitizedFilename)) {
            this.fileMap.put(sanitizedFilename, content);
        }
    }

    private String sanitizeFileName(String filename) {
        return filename.trim();
    }

    public byte[] getFileContent(String filename) {
        String sanitizedFilename = this.sanitizeFileName(filename);
        if (this.fileMap.containsKey(sanitizedFilename)) {
            return this.fileMap.get(sanitizedFilename);
        }
        LOGGER.error("XML file " + filename + " is not available in XmlFileManger!");
        return null;
    }
}

