/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.api;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.jboss.galleon.api.ConfigurationId;
import org.jboss.galleon.api.GalleonArtifactCoordinate;
import org.jboss.galleon.util.StringUtils;

public class GalleonFeaturePack
implements GalleonArtifactCoordinate {
    private String groupId;
    private String artifactId;
    private String version;
    private String type = "zip";
    private String classifier;
    private String extension = "zip";
    private boolean transitiveDep;
    private String location;
    private Boolean inheritConfigs;
    private Set<ConfigurationId> includedConfigs = Collections.emptySet();
    private Set<ConfigurationId> excludedConfigs = Collections.emptySet();
    private Boolean inheritPackages;
    private Set<String> excludedPackages = Collections.emptySet();
    private Set<String> includedPackages = Collections.emptySet();
    private Path path;

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.assertGalleon1Location();
        this.groupId = groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.assertGalleon1Location();
        this.artifactId = artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.assertGalleon1Location();
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.assertGalleon1Location();
        this.type = type;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.assertGalleon1Location();
        this.classifier = classifier;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.assertGalleon1Location();
        this.extension = extension;
    }

    public boolean isTransitive() {
        return this.transitiveDep;
    }

    public void setTransitive(boolean transitiveDep) {
        this.transitiveDep = transitiveDep;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.assertGalleon2Location();
        this.location = location;
    }

    public Boolean isInheritPackages() {
        return this.inheritPackages;
    }

    public void setInheritPackages(Boolean inheritPackages) {
        this.inheritPackages = inheritPackages;
    }

    public Boolean isInheritConfigs() {
        return this.inheritConfigs;
    }

    public void setInheritConfigs(Boolean inheritConfigs) {
        this.inheritConfigs = inheritConfigs;
    }

    public Set<ConfigurationId> getIncludedConfigs() {
        return this.includedConfigs;
    }

    public void setIncludedConfigs(Set<ConfigurationId> includedConfigs) {
        this.includedConfigs = includedConfigs;
    }

    public Set<ConfigurationId> getExcludedConfigs() {
        return this.excludedConfigs;
    }

    public void setExcludedConfigs(Set<ConfigurationId> excludedConfigs) {
        this.excludedConfigs = excludedConfigs;
    }

    public Set<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(Set<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public Set<String> getIncludedPackages() {
        return this.includedPackages;
    }

    public void setIncludedPackages(Set<String> includedPackages) {
        this.includedPackages = includedPackages;
    }

    public void setPath(File path) {
        this.assertPathLocation();
        this.path = path.toPath().normalize();
    }

    public Path getNormalizedPath() {
        return this.path;
    }

    public String getMavenCoords() {
        String type;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getGroupId()).append(":").append(this.getArtifactId());
        String string = type = this.getExtension() == null ? this.getType() : this.getExtension();
        if (this.getClassifier() != null || type != null) {
            builder.append(":").append(this.getClassifier() == null ? "" : this.getClassifier()).append(":").append(type == null ? "" : type);
        }
        if (this.getVersion() != null) {
            builder.append(":").append(this.getVersion());
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        if (this.transitiveDep) {
            buf.append("transitive ");
        }
        if (this.location != null) {
            buf.append(this.location);
        } else {
            buf.append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        }
        buf.append(" inherit-packages=").append(this.inheritPackages);
        if (!this.includedPackages.isEmpty()) {
            buf.append(" included-packages=");
            StringUtils.append(buf, this.includedPackages);
        }
        if (!this.excludedPackages.isEmpty()) {
            buf.append(" excluded-packages=");
            StringUtils.append(buf, this.excludedPackages);
        }
        buf.append(" inherit-configs=").append(this.inheritConfigs);
        if (!this.includedConfigs.isEmpty()) {
            buf.append(" included-configs=");
            StringUtils.append(buf, this.includedConfigs);
        }
        if (!this.excludedConfigs.isEmpty()) {
            buf.append(" excluded-configs=");
            StringUtils.append(buf, this.excludedConfigs);
        }
        return buf.append('}').toString();
    }

    private void assertPathLocation() {
        if (this.groupId != null || this.artifactId != null || this.version != null) {
            throw new IllegalStateException("feature-pack Path cannot be used: Galleon 1.x feature-pack Maven coordinates have already been initialized");
        }
        if (this.location != null) {
            throw new IllegalStateException("feature-pack Path cannot be used: Galleon 2.x location has already been initialized");
        }
    }

    private void assertGalleon2Location() {
        if (this.groupId != null || this.artifactId != null || this.version != null) {
            throw new IllegalStateException("Galleon 2.x location cannot be used: feature-pack Maven coordinates have already been initialized");
        }
        if (this.path != null) {
            throw new IllegalStateException("Galleon 2.x location cannot be used: feature-pack Path has already been initialized");
        }
    }

    private void assertGalleon1Location() {
        if (this.location != null) {
            throw new IllegalStateException("Galleon 1.x feature-pack Maven coordinates cannot be used: Galleon 2.x feature-pack location has already been initialized");
        }
        if (this.path != null) {
            throw new IllegalStateException("Galleon 1.x feature-pack Maven coordinates cannot be used: feature-pack Path has already been initialized");
        }
    }
}

