/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ScrollThread;
import net.sf.freecol.common.model.Direction;

public final class Scrolling
extends FreeColClientHolder {
    protected static final int AUTO_SCROLL_SPACE = 4;
    private static final int DRAG_SCROLL_SPACE = 100;
    private final Canvas canvas;
    private volatile ScrollThread scrollThread = null;
    private volatile Object scrollThreadLock = new Object();

    public Scrolling(FreeColClient freeColClient, Canvas canvas) {
        super(freeColClient);
        this.canvas = canvas;
    }

    public void performAutoScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.getClientOptions().getBoolean("model.option.autoScroll")) {
            int autoScrollSpace = this.getGUI().getFixedImageLibrary().scaleInt(4);
            this.scroll(e, autoScrollSpace);
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    public void performDragScrollIfActive(MouseEvent e) {
        if (e.getComponent().isEnabled() && this.getClientOptions().getBoolean("model.option.mapScrollOnDrag")) {
            int dragScrollSpace = this.getGUI().getFixedImageLibrary().scaleInt(100);
            this.scroll(e, dragScrollSpace);
        } else {
            this.stopScrollIfScrollIsActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopScrollIfScrollIsActive() {
        if (this.scrollThread != null) {
            Object object = this.scrollThreadLock;
            synchronized (object) {
                this.scrollThread.abort();
                this.scrollThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scroll(MouseEvent e, int scrollSpace) {
        Point panePoint = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this.getRootComponent());
        Direction direction = this.getScrollDirection(panePoint.x, panePoint.y, scrollSpace);
        if (direction == null) {
            this.stopScrollIfScrollIsActive();
        }
        Object object = this.scrollThreadLock;
        synchronized (object) {
            if (this.scrollThread != null && !this.scrollThread.isAborted()) {
                this.scrollThread.setDirection(direction);
                return;
            }
            this.stopScrollIfScrollIsActive();
            this.scrollThread = new ScrollThread(this.getFreeColClient());
            this.scrollThread.setDirection(direction);
            this.scrollThread.start();
        }
    }

    private Direction getScrollDirection(int x, int y, int scrollSpace) {
        Dimension size = this.getRootComponent().getSize();
        Direction ret = x < scrollSpace && y < scrollSpace ? Direction.NW : (x >= size.width - scrollSpace && y < scrollSpace ? Direction.NE : (x >= size.width - scrollSpace && y >= size.height - scrollSpace ? Direction.SE : (x < scrollSpace && y >= size.height - scrollSpace ? Direction.SW : (y < scrollSpace ? Direction.N : (x >= size.width - scrollSpace ? Direction.E : (y >= size.height - scrollSpace ? Direction.S : (x < scrollSpace ? Direction.W : null)))))));
        return ret;
    }

    private Component getRootComponent() {
        return this.canvas.getParentFrame().getRootPane();
    }
}

