##########################################################################
# This file is part of Vacuum Magic
# Copyright (C) 2008 by UPi <upi at sourceforge.net>
##########################################################################

use strict;

=comment
How do Player objects relate to Guy objects?

* Player keeps track of color, keys, score and respawning.
* Guy is the game object that flies around the screen.
* $guy->{player} references the Player object.
=cut


sub InitPlayers {
  my ($i, $player, @guyColors);
  @guyColors = ( [0,0,1,1], [1,0,0,1], [0,1,0,1], [1,1,0,1], [0,1,1,1], [1,0,1,1] );

  @Players = (
    { 'keys'  => [SDLK_LEFT, SDLK_RIGHT, SDLK_UP, SDLK_DOWN, SDLK_SPACE], }, # blue
    { 'keys'  => [SDLK_a, SDLK_d, SDLK_w, SDLK_s, SDLK_q], },         # red
    { 'keys'  => [SDLK_g, SDLK_j, SDLK_y, SDLK_h, SDLK_t], },         # green
    { 'keys'  => [SDLK_KP6, SDLK_KP4, SDLK_KP8, SDLK_KP2, SDLK_KP5], },   # yellow
    { 'keys'  => [SDLK_KP6, SDLK_KP4, SDLK_KP8, SDLK_KP2, SDLK_KP5], },   # cyan
    { 'keys'  => [SDLK_KP6, SDLK_KP4, SDLK_KP8, SDLK_KP2, SDLK_KP5], },   # purple
  );
  
  for (my $i=0; $i<=$#Players; ++$i) {
    $player = $Players[$i];
    $player->{number} = $i;
    $player->{color} = $guyColors[$i];
    bless $player, 'Player';
  }
}



package Player;


sub Reset {
  my ($self) = @_;
  
  $self->{score} = 0;
  $self->{scoreForBonusLife} = $self->{bonusLifeInterval} = 500000;
  $self->{ballsVacuumed} = $self->{enemiesVacuumed} = $self->{enemiesShot} = 0;
  $self->{lives} = 4;
  $self->{respawnDelay} = 0;
  new Guy(player=>$self)->Spawn();
}

sub GiveScore {
  my ($self, $score) = @_;
  
  $self->{score} += $score;
  if ($self->{score} >= $self->{scoreForBonusLife}) {
    $self->{scoreForBonusLife} += $self->{bonusLifeInterval};
    $self->{lives} += 1;
    $::Game->PlaySound('bonuslife');
  }
}

1;